<?php

namespace App\Http\Traits;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Twilio\Rest\Client;
use App\Models\AppSetting;
use App\Models\User;

trait TwilioTrait
{
    public function twilio_create_services($message='Twilio'){
       try {
            $sid = AppSetting::get_setting('twilio_account_sid');
            $token = AppSetting::get_setting('twilio_auth_token');
            $twilio = new Client($sid, $token);
            $service = $twilio->verify->v2->services->create($message);
            return $service->sid;
        } catch (\Exception $e) {
            Log::info('Error:' . $e->getMessage());
            return false;
        }
    }

    public function twilio_create_sms_otp($service_id, $mobile){
        try {
            
            $phone = preg_replace('/\s+/', '', $mobile);
            $user = User::withTrashed()->where('phone', $phone)->first();
            
            if($user){
                $postUpdate = [
                    'is_verified' => 0,
                    'otp' => null
                ];
                User::where('id', $user->id)->update($postUpdate);
            }
             
            $sid = AppSetting::get_setting('twilio_account_sid');
            $token = AppSetting::get_setting('twilio_auth_token');
            $twilio = new Client($sid, $token);
            $twilio->verify->v2->services($service_id)
                                   ->verifications
                                   ->create($mobile, "sms");
        } catch (\Exception $e) {
            Log::info('Error:' . $e->getMessage());
            dd('Error: ' . $e->getMessage());
            return false;
        }
    }

    public function twilio_verify_otp($service_id, $mobile, $otp)
    {
        try {
            $sid = AppSetting::get_setting('twilio_account_sid');
            $token = AppSetting::get_setting('twilio_auth_token');
            $twilio = new Client($sid, $token);
    
            // Ensure the service exists before attempting verification
            $service = $twilio->verify->v2->services($service_id)->fetch();
            if (!$service) {
                Log::info('Service SID is invalid.');
                return ['error' => 'Invalid Service SID'];
            }
    
            // Proceed with OTP verification
            $verification = $twilio->verify->v2->services($service_id)->verificationChecks->create([
                "to" => $mobile,
                "code" => $otp
            ]);
    
            return $verification;
        } catch (\Exception $e) {
            Log::info('Error:' . $e->getMessage());
            return ['error' => 'Failed to verify OTP'];
        }
    }


}