<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class Authenticate
{
    public function handle($request, Closure $next)
    {
        // Check if the user is authenticated
        if (Auth::check()) {
            // Check if the user has the admin role (you need to adjust this based on your actual roles setup)
            if (Auth::user()->type == 'admin') {
                // User has admin role, allow access to admin pages
                return $next($request);
            }else if (Auth::user()->type == 'subadmin') {
                // User has admin role, allow access to admin pages
                return $next($request);
            } else {
                // User does not have admin role, log them out and redirect to admin login
                Auth::logout();
                return redirect('admin-login');
            }
        }

        // If the user is not authenticated, redirect to the login page
        return redirect('admin-login');
    }
}

// namespace App\Http\Middleware;

// use Illuminate\Auth\Middleware\Authenticate as Middleware;

// class Authenticate extends Middleware
// {
//     /**
//      * Get the path the user should be redirected to when they are not authenticated.
//      *
//      * @param  \Illuminate\Http\Request  $request
//      * @return string|null
//      */
//     protected function redirectTo($request)
//     {
//         if (! $request->expectsJson()) {
//             return route('login');
//         }
//     }
// }
