<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Cart;
use App\Models\UserAuthLogin;
use App\Models\UserWallet;
use App\Models\DeliveryAddresses;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = User::getLists('user');
        $filter = array();
        // Add the new status to the filters
        $filter['status'] = \Helpers::getStatusType();
        return view('users.index',compact('data'))->with('filter',$filter);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = Role::pluck('name','name')->all();
        return view('users.create',compact('roles'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
        'email' => 'unique:users',
        'phone' => 'unique:users|numeric|digits:10',
        ]);

        $input = $request->all();
        $input['password'] = Hash::make($input['password']);

        if(isset($input['country_code']) && $input['country_code']!=''){
           $input['phone'] = $input['country_code'].''.$input['phone'];
        }

        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/users/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }
        $user = User::create($input);
        return redirect()->route('users.index')
                        ->with('success',__('lang.message_record_created_successfully'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::find($id);

        return view('users.edit',compact('user'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $validatedData = $request->validate([
            'email' => [
            'required',
            // Rule::unique('users')->ignore($id),
            ],
            'phone' => [
            'required',
            // 'numeric',
            // 'digits:10',
            // Rule::unique('users')->ignore($id),
            ],
            'name' => 'required',
        ]);

        $input = $request->all();
        if (empty($input['password'])) {
            unset($input['password']);
        } else {
            $input['password'] = Hash::make($input['password']);
        }

        if(isset($input['country_code']) && $input['country_code']!=''){
           $input['phone'] = $input['country_code'].''.$input['phone'];
        }
        $user = User::find($id);
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/users/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }else{
            unset($input['image']);
        }
        $user->update($input);
        if ($user->type == 'admin'){
            return redirect()->route('users.profile')
                        ->with('success',__('lang.message_profile_updated_successfully'));
        }else{
            return redirect()->route('users.index')
                        ->with('success',__('lang.message_record_updated_successfully'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::find($id)->delete();
        return redirect()->route('users.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
    }

    /**
     * Display a user profile.
     *
     * @param
     * @return Response
     */
    public function profile()
    {
        $id = Auth::user()->id;
        $user = User::find($id);
        unset($user->password);
        return view('users.profile', compact(['user']));
    }

    function doVerifyOtp(Request $request)
    {
        $post = $request->all();
        $this->validate($request, [
            'phone_number' => 'required'
        ]);
        $user = User::where(['phone' => $post['phone_number']])->first();
        if($user){
            Auth::loginUsingId($user->id);
            $user = Auth::user();
            $success = array();
            $success['token'] =  \Helpers::generateApiToken();
            $postUpdate = array(
                'is_verified' => 1
            );
            User::where('id', $user->id)->update($postUpdate);
            $cartCount = Cart::where('user_id',$user->id)->count();
            Session::put('total_cart', $cartCount);
            return redirect('/profile')->with('success','Login successfully');
        }
        else{
            return redirect()->back()->with('error','Login details are invalid!');
        }
    }

    public function changeStatus($id){
        $data = User::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        return redirect()->route('users.index')
                        ->with('success',__('lang.message_status_updated_successfully'));
    }

    public function userWalletLists(Request $request, $id)
    {
        $user = User::find($id);
        $data = UserWallet::getUserWalletLists($id);
        return view('users.wallet',compact('data'))->with("user",$user);
    }

    public function doSubmituserWallet(Request $request, $id)
    {
        $post = $request->all();

        request()->validate([
            'amount' => 'required',
            'description' => 'required',
            'type' => 'required',
        ]);
        $input = $request->all();

        $postData = array(
            'user_id' => $id,
            'description' => $input['description'],
            'type' => $input['type'],
            'created_at' => date("Y-m-d H:i:s")
        );
        if($input['type']=='debit'){
            $postData['amount'] = '-'.$input['amount'];
        }else{
            $postData['amount'] = $input['amount'];
        }

        UserWallet::insert($postData);

        return redirect()->back()->with('success',__('lang.message_wallet_transaction_submited_successfully'));
    }
    
    
    public function userAddresses(Request $request, $id)
    {
        $data['data'] = DeliveryAddresses::getLists($id);
        return view('users.address',$data);
    }
}
?>
