<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Timeslots;
use App\Models\TimeslotsTranslation;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;

class TimeslotController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(isset($_GET['status']) && $_GET['status']!=''){
            if($_GET['status'] == 'active'){
               $status = 1;
            }else{
               $status = 0;
            }
            $data = Timeslots::where('status',$status)->with('translation')->orderBy('id','DESC')->get();
        }else{
            $data = Timeslots::with('translation')->orderBy('id','DESC')->get();
        }
        
        $filter = array();
        $filter['status'] = \Helpers::getStatusType();
        return view('timeslots.index',compact('data'))->with('filter',$filter);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        Timeslots::create($input);
    
        return redirect()->route('timeslots.index')
                        ->with('success',__('lang.message_record_created_successfully'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Timeslots::find($id);
    
        return view('timeslots.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $timeslot = Timeslots::find($id);
        $timeslot->update($input);
        return redirect()->route('timeslots.index')
                        ->with('success',__('lang.message_record_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Timeslots::find($id)->delete();
        return redirect()->route('timeslots.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
    }

    public function translation($id)
    {
        $data = Timeslots::find($id);
        $languages = Languages::where('status',1)->get();
        foreach ($languages as $row) {
            $row->details = TimeslotsTranslation::where('timeslot_id',$id)->where('lang_code',$row->language_code)->first();
            if(!$row->details){
                $postData = array(
                    'timeslot_id' => $id,
                    'lang_code' => $row->language_code,
                    'name' => $data->name,
                    'created_at' => date("Y-m-d H:i:s")
                );
                TimeslotsTranslation::insert($postData);
                $row->details = TimeslotsTranslation::where('timeslot_id',$id)->where('lang_code',$row->language_code)->first();
            }
        }
        return view('timeslots.translation',compact('data'))->with('languages',$languages);
    }

    public function updateTranslation($id,Request $request)
    {
        $post = $request->all();

        request()->validate([
            'language_code' => 'required',
            'name' => 'required',
        ]);
        $input = $request->all();

        for ($i=0; $i < count($input['language_code']); $i++) { 
            if($input['language_code'][$i] == 'en'){
                $updateData = array(
                    'name' => $input['name'][$i]
                );
                Timeslots::where('id',$id)->update($updateData);
            }

            $postData = array(
                'lang_code' => $input['language_code'][$i],
                'name' => $input['name'][$i],
                'updated_at' => date("Y-m-d H:i:s")
            );
            TimeslotsTranslation::where('id',$input['translation_id'][$i])->update($postData);
        }
        
        return redirect()->route('timeslots.index')
                        ->with('success',__('lang.message_translation_updated_successfully'));
    }

    public function changeStatus($id){
        $data = Timeslots::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }

        return redirect()->route('timeslots.index')
                        ->with('success',__('lang.message_status_updated_successfully'));
    }
}
