<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Cart;
use App\Models\UserAuthLogin;
use App\Models\UserWallet;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use App\Models\Role;
use Illuminate\Validation\Rule;

class SubAdminController extends Controller
{
    /**
     * Display a listing of the data.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    */
    public function index(Request $request)
    {
        try {
            $result['data'] = User::getSubadminList($request->all());
            $result['roles'] = Role::where('name','!=','Admin')->where('status',1)->get();

            $filter = array();
            // Add the new status to the filters
            $filter['status'] = \Helpers::getStatusType();

            return view('subadmins.index',$result)->with('filter',$filter);
        } catch (\Exception $ex) {
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile());
        }
    }

    /**
     * Store a newly created resource in data.
     *
     * @param  \App\Http\Requests\StoreSubAdminRequest  $request
     * @return \Illuminate\Http\Response
    **/
    public function store(Request $request)
    {

        request()->validate([
            'email' => 'unique:users',
            'phone' => 'unique:users|numeric|digits:10',
        ]);
    
        $input = $request->all();
        $input['password'] = Hash::make($input['password']);    
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/users/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }
        $user = User::create($input);

        $user->assignRole($input['role_id']);

        return redirect()->route('sub-admin.index')
                        ->with('success',__('lang.message_record_created_successfully'));
    }

    /**
     * Update the specified data in storage.
     *
     * @param  \App\Http\Requests\UpdateSubAdminRequest  $request
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function update(Request $request)
    {
        $id = $request->id;
        $validatedData = $request->validate([
            'email' => [
            'required',
            Rule::unique('users')->ignore($id),
            ],
            'phone' => [
            'required',
            'numeric',
            'digits:10',
            Rule::unique('users')->ignore($id),
            ],
        ]);

        $input = $request->all();
        if (empty($input['password'])) {
            unset($input['password']);
        } else {
            $input['password'] = Hash::make($input['password']);
        }
        $id = $input['id'];
        $user = User::find($id);
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/users/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }else{
            unset($input['image']);
        }
        $user->update($input);
        $user->assignRole($input['role_id']);
        return redirect()->route('sub-admin.index')
                        ->with('success',__('lang.message_record_updated_successfully'));
    }

    /**
     * Remove the specified resource from data.
     *
     * @param  $id
     * @return \Illuminate\Http\Response
    */
    public function destroy($id)
    {
        User::find($id)->delete();
        return redirect()->route('sub-admin.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
    }

    
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $subadmin = User::find($id);
        $roles = Role::where('name','!=','Admin')->where('status',1)->get();
    
        return view('subadmins.edit',compact('subadmin','roles'));
    }

    /**
     * update the specified column from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function updateColumn($id,)
    {
       $data = User::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        return redirect()->route('sub-admin.index')
                        ->with('success',__('lang.message_status_updated_successfully'));
    }

}
