<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;
require __DIR__.'/../../../vendor/razorpay-php/Razorpay.php';
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Razorpay\Api\Api;
use App\Models\CmsPages;
use App\Models\CmsPagesTranslation;
use App\Models\Contactus;
use App\Models\User;
use App\Models\DeliveryAddresses;
use App\Models\OrderProductsDelivery;
use App\Models\DeliveryAreas;
use App\Models\Order;
use App\Models\Cart;
use App\Models\Product;
use App\Models\ProductTranslation;
use App\Models\UserPayment;
use App\Models\UserCards;
use App\Models\Banners;
use App\Models\BannerTranslation;
use App\Models\Coupon;
use App\Models\CouponTranslation;
use App\Models\Timeslots;
use App\Models\TimeslotsTranslation;
use App\Models\UserWallet;
use App\Models\CardDetails;
use App\Models\OrderProduct;
use App\Models\OrderCancelRequest;
use App\Models\Partners;
use App\Models\City;
use App\Models\State;
use App\Models\NonWorkingDays;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Auth;
use Stripe\PaymentIntent;
use KingFlamez\Rave\Facades\Rave as Flutterwave;
use Srmklive\PayPal\Services\ExpressCheckout;
use Srmklive\PayPal\Services\PayPal as PayPalClient;
use Anand\LaravelPaytmWallet\Facades\PaytmWallet;
use App\Models\AppSetting;
use Paytm\Checksum\PaytmChecksum;
use Instamojo\Instamojo;
use Exception;
use Illuminate\Support\Facades\Redirect;
use Paystack;
use Ixudra\Curl\Facades\Curl;
use App\Http\Controllers\PaymentGateway\PayPalController as paypalPayment;
use App\Http\Controllers\PaymentGateway\FlutterwaveController as flutterwavePayment;
use App\Http\Controllers\PaymentGateway\PaystackController as paystackPayment;
use App\Http\Controllers\PaymentGateway\PhonePeController as phonepePayment;
use App\Http\Controllers\PaymentGateway\InstamojoController as instamojoPayment;
use App\Http\Controllers\PaymentGateway\StripePaymentController as stripePayment;
use App\Http\Controllers\PaymentGateway\RazorpayController as razorpayPayment;
use App\Http\Controllers\PaymentGateway\LiqPayController as liqpayPayment;
use Stripe;
use App\Services\FirebaseNotificationService;
use App\Notifications\FcmNotification;
use Illuminate\Support\Facades\Storage;
use App\Services\LiqPayService;
use Illuminate\Support\Facades\DB;


class SiteController extends Controller
{
    private $language;
    public function __construct(Request $request)
    {
        // parent::__construct();
        $this->request = $request;
        $this->language =  (isset($_COOKIE['lang_code']))?$_COOKIE['lang_code'] != '' ? $_COOKIE['lang_code'] : 'en':'en';
    }

    public function yourcallback(Request $request)
    {
        $post = $request->all();
        echo json_encode($post);exit;
    }


    public function yourpage(Request $request)
    {
        $post = $request->all();
        echo json_encode($post);exit;
    }

    public function index(Request $request)
    {
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }

        $allproducts = Product::where('status',1)->orderBy('created_at','DESC')->get();
        foreach ($allproducts as $row) {
            $row['cart_info'] = Cart::where('user_id',$user_id)->where('product_id',$row['id'])->first();
            $translated_data = ProductTranslation::where('lang_code',$this->language)->where('product_id',$row['id'])->first();
            if($translated_data){
                if($translated_data->name!=''){
                    $row['name'] = $translated_data->name;
                }
                if($translated_data->description!=''){
                    $row['description'] = $translated_data->description;
                }
            }
        }
        $banners = Banners::where('status',1)->where('banner_type','website')->get();
        foreach ($banners as $bannerRow) {
            $translated_data = BannerTranslation::where('lang_code',$this->language)->where('banner_id',$bannerRow['id'])->first();
            if($translated_data){
                if($translated_data->title!=''){
                    $bannerRow['title'] = $translated_data->title;
                }
                if($translated_data->sub_title!=''){
                    $bannerRow['sub_title'] = $translated_data->sub_title;
                }
            }
        }
        /* for cart popup */
        $response = array();
        $cartData = Cart::where('user_id',$user_id)->with('product')->get();

        $total = array(
            'subtotal' => 0,
            'tax' => 0,
            'delivery_fee' => 0,
            'is_coupon_applied' => 0,
            'promotional_disount' => 0,
            'coupon_code' => '',
            'final_amount' => 0
        );

        foreach($cartData as $cart){
            if($cart->product){
                $translated_data = ProductTranslation::where('lang_code',$this->language)->where('product_id',$cart->product_id)->first();
                if($translated_data){
                    if($translated_data->name!=''){
                        $cart->product->name = $translated_data->name;
                    }
                    if($translated_data->description!=''){
                        $cart->product->description = $translated_data->description;
                    }
                }
                $total['subtotal'] = $total['subtotal'] + $cart->total_delivery_amount;
                array_push($response, $cart);
            }else{
                Cart::where('user_id',$cart->id)->delete();
            }
        }
        $total['subtotal'] = round($total['subtotal'],2);
        $total['delivery_fee'] = ($total['subtotal']<setting('minimum_order_value'))?setting('shipping_charge'):0;
        $total['tax'] = round((($total['subtotal'] * setting('default_tax')) / 100),2);
        $total['final_amount'] = round(($total['subtotal'] + $total['delivery_fee'] + $total['tax']),2);

        if(Session()->has('coupon_id')){
            $coupon_id = Session()->get('coupon_id');
            $code = Coupon::where('end_date','>=',date("Y-m-d"))->where('start_date','<=',date("Y-m-d"))->where('minimum_order_value','<=',$total['subtotal'])->where('status',1)->where('id',$coupon_id)->first();
            if($code){
                $total['is_coupon_applied'] = 1;
                $total['coupon_code'] = $code->coupon_name;
                if($code->type=='Fixed'){
                    if($code->value>$total['subtotal']){
                        $code->value = $total['subtotal'];
                    }
                    $total['promotional_disount'] = $code->value;
                }else{
                    $total['promotional_disount'] = round((($total['subtotal'] * $code->value) / 100),2);
                }
                Session::put('is_coupon_applied', $total['is_coupon_applied']);
                Session::put('coupon_code', $total['coupon_code']);
                Session::put('promotional_disount', $total['promotional_disount']);
            }
        }
        $total['final_amount'] = $total['final_amount'] - $total['promotional_disount'];

        $cartCount = Cart::where('user_id',$user_id)->count();
        Session::put('total_cart', $cartCount);

        $allcodes = Coupon::where('end_date','>=',date("Y-m-d"))->where('start_date','<=',date("Y-m-d"))->where('minimum_order_value','<=',$total['subtotal'])->where('status',1)->get();


        $holdaysDate = NonWorkingDays::where('status',1)->get();
        return view('index')->with('products',$allproducts)->with('banners',$banners)->with('data',$response)->with('coupon',$allcodes)->with('total',$total)->with('holdaysDate',$holdaysDate);
    }

    public function signin(Request $request)
    {
        $requireSetting=  Config::get('app.requireSetting');
        $settings = AppSetting::whereIn('key', $requireSetting)->get();
        // Transform the settings to a key-value pair array
        $settingsArray = $settings->pluck('value', 'key')->toArray();
        foreach($requireSetting as $set){
            if(!isset($settingsArray['enable_test_mode'])){
                $settingsArray['enable_test_mode']=1;
            }elseif(empty($settingsArray['countryCodes'])){
                $settingsArray['countryCodes']= json_encode(['in','us']);
            }elseif(empty($settingsArray[$set])){
                array_push($settingsArray,[$set=>0]);
            }
        }

        // Pass the settings to the view
        return view('signin', compact('settingsArray'));
    }

    public function signup(Request $request)
    {
        return view('register');
    }

    public function cart(Request $request)
    {
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }
        $response = array();
        $cartData = Cart::where('user_id',$user_id)->with('product')->get();

        $total = array(
            'subtotal' => 0,
            'tax' => 0,
            'delivery_fee' => 0,
            'is_coupon_applied' => 0,
            'promotional_disount' => 0,
            'coupon_code' => '',
            'final_amount' => 0
        );

        foreach($cartData as $cart){
            if($cart->product){
                $translated_data = ProductTranslation::where('lang_code',$this->language)->where('product_id',$cart->product_id)->first();
                if($translated_data){
                    if($translated_data->name!=''){
                        $cart->product->name = $translated_data->name;
                    }
                    if($translated_data->description!=''){
                        $cart->product->description = $translated_data->description;
                    }
                }
                $total['subtotal'] = $total['subtotal'] + $cart->total_delivery_amount;
                array_push($response, $cart);
            }else{
                Cart::where('user_id',$cart->id)->delete();
            }
        }
        $total['subtotal'] = round($total['subtotal'],2);
        $total['delivery_fee'] = ($total['subtotal']<setting('minimum_order_value'))?setting('shipping_charge'):0;
        $total['tax'] = round((($total['subtotal'] * setting('default_tax')) / 100),2);
        $total['final_amount'] = round(($total['subtotal'] + $total['delivery_fee'] + $total['tax']),2);

        if(Session()->has('coupon_id')){
            $coupon_id = Session()->get('coupon_id');
            $code = Coupon::where('end_date','>=',date("Y-m-d"))->where('start_date','<=',date("Y-m-d"))->where('minimum_order_value','<=',$total['subtotal'])->where('status',1)->where('id',$coupon_id)->first();
            if($code){
                $total['is_coupon_applied'] = 1;
                $total['coupon_code'] = $code->coupon_name;
                if($code->type=='Fixed'){
                    if($code->value>$total['subtotal']){
                        $code->value = $total['subtotal'];
                    }
                    $total['promotional_disount'] = $code->value;
                }else{
                    $total['promotional_disount'] = round((($total['subtotal'] * $code->value) / 100),2);
                }
                Session::put('is_coupon_applied', $total['is_coupon_applied']);
                Session::put('coupon_code', $total['coupon_code']);
                Session::put('promotional_disount', $total['promotional_disount']);
            }
        }
        $total['final_amount'] = $total['final_amount'] - $total['promotional_disount'];

        $cartCount = Cart::where('user_id',$user_id)->count();
        Session::put('total_cart', $cartCount);

        $allcodes = Coupon::where('end_date','>=',date("Y-m-d"))->where('start_date','<=',date("Y-m-d"))->where('minimum_order_value','<=',$total['subtotal'])->where('status',1)->get();


        $holdaysDate = NonWorkingDays::where('status',1)->get();
        return view('cart')->with('data',$response)->with('coupon',$allcodes)->with('total',$total)->with('holdaysDate',$holdaysDate);
    }

    public function doCheckout(Request $request)
    {
        $post = $request->all();

        if($post['cart_id'][0]==-1){
           $cart_id=$this->addToCart($request);
           $post['order_frequency_' . $cart_id] = $post['order_frequency_' . $post['cart_id'][0]];
           $post['days_'. $cart_id] =  $post['days_'.$post['cart_id'][0]] ?? "";
           $post['cart_id'][0]=$cart_id;
           $cartIds[] = $cart_id;
        }else{
            $cartIds = $post['cart_id'] ?? [];
        }
        //$cartIds = $post['cart_id'] ?? [];
        $minimum_order_value=AppSetting::get_setting('minimum_order_value');

        $totalCartAmount = 0;
        // Check if cart IDs are provided

        if (empty($cartIds)) {
            return redirect('/cart')->with(['error' => 'No cart IDs provided. Please add items to your cart.']);
        }
        // Retrieve all carts in one query
        $cartInfos = Cart::whereIn('id', $cartIds)->get();
        // Check if any carts were found
        if ($cartInfos->isEmpty()) {
            return redirect('/cart')->with(['error' => 'No valid carts found.']);
        }
        // Calculate total delivery amount for all carts
        foreach ($cartInfos as $cartInfo) {
            $totalCartAmount += $cartInfo->total_delivery_amount;
            $tax = round((($totalCartAmount * setting('default_tax')) / 100),2);
            $totalAmount_with_tax=$totalCartAmount+$tax;
        }
        if ($post['submit_button'] == 'next') {
            // Check if any individual cart's total is less than the minimum order value
            foreach ($cartInfos as $cartInfo) {
                if ($totalAmount_with_tax < $minimum_order_value && !session()->has('minimum_order_warning_shown')) {
                    // Check if the message has already been shown to the user
                        // Set session to mark that the message has been shown
                        session(['minimum_order_warning_shown' => true]);
                        // Redirect to cart with the message
                        return redirect('/cart')->with([
                            'error' => 'Your cart amount with included tax is ' .
                                    AppSetting::get_setting('default_currency_code') .
                                    $totalAmount_with_tax .
                                    ', which is less than the required minimum order value of ' .
                                    AppSetting::get_setting('default_currency_code') .
                                    $minimum_order_value .
                                    '. Please add more items to your cart for free shipping or continue to checkout process to click on next button.'
                        ]);

                }
            }
        }
        session()->forget('minimum_order_warning_shown');
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }
        $disabledWeekDays = array(-1);
        $holdaysDate = NonWorkingDays::where('status',1)->get();
        foreach ($holdaysDate as $rows) {
            $i = 0;
            $startDate = $rows->start_date;
            do{
                $currentDate = date("Y-m-d",strtotime($startDate.' + '.$i.' day'));
                array_push($disabledWeekDays, $currentDate);
                $i++;
            }while(strtotime($currentDate)<strtotime($rows->end_date));
        }
        for ($i=0; $i < count($post['cart_id']); $i++) {

            if($post['quantity'][$i]>0){
                $cartId = $post['cart_id'][$i];
                $cartInfo = Cart::where('id',$cartId)->first();
                if($cartInfo){
                    $order_frequency = isset($post['order_frequency_'.$cartId])?strtolower($post['order_frequency_'.$cartId]):'once';
                    $inject = array(
                        'quantity' => $post['quantity'][$i],
                        "order_frequency" => $order_frequency
                    );
                    if($order_frequency=='once'){
                        $inject['no_of_delivery'] = 1;
                        $inject['days'] = '';
                        if(!in_array(date("Y-m-d",strtotime($post['delivery_dates'][$i])), $disabledWeekDays))
                        {
                            $inject['delivery_dates'] = $post['delivery_dates'][$i];
                            $inject['per_delivery_amount'] = $cartInfo->per_item_amount * $post['quantity'][$i];
                            $inject['total_delivery_amount'] = $inject['per_delivery_amount'];
                            $inject['start_date'] = date("Y-m-d",strtotime($post['delivery_dates'][$i]));
                            $inject['end_date'] = date("Y-m-d",strtotime($post['delivery_dates'][$i]));
                            Cart::where('id',$cartId)->update($inject);
                        }
                        else
                        {
                            Session::flash('error',__('lang.admin_delivering_date_issues'));
                            return redirect()->to('cart');
                        }
                    }
                    else if($order_frequency=='daily')

                    {
                        $dates = explode("-",$post['delivery_dates'][$i]);
                        if(isset($dates[1])){
                            $inject['start_date'] = date("Y-m-d",strtotime(trim($dates[0])));
                            $inject['end_date'] = date("Y-m-d",strtotime(trim($dates[1])));
                            $inject['days'] = '';

                            $dc = 0;
                            $currentDate = $inject['start_date'];
                            $delivery_dates = array();
                            do{
                                $addDate = date("Y-m-d",strtotime($inject['start_date'].' + '.$dc.' day'));
                                if(!in_array(date("Y-m-d",strtotime($addDate)), $disabledWeekDays))
                                {
                                    array_push($delivery_dates, $addDate);
                                    $currentDate = date("Y-m-d",strtotime($inject['start_date'].' + '.$dc.' day'));
                                    $dc++;
                                }else{
                                    $currentDate = date("Y-m-d",strtotime($inject['start_date'].' + '.$dc.' day'));
                                    $dc++;
                                }
                            }while(strtotime($currentDate)<strtotime($inject['end_date']));

                            $inject['no_of_delivery'] = count($delivery_dates);
                            $inject['per_delivery_amount'] = $cartInfo->per_item_amount * $post['quantity'][$i];
                            $inject['total_delivery_amount'] = $inject['per_delivery_amount'] * $inject['no_of_delivery'];
                            $inject['delivery_dates'] = implode(",",$delivery_dates);
                            Cart::where('id',$cartId)->update($inject);
                        }else{
                            Session::flash('error', __('lang.alert_select_date_range_for_daily'));
                            return redirect()->to('cart');
                        }
                    }
                    else if($order_frequency=='weekly')
                    {
                        $dates = explode("-",$post['delivery_dates'][$i]);
                        if(isset($dates[1])){
                            $inject['start_date'] = date("Y-m-d",strtotime(trim($dates[0])));
                            $inject['end_date'] = date("Y-m-d",strtotime(trim($dates[1])));
                            $days = (isset($post['days_'.$cartId]))?$post['days_'.$cartId]:[];
                            $weekDays = array(
                                'mon' => 1,
                                'tue' => 2,
                                'wed' => 3,
                                'thu' => 4,
                                'fri' => 5,
                                'sat' => 6,
                                'sun' => 0
                            );
                            $days_array = array();
                            foreach ($days as $key => $value) {
                                array_push($days_array,$weekDays[$key]);
                            }
                            $inject['days'] = implode(",",$days_array);
                            $dc = 0;
                            $count = 0;
                            $currentDate = $inject['start_date'];
                            $delivery_dates = array();
                            do{
                                $newDate = date("Y-m-d",strtotime($inject['start_date'].' + '.$dc.' day'));
                                if(in_array(date("w",strtotime($newDate)), $days_array)){
                                    if(!in_array(date("Y-m-d",strtotime($newDate)), $disabledWeekDays))
                                    {
                                        array_push($delivery_dates, $newDate);
                                    }
                                    $count++;
                                }
                                $currentDate = date("Y-m-d",strtotime($inject['start_date'].' + '.$dc.' day'));
                                $dc++;
                            }while(strtotime($currentDate)<strtotime($inject['end_date']));
                            $inject['no_of_delivery'] = count($delivery_dates);
                            $inject['per_delivery_amount'] = $cartInfo->per_item_amount * $post['quantity'][$i];
                            $inject['total_delivery_amount'] = $inject['per_delivery_amount'] * $inject['no_of_delivery'];
                            $inject['delivery_dates'] = implode(",",$delivery_dates);
                            Cart::where('id',$cartId)->update($inject);
                        }else{
                            Session::flash('error',  __('lang.alert_select_date_range_for_weekly'));
                            return redirect()->to('cart');
                        }
                    }
                    else if($order_frequency=='monthly')
                    {
                        $dates = explode(",",$post['delivery_dates'][$i]);
                        if(count($dates)>0){
                            $inject['start_date'] = date("Y-m-d",strtotime(trim($dates[0])));
                            $inject['end_date'] = date("Y-m-d",strtotime(trim($dates[count($dates)-1])));
                            $inject['days'] = '';
                            $inject['no_of_delivery'] = count($dates);
                            $inject['per_delivery_amount'] = $cartInfo->per_item_amount * $post['quantity'][$i];
                            $inject['total_delivery_amount'] = $inject['per_delivery_amount'] * $inject['no_of_delivery'];
                            $delivery_dates = array();
                            for ($dc=0; $dc <count($dates) ; $dc++) {
                                if(!in_array(date("Y-m-d",strtotime($dates[$dc])), $disabledWeekDays))
                                {
                                    array_push($delivery_dates, date("Y-m-d",strtotime($dates[$dc])));
                                }
                            }
                            $inject['delivery_dates'] = implode(",",$delivery_dates);
                            Cart::where('id',$cartId)->update($inject);
                        }else{
                            Session::flash('error', __('lang.alert_select_date_range_for_monthly'));
                            return redirect()->to('cart');
                        }
                    }
                    else if($order_frequency=='alternative')
                    {
                        $dates = explode("-",$post['delivery_dates'][$i]);
                        if(isset($dates[1])){
                            $inject['start_date'] = date("Y-m-d",strtotime(trim($dates[0])));
                            $inject['end_date'] = date("Y-m-d",strtotime(trim($dates[1])));
                            $inject['days'] = '';

                            $dc = 0;
                            $currentDate = $inject['start_date'];
                            $delivery_dates = array();
                            $count = 0;
                            do{
                                $newDate = date("Y-m-d",strtotime($inject['start_date'].' + '.$dc.' day'));
                                if(strtotime($inject['end_date'])>=strtotime($newDate)){
                                    if(!in_array(date("Y-m-d",strtotime($newDate)), $disabledWeekDays))
                                    {
                                        array_push($delivery_dates, $newDate);
                                        $currentDate = $newDate;
                                        $dc = $dc+2;
                                        $count++;
                                    }else{
                                        $currentDate = $newDate;
                                        $dc = $dc+1;
                                        $count++;
                                    }
                                }else{
                                    $currentDate = $newDate;
                                    $dc = $dc+2;
                                }
                            }while(strtotime($currentDate)<=strtotime($inject['end_date']));
                            $inject['no_of_delivery'] = count($delivery_dates);;
                            $inject['per_delivery_amount'] = $cartInfo->per_item_amount * $post['quantity'][$i];
                            $inject['total_delivery_amount'] = $inject['per_delivery_amount'] * $inject['no_of_delivery'];
                            $inject['delivery_dates'] = implode(",",$delivery_dates);
                            Cart::where('id',$cartId)->update($inject);
                        }else{
                            Session::flash('error',  __('lang.alert_select_date_rang_for_alternative'));
                            return redirect()->to('cart');
                        }
                    }
                }
            }
        }

        $btnVal = (isset($post['submit_button']))?$post['submit_button']:'next';
        if($btnVal=='next' && $inject['total_delivery_amount']>0){
            Session::flash('message', __('lang.alert_cart_updated_successfully'));
            return redirect()->to('checkout');
        } elseif (isset($post['submit_button']) && $post['submit_button'] == 'Add To Cart' && $inject['total_delivery_amount'] > 0) {
            Session::flash('message', __('lang.alert_cart_added_successfully'));
            return redirect('/')->with('message',__('lang.alert_cart_added_successfully'));
        }else{
            if($inject['total_delivery_amount']>0){
                Session::flash('message', __('lang.alert_cart_updated_successfully'));
                return redirect('/cart')->with('message',__('lang.alert_cart_updated_successfully'));
            }
            else{
                return redirect()->back()->with('error',__('lang.alert_for_error_try_again'));
            }
        }
    }

    public function applyCoupon(Request $request)
    {
        $post = $request->all();
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }
        Session::put('coupon_id', $post['coupon_id']);
        Session::flash('message', __('lang.alert_coupon_applied_successfully'));
        return redirect()->back()->with('message',__('lang.alert_coupon_applied_successfully'));
    }

    public function addToCart(Request $request)
    {
        $post = $request->all();
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }

        $product =  Product::where('id',$post['product_id'])->first();
        if (!$product) {
            Session::flash('message', __('lang.alert_product_not_found'));
            return redirect()->back()->with('message',__('lang.alert_product_not_found'));
        }

        $cartItemExist = Cart::where('user_id',$user_id)->where('product_id',$post['product_id'])->first();

        $price = ($product->discount_price>0)?$product->discount_price:$product->price;

        /* $total_amount = $price; */ /* previous cart calculation happen from this price,it getting wrong amount if minimum quantity is set. */

        $quantity = isset($post['product_minimum_quantity']) && $post['quantity'][0] > $post['product_minimum_quantity']
                    ? $post['quantity'][0]
                    : $post['product_minimum_quantity'] ?? $post['quantity'][0];
        $total_amount = $price*$quantity;
        $inject = array(
            "user_id" => $user_id,
            "product_id" => $post['product_id'],
            'quantity' => $quantity,
            "per_item_amount" => $price,
            'per_delivery_amount' => $total_amount,
            'total_delivery_amount' => $total_amount,
            "no_of_delivery" => 1,
            "days" => '',
            "delivery_dates" => date("Y-m-d"),
            "order_frequency" => 'once',
        );
        if($cartItemExist){
            $inject['updated_at'] = date('Y-m-d h:i:s');
            Cart::where('id',$cartItemExist->id)->update($inject);
            $id = $cartItemExist->id;
        }else{
            $inject['created_at'] = date('Y-m-d h:i:s');
            $id = Cart::insertGetId($inject);
        }
        $cartCount = Cart::where('user_id',$user_id)->count();
        Session::put('total_cart', $cartCount);
        if($post['cart_id'][0]==-1){
            return $id;
        }
        return redirect('/#populargoods')->with('message',__('lang.alert_cart_updated_successfully'));
    }

    public function deleteCartitem($id,Request $request)
    {
        $post = $request->all();
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }
        Cart::where('id',$id)->delete();
        $cartCount = Cart::where('user_id',$user_id)->count();
        Session::put('total_cart', $cartCount);
        Session::flash('message', __('lang.alert_cart_deleted_successfully'));
        return redirect()->to('cart');
    }

    public function checkout(Request $request)
    {
        $user=Auth::user();
        $addresses = DeliveryAddresses::where('user_id',$user->id)->get();
        $deliveryAreas = DeliveryAreas::where('status',1)->get();
        return view('checkout',compact('deliveryAreas'))->with('data',$addresses)->with('user',$user);
    }

    public function placeOrder(Request $request)
    {
        $post = $request->all();
        request()->validate([
            'delivery_address_id' => 'required'
        ]);
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }

        $address = DeliveryAddresses::where('id',$post['delivery_address_id'])->first();
        $response = array();
        $response['timeslots'] = Timeslots::where('status',1)->get();
        foreach ($response['timeslots'] as $row) {
            $translated_data = TimeslotsTranslation::where('lang_code',$this->language)->where('timeslot_id',$row->id)->first();
            if($translated_data){
                if($translated_data->name!=''){
                    $row->name = $translated_data->name;
                }
            }
        }
        $response['total_wallet'] = UserWallet::getWalletbalance($user_id);
        $response['cards'] = UserCards::where('user_id',$user_id)->orderBy('id','DESC')->get();

        $cartData = Cart::where('user_id',$user_id)->with('product')->get();
        $total = array(
            'subtotal' => 0,
            'tax' => 0,
            'delivery_fee' => 0,
            'is_coupon_applied' => 0,
            'promotional_disount' => 0,
            'coupon_code' => '',
            'final_amount' => 0
        );

        foreach($cartData as $cart){
            if($cart->product){
                $translated_data = ProductTranslation::where('lang_code',$this->language)->where('product_id',$cart->product_id)->first();
                if($translated_data){
                    if($translated_data->name!=''){
                        $cart->product->name = $translated_data->name;
                    }
                    if($translated_data->description!=''){
                        $cart->product->description = $translated_data->description;
                    }
                }
                $total['subtotal'] = $total['subtotal'] + $cart->total_delivery_amount;
                array_push($response, $cart);
            }else{
                Cart::where('user_id',$cart->id)->delete();
            }
        }
        $total['subtotal'] = round($total['subtotal'],2);
        $total['delivery_fee'] = ($total['subtotal']<setting('minimum_order_value'))?setting('shipping_charge'):0;
        $total['tax'] = round((($total['subtotal'] * setting('default_tax')) / 100),2);
        $total['final_amount'] = round(($total['subtotal'] + $total['delivery_fee'] + $total['tax']),2);
        if(Session()->has('is_coupon_applied')){
            $total['is_coupon_applied'] = Session()->get('is_coupon_applied');
            $total['coupon_code'] = Session()->get('coupon_code');
            $total['promotional_disount'] = Session()->get('promotional_disount');
        }
        $cartCount = Cart::where('user_id',$user_id)->count();
        Session::put('total_cart', $cartCount);
        $total['final_amount'] = $total['final_amount'] - $total['promotional_disount'];

        return view('place-order')->with('response',$response)->with('total',$total)->with('delivery_address_id',$post['delivery_address_id']);
    }

    public function doPlaceOrder(Request $request)
    {
        $post = $request->all();
        request()->validate([
            'delivery_address_id' => 'required',
            'timeslot_id' => 'required',
            'payment_method' => 'required',
        ]);

        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
            $user= Auth::user();
        }
        $address = DeliveryAddresses::where('id',$post['delivery_address_id'])->first();

        $cartData = Cart::where('user_id',$user_id)->with('product')->get();

        $orderPostData = array(
            'subtotal' => 0,
            'tax' => 0,
            'delivery_fee' => 0,
            'is_coupon_applied' => 0,
            'promotional_disount' => 0,
            'coupon_code' => '',
            'final_amount' => 0,
            'delivery_address_id' => $post['delivery_address_id'],
            'timeslot_id' => $post['timeslot_id'],
            'order_status_id' => 1
        );

        if(Session()->has('is_coupon_applied')){
            $orderPostData['is_coupon_applied'] = Session()->get('is_coupon_applied');
            $orderPostData['coupon_code'] = Session()->get('coupon_code');
            $orderPostData['promotional_disount'] = Session()->get('promotional_disount');
        }

        foreach($cartData as $cart){
            if($cart->product){
                $orderPostData['subtotal'] = $orderPostData['subtotal'] + $cart->total_delivery_amount;
            }
        }
        $orderPostData['subtotal'] = round($orderPostData['subtotal'], 2);
        $orderPostData['delivery_fee'] = ($orderPostData['subtotal'] < setting('minimum_order_value')) ? setting('shipping_charge') : 0;
        
        // Calculate tax amount based on subtotal
        $taxPercentage = setting('default_tax') ?? 0.00;
        $orderPostData['tax'] = round(($taxPercentage / 100) * $orderPostData['subtotal'], 2);
        
        // Ensure tax amount is correctly used
        $orderPostData['final_amount'] = round(($orderPostData['subtotal'] + $orderPostData['delivery_fee'] + $orderPostData['tax']), 2);
        
        // Subtract promotional discount safely
        $orderPostData['final_amount'] -= ($orderPostData['promotional_disount'] ?? 0); // Handle null case
        
        $orderPostData['user_id'] = $user_id;
        $orderPostData['payment_method'] = $post['payment_method'];
        $orderPostData['created_at'] = date('Y-m-d H:i:s');

        $orderId = Order::insertGetId($orderPostData);
        
        /* firebase notification for admin */
        if( setting('is_enable_firebase') && setting('is_enable_firebase_notification') && setting('firebase_json_file')) {
            if(Storage::path('/public/firebase/firebase_credentials.json')) {
                $admin=User::where('type','admin')->first();
                $tokens=json_decode($admin->fcm_token,true);
                $admin->notify(new FcmNotification(
                    'New Order Received.# '.$orderId,
                    'Click to go to order details.',
                    [
                        'url' => url('/admin/orders/' . $orderId), // This will be used for redirection
                        'image' => url('/app-assets/images/logo.png')
                    ],
                    $tokens // Pass tokens here for multiple user
                ));
            }
        }
        /* end notification */

       // email code
       $order = $this->getOrderDetails($orderId,$user_id);
       $isEnableOrderEmailSetting = AppSetting::get_setting('is_enable_mail_order_receive');
        if ($isEnableOrderEmailSetting == 1) {
            $customer = User::find($user_id);
            $emailData = [
                'order' => $order,
                'customer' => $customer,
            ];
            
            // Get all admin emails
            $admins = User::where('role_id', 1)->pluck('email')->toArray(); // Use pluck for simplicity
            $adminEmails = array_filter($admins); // Remove any null or empty emails
            
            $customerEmail = $customer->email;
            $subject = 'New Order Received - Order ID: ' . $order->id;
            
            \Mail::send('email.order', $emailData, function ($message) use ($customerEmail, $adminEmails, $subject) {
                // Send to the customer
                $message->to($customerEmail);
        
                // Add admins as recipients (optional: use `cc` or `bcc`)
                if (!empty($adminEmails)) {
                    $message->cc($adminEmails);
                }
        
                // Set the subject
                $message->subject($subject);
            });
        }

        $amount = 0;
        foreach($cartData as $cart){
            if($cart->product){
                $inject = array(
                    'user_id' => $user_id,
                    'order_id' => $orderId,
                    'product_id'=> $cart->product_id,
                    'quantity' => $cart->quantity,
                    'per_item_amount' => $cart->per_item_amount,
                    'per_delivery_amount' => $cart->per_delivery_amount,
                    'total_delivery_amount' => $cart->total_delivery_amount,
                    'no_of_delivery' => $cart->no_of_delivery,
                    'order_frequency' => $cart->order_frequency,
                    'start_date' => $cart->start_date,
                    'end_date' => $cart->end_date,
                    'days' => $cart->days,
                    'created_at'=>date('Y-m-d H:i:s'),
                );
                $orderitemId = OrderProduct::insertGetId($inject);
                $delivery_dates = explode(",", $cart->delivery_dates);

                // Convert dates to timestamps and sort them
                usort($delivery_dates, function ($a, $b) {
                    return strtotime($a) - strtotime($b);
                });

                foreach ($delivery_dates as $r) {
                    $delivery = [
                        'user_id' => $user_id,
                        'order_id' => $orderId,
                        'product_id' => $cart->product_id,
                        'product_order_id' => $orderitemId,
                        'delivery_date' => date("Y-m-d", strtotime($r)),
                        'order_status_id' => $orderPostData['order_status_id'],
                        'created_at' => date('Y-m-d H:i:s'),
                    ];
                    OrderProductsDelivery::insert($delivery);
                }
            }
        }
        
        $paymentid = UserPayment::insertGetId([
            "user_id" => $orderPostData['user_id'],
            "description" => 'Waiting for Client',
            "price" => $orderPostData['final_amount'],
            "status" => 'Paid',
            "method" => $orderPostData['payment_method'],
            'created_at'=>date('Y-m-d H:i:s')
        ]);

        Order::where('id',$orderId)->update(['payment_id' => $paymentid,'updated_at'=>date("Y-m-d H:i:s")]);
        
        if($post['payment_method']=='wallet'){
            $total_wallet = UserWallet::getWalletbalance($user_id);
            $order=Order::where('id',$orderId)->first();
            if($total_wallet<$orderPostData['final_amount']){
                if(!empty($order)){
                    $order->payment_status=4;
                    $order->save();
                    Session::flash('error', __('lang.alert_dont_have_sufficent_balance'));
                    return redirect()->back()->with('error',__('lang.alert_dont_have_sufficent_balance'));
                }
            }else{
                $wallet = [
                    'user_id'=>$user_id,
                    'order_id'=>$order->id,
                    'payment_id'=>$paymentid,
                    'type'=>'debit',
                    'amount'=>-$orderPostData['final_amount'],
                    'description'=> 'We have debit '.\Helpers::currency($orderPostData['final_amount']).' form your wallet for new purchase.',
                    'created_at'=>date('Y-m-d H:i:s')
                ];
                UserWallet::insertGetId($wallet);
                if(!empty($order)){
                    $order->payment_transection_id='W'.rand(10000, 99999).'U'.$user->id.'T'.$order->id;
                    $order->payment_status=4;
                    $order->save();
                    \Helpers::clearAuthUserCart();
                    return redirect('orders')->with(['message'=>__('lang.admin_payment_done')]);
                }else{
                    return back()->withError('Payment failed.please try again or change payment method.');
                }
            }
        }else if($post['payment_method']=='online'){
            $entityId = '8ac7a4c77d8d45bb017d8f5c7963042b';
            $url = "https://test.oppwa.com/v1/checkouts";
            $data = "entityId=" .$entityId.
                        "&amount=" .$orderPostData['final_amount'].
                        "&currency=SAR" .
                        "&paymentType=DB";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                           'Authorization:Bearer OGFjN2E0Yzc3ZDhkNDViYjAxN2Q4ZjVjMTljNDA0MjZ8SnJIblk4cFpORA=='));
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $responseData = curl_exec($ch);
            if(curl_errno($ch)) {
                return curl_error($ch);
            }
            curl_close($ch);
            $responseData = json_decode($responseData);
            if($responseData){
                \Helpers::clearAuthUserCart();
                return redirect()->to('do-online-payment/'.$orderId);
            }
        }
        else if($post['payment_method']=='razorpay'){
            $razorpayPayment= new razorpayPayment;
            return $razorpayPayment->payment($request,$orderId,$orderPostData,$user);
        }
        else if($post['payment_method']=='flutterwave'){
            $flutterwavePayment= new flutterwavePayment;
            return $flutterwavePayment->payment($request,$orderId,$orderPostData,$user);

        }else if($post['payment_method']=='paypal'){
            $paypalPayment= new paypalPayment;
            return $paypalPayment->payment($request,$orderId,$orderPostData);

        }else if($post['payment_method']=='paytm'){
            $amount = 1500; // Amount to be paid

            $userData = [
                'name' => $request->name,
                'mobile' => $request->mobile,
                'email' => $request->email,
                'fee' => $amount,
                'order_id' => $request->mobile."_".rand(1,1000)
            ];

            // Prepare the payment
            $payment = PaytmWallet::with('receive');

            $payment->prepare([
                'order' => 'cus_02',
                'user' => 2,
                'mobile_number' => '7489858983',
                'email' => 'pawanrajput2909@gmail.com',
                'amount' => $amount,
                'callback_url' => route('status')
            ]);

            return $payment->receive();
        }else if($post['payment_method']=='instamojo'){
            $instamojoPayment=new instamojoPayment;
            return $instamojoPayment->payment($request,$orderId,$orderPostData,$user);

        }else if($post['payment_method']=='paystack'){
            $paystackPayment=new paystackPayment;
            return $paystackPayment->payment($request,$orderId,$orderPostData);

        }else if($post['payment_method']=='phonepe'){
                $phonepePayment=  new phonepePayment;
                return $phonepePayment->payment($request,$orderId,$orderPostData,$user);
        }else if ($post['payment_method'] == 'liqpay') {
            $liqpayPayment = app(\App\Http\Controllers\PaymentGateway\LiqPayController::class);
            return $liqpayPayment->createPayment($request, $orderId, $orderPostData, $user);
        }else{
            \Helpers::clearAuthUserCart();
            $order=Order::where('id',$orderId)->first();
           // Generate reference and transaction IDs in case of cod payments
            $paymentReferenceId = 'ref' . rand(10000, 99999) . 'U' . $user->id . 'T' . $order->id;
            $paymentTransactionId = 'cod' . rand(10000, 99999) . 'U' . $user->id . 'T' . $order->id;

            // Add these IDs to the $data['data'] array
            $data['data'] = [
                'txn_id' => $paymentTransactionId,
                'ref' => $paymentReferenceId,
            ];
            $payment=UserPayment::where('id',$order->payment_id)->first();
            if(!empty($order) && $order->payment_method=='cash'){
                $order->payment_refferance_id=$paymentReferenceId;
                $order->payment_transection_id=$paymentTransactionId;
                $order->payment_transection_data= json_encode($data['data']);
                $order->payment_status= 1;
                $order->save();
                if(!empty($payment)){
                    $payment->payment_refferance_id=$paymentReferenceId;
                    $payment->payment_transection_id=$paymentTransactionId;
                    $payment->payment_transection_data= json_encode($data['data']);
                    $payment->payment_status= 1;
                    $payment->status='Unpaid';
                    $payment->save();
                }
                \Helpers::clearAuthUserCart();
                return redirect('orders')->with(['message'=>__('lang.admin_payment_done')]);
            }
            return redirect()->to('orders');
        }

    }

    public function saveToken(Request $request){

        $post = $request->all();
        request()->validate([
            'delivery_address_id' => 'required',
            'timeslot_id' => 'required',
            'payment_method' => 'required',
        ]);

        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }

        $address = DeliveryAddresses::where('id',$post['delivery_address_id'])->first();

        $cartData = Cart::where('user_id',$user_id)->with('product')->get();

        $orderPostData = array(
            'subtotal' => 0,
            'tax' => 0,
            'delivery_fee' => 0,
            'is_coupon_applied' => 0,
            'promotional_disount' => 0,
            'coupon_code' => '',
            'final_amount' => 0,
            'delivery_address_id' => $post['delivery_address_id'],
            'timeslot_id' => $post['timeslot_id'],
            'order_status_id' => 1
        );

        if(Session()->has('is_coupon_applied')){
            $orderPostData['is_coupon_applied'] = Session()->get('is_coupon_applied');
            $orderPostData['coupon_code'] = Session()->get('coupon_code');
            $orderPostData['promotional_disount'] = Session()->get('promotional_disount');
        }

        foreach($cartData as $cart){
            if($cart->product){
                $orderPostData['subtotal'] = $orderPostData['subtotal'] + $cart->total_delivery_amount;
            }
        }
        
        $orderPostData['subtotal'] = round($orderPostData['subtotal'], 2);
        // Calculate delivery fee based on minimum order value
        $orderPostData['delivery_fee'] = ($orderPostData['subtotal'] < setting('minimum_order_value')) ? setting('shipping_charge') : 0;
        
        // Ensure tax percentage is retrieved correctly
        $taxPercentage = setting('default_tax') ?? 0.00;
        $orderPostData['tax'] = round(($orderPostData['subtotal'] * $taxPercentage) / 100, 2);
        
        // Calculate final amount
        $orderPostData['final_amount'] = round($orderPostData['subtotal'] + $orderPostData['delivery_fee'] + $orderPostData['tax'], 2);
        
        // Handle promotional discount safely (avoid undefined variable error)
        $orderPostData['final_amount'] -= ($orderPostData['promotional_disount'] ?? 0);
        
        $orderPostData['user_id'] = $user_id;
        $orderPostData['payment_method'] = $post['payment_method'];
        $orderPostData['created_at'] = now(); // Use Laravel's helper for current timestamp


        $orderId = Order::insertGetId($orderPostData);
        $amount = 0;

        foreach($cartData as $cart){
            if($cart->product){
                $inject = array(
                    'user_id' => $user_id,
                    'order_id' => $orderId,
                    'product_id'=> $cart->product_id,
                    'quantity' => $cart->quantity,
                    'per_item_amount' => $cart->per_item_amount,
                    'per_delivery_amount' => $cart->per_delivery_amount,
                    'total_delivery_amount' => $cart->total_delivery_amount,
                    'no_of_delivery' => $cart->no_of_delivery,
                    'order_frequency' => $cart->order_frequency,
                    'start_date' => $cart->start_date,
                    'end_date' => $cart->end_date,
                    'days' => $cart->days,
                    'created_at'=>date('Y-m-d H:i:s'),
                );
                $orderitemId = OrderProduct::insertGetId($inject);
                $delivery_dates = explode(",",$cart->delivery_dates);
                foreach ($delivery_dates as $r) {
                    $delivery = array(
                        'user_id' => $user_id,
                        'order_id' => $orderId,
                        'product_id'=> $cart->product_id,
                        'product_order_id'=> $orderitemId,
                        'delivery_date' => date("Y-m-d",strtotime($r)),
                        'order_status_id' => $orderPostData['order_status_id'],
                        'created_at'=>date('Y-m-d H:i:s'),
                    );
                    OrderProductsDelivery::insert($delivery);
                }
            }
        }

        $paymentid = UserPayment::insertGetId([
            "user_id" => $orderPostData['user_id'],
            "description" => 'Waiting for Client',
            "price" => $orderPostData['final_amount'],
            "status" => 'Waiting for Client',
            "method" => $orderPostData['payment_method'],
            'created_at'=>date('Y-m-d H:i:s')
        ]);

        Order::where('id',$orderId)->update(['payment_id' => $paymentid,'updated_at'=>date("Y-m-d H:i:s")]);

        /* call stripe payment methid here. */
        $stripePayment=new stripePayment;
        return $stripePayment->payment($request,$orderId,$user_id);
    }

    /**
     * Write code on Paytm Method
     *
     * @return response()
     */

    public function paymentCallback(Request $request)
    {
        // Retrieve the transaction details
        $transaction = PaytmWallet::with('receive');

        $response = $transaction->response();
        $order_id = $transaction->getOrderId();

        // Verify the checksum
        $isValidChecksum = PaytmChecksum::verifySignature($request->all(), 'TmRz@ltVegOR&2%d', $response['CHECKSUMHASH']);

        if ($isValidChecksum) {
            // Checksum is valid, process the payment
            if ($transaction->isSuccessful()) {
                // Update the database as per the result from the API call
                // Paytm::where('order_id', $order_id)->update(['status' => 1, 'transaction_id' => $transaction->getTransactionId()]);
                return redirect(route('initiate.payment'))->with('message', __('lang.admin_your_payment_is_successful'));
            } elseif ($transaction->isFailed()) {
                // Paytm::where('order_id', $order_id)->update(['status' => 0, 'transaction_id' => $transaction->getTransactionId()]);
                return redirect(route('initiate.payment'))->with('message',__('lang.admin_payment_failed'));
            } elseif ($transaction->isOpen()) {
                // Paytm::where('order_id', $order_id)->update(['status' => 2, 'transaction_id' => $transaction->getTransactionId()]);
                return redirect(route('initiate.payment'))->with('message', __('lang.admin_your_payment_is_processing'));
            }
        } else {
            // Checksum is invalid, handle accordingly
            return redirect(route('initiate.payment'))->with('message', __('lang.admin_invalid_checksum_payment_verification_failed'));
        }
    }


    public function doOnlinePayment($id,Request $request)
    {
        return view('do-online-payment')->with('order_id',$id);
    }

    public function doConfirmPayment($orderId,Request $request)
    {
        $post = $request->all();
        $url = "https://test.oppwa.com/v1/checkouts/".$post['id']."/payment";
        $url .= "?entityId=8ac7a4c77d8d45bb017d8f5c7963042b";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                       'Authorization:Bearer OGFjN2E0Yzc3ZDhkNDViYjAxN2Q4ZjVjMTljNDA0MjZ8SnJIblk4cFpORA=='));
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $responseData = curl_exec($ch);
        if(curl_errno($ch)) {
            return curl_error($ch);
        }
        curl_close($ch);
        $responseData = json_decode($responseData);
        $array = ["000.100.110","000.100.111","000.100.112"];
        if(!isset($responseData->result->code)){
            $orderData = Order::where('id',$orderId)->first();
            if($orderData){
                UserPayment::where('id',$orderData->payment_id)->update(['description' => 'Failed','status' => 'Failed','updated_at'=>date("Y-m-d H:i:s")]);
                Order::where('id',$orderId)->update(['order_status_id' => 6,'updated_at'=>date("Y-m-d H:i:s")]);
            }
            return redirect()->to('order-details/'.$orderId);
        }
        if (in_array($responseData->result->code, $array)){
            $orderData = Order::where('id',$orderId)->first();
            if($orderData){
                UserPayment::where('id',$orderData->payment_id)->update(['description' => 'Paid','status' => 'Paid','updated_at'=>date("Y-m-d H:i:s")]);
            }
            return redirect()->to('order-details/'.$orderId);
        }
        else{
            $orderData = Order::where('id',$orderId)->first();
            if($orderData){
                UserPayment::where('id',$orderData->payment_id)->update(['description' => 'Failed','status' => 'Failed','updated_at'=>date("Y-m-d H:i:s")]);
                Order::where('id',$orderId)->update(['order_status_id' => 6,'updated_at'=>date("Y-m-d H:i:s")]);
            }
            return redirect()->to('order-details/'.$orderId);
        }
    }

    public function profile(Request $request)
    {
        return view('your-account')->with('user',Auth::user());
    }

    public function addresses(Request $request)
    {
        $deliveryAreas = DeliveryAreas::where('status',1)->get();
        $addresses = DeliveryAddresses::where('user_id',Auth::user()->id)->get();
        return view('saved-addresses',compact('deliveryAreas'))->with('data',$addresses);
    }

    public function orders(Request $request)
    {
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }
        $orders = Order::where('user_id',$user_id)->with('product_orders')->with('order_status')->orderBy('id','DESC')->get();
        foreach($orders as $row){
            foreach($row->product_orders as $prow){
                if($prow->product){
                    $translated_data = ProductTranslation::where('lang_code',$this->language)->where('product_id',$prow->product_id)->first();
                    if($translated_data){
                        if($translated_data->name!=''){
                            $prow->product->name = $translated_data->name;
                        }
                        if($translated_data->description!=''){
                            $prow->product->description = $translated_data->description;
                        }
                    }
                }
            }
        }
        
        // Deleting the order delivery which was failed
        $orderId = Order::where('user_id',$user_id)->pluck('id')->toArray();
        // OrderProductsDelivery::whereIn('order_id',$orderId)->delete();
        // OrderProduct::whereIn('order_id',$orderId)->delete();
        return view('your-order')->with('data',$orders);
    }

    public function orderDetail($id,Request $request)
    {
        try{
            $data = [];
            $user_id = 0;
            if (Auth::check()) {
                $user_id = Auth::user()->id;
            }
            $orders = $this->getOrderDetails($id,$user_id);
            if($orders){
                if($orders->payment_method=='razorpay'){
                    $jsonString =$orders->payment_transection_id;

                    // Decode the JSON string
                    $jsonObj = json_decode($jsonString, true);

                    if(!empty($jsonObj)){
                        foreach($jsonObj as $pay){
                            $data=$pay;
                            break;
                        }
                    }else{
                        $data['payment_transection_id']=$orders->payment_transection_id;
                    }
                }else if($orders->payment_method=='cash'){
                    return view('order-details')->with('data', $orders);
                }
                return view('order-details')->with(['data'=>$orders,'transection'=>$data]);
            }
            else{
                return redirect()->to('orders');
            }
        } catch (Exception $e) {
            return redirect()->to('orders')->withError($e->getMessage());
        }
    }

    public function cancelOrderRequest($id,Request $request)
    {
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }
        $postData = array(
            'order_id' => $id,
            'user_id' => $user_id,
            'refund_amount' => 0,
            'refund_status' => 0,
            'status' => 0,
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s")
        );


        $data = Order::find($id);
        if($data->payment_method!='cash'){
            $totalWalletAmount = 0;
            $productsDelivery = OrderProductsDelivery::where('order_status_id','<',5)->where('delivery_date','>=',date("Y-m-d"))->where('order_id',$id)->with('product_orders')->get();
            foreach ($productsDelivery as $row) {
                if($row->product_orders){
                    $totalWalletAmount = $totalWalletAmount + $row->product_orders->per_delivery_amount;
                }
            }
            $postData['refund_amount'] = $totalWalletAmount;
        }

        OrderCancelRequest::insertGetId($postData);

        Session::flash('message',  __('lang.alert_cancel_order_request_submited'));
        return redirect()->back()->with('message', __('lang.alert_cancel_order_request_submited'));
    }

    private function getOrderDetails($id,$user_id)
    {
        $orders = Order::where('user_id',$user_id)->where('id',$id)->with('product_orders')->with('order_status')->with('payment')->with('delivery_address')->with('time_slots')->with('cancel_request')->first();
        if($orders){
            $delivered_products = OrderProductsDelivery::where('order_id',$id)->groupBy('delivery_date')->orderBy('delivery_date','ASC')->get();
            $AllDeliveryDates = array();
            foreach ($delivered_products as $delivered) {
                $temp = array(
                    'date' => $delivered->delivery_date,
                    'data' => OrderProductsDelivery::where('order_id',$id)->where('delivery_date',$delivered->delivery_date)->with('product_orders')->with('delivery_status')->get()
                );
                array_push($AllDeliveryDates,$temp);
            }
            $orders->delivered_products = $AllDeliveryDates;
            foreach($orders->product_orders as $prow){
                if($prow->product){
                    $translated_data = ProductTranslation::where('lang_code',$this->language)->where('product_id',$prow->product_id)->first();
                    if($translated_data){
                        if($translated_data->name!=''){
                            $prow->product->name = $translated_data->name;
                        }
                        if($translated_data->description!=''){
                            $prow->product->description = $translated_data->description;
                        }
                    }
                }
            }
        }
        return $orders;
    }


    public function contact(Request $request)
    {
        $requireSetting=  Config::get('app.requireSetting');
        $settings = AppSetting::whereIn('key', $requireSetting)->get();
        // Transform the settings to a key-value pair array
        $settingsArray = $settings->pluck('value', 'key')->toArray();
        foreach($requireSetting as $set){
            if(empty($settingsArray['google_address_latitude'])){
                $settingsArray['google_address_latitude']=null;
            }elseif(empty($settingsArray['google_address_longitude'])){
                $settingsArray['google_address_latitude']=null;
            }elseif(empty($settingsArray['google_address_longitude'])){
                $settingsArray['google_address_latitude']=null;
            }elseif(empty($settingsArray[$set])){
                array_push($settingsArray,[$set=>0]);
            }
        }

        // Pass the settings to the view
        return view('contact', compact('settingsArray'));
    }

    public function doSubmitContactUs(Request $request)
    {
        $post = $request->all();

        if(strlen($post['mobile']) != 10){
           return redirect()->back()->with('error',__('lang.admin_phone_number_10_length'));
        } 

       
        $postData = array(
            'user_id' => 1,
            'name' => $post['name'],
            'email' => $post['email'],
            'message' => $post['message'],
            'mobile' => $post['mobile'],
            'created_at' => date("Y-m-d H:i:s"),
            'updated_at' => date("Y-m-d H:i:s"),
        );
        Contactus::insert($postData);
        Session::flash('message', __('lang.alert_contact_us_request_submited_successfully'));
        return redirect()->back()->with('message',__('lang.alert_contact_us_request_submited_successfully'));
    }

    public function termsAndCondition(Request $request)
    {
        $terms = CmsPages::where('page_name','terms')->first();
        if($terms){
            $translated_data = CmsPagesTranslation::where('lang_code',$this->language)->where('cms_id',$terms->id)->first();
            if($translated_data){
                if($translated_data->page_title!=''){
                    $terms->page_title = $translated_data->page_title;
                }
                if($translated_data->description!=''){
                    $terms->description = $translated_data->description;
                }
            }
        }
        return view('term-and-conditions')->with('data',$terms);
    }

    public function privacyPolicy(Request $request)
    {
        $terms = CmsPages::where('page_name','policy')->first();
        if($terms){
            $translated_data = CmsPagesTranslation::where('lang_code',$this->language)->where('cms_id',$terms->id)->first();
            if($translated_data){
                if($translated_data->page_title!=''){
                    $terms->page_title = $translated_data->page_title;
                }
                if($translated_data->description!=''){
                    $terms->description = $translated_data->description;
                }
            }
        }
        return view('privacy-policy')->with('data',$terms);
    }

    public function about(Request $request)
    {
        $about_us = CmsPages::where('page_name','about')->orWhere('page_name','about')->first();
        $about_us_partners = Partners::where('type','partner')->get();
        $about_us_awards = Partners::where('type','awards')->get();
        if($about_us){
            $translated_data = CmsPagesTranslation::where('lang_code',$this->language)->where('cms_id',$about_us->id)->first();
            if($translated_data){
                if($translated_data->page_title!=''){
                    $about_us->page_title = $translated_data->page_title;
                }
                if($translated_data->description!=''){
                    $about_us->description = $translated_data->description;
                }
            }
        }
        return view('about')->with('data',$about_us)->with('partners',$about_us_partners)->with('awards',$about_us_awards);
    }

    public function accountDelete(Request $request)
    {
        $account = CmsPages::where('page_name','account-deletion')->first();
        if($account){
            $translated_data = CmsPagesTranslation::where('lang_code',$this->language)->where('cms_id',$account->id)->first();
            if($translated_data){
                if($translated_data->page_title!=''){
                    $account->page_title = $translated_data->page_title;
                }
                if($translated_data->description!=''){
                    $account->description = $translated_data->description;
                }
            }
        }
        return view('account-deletion')->with('data',$account);
    }

    public function wallet(Request $request)
    {
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }
        $total_wallet = UserWallet::getWalletbalance($user_id);
        $wallet = UserWallet::getUserWalletLists($user_id);
        return view('wallet')->with('data',$wallet)->with('total_wallet',$total_wallet);
    }


    public function handleCheckout(Request $request)
    {

        $post = $request->all();
        if ($request->isMethod('post')) {
            $user_id = 0;
            if (Auth::check()) {
                $user_id = Auth::user()->id;
            }
            $paymentid = UserPayment::insertGetId([
                "user_id" => $user_id,
                "description" => 'Waiting for Client',
                "price" => $post['amount'],
                "status" => 'Processing',
                "method" => '',
                "payment_transection_id"=>'',
                "payment_transection_data"=>'',
                "payment_refferance_id"=>'',
                "payment_status"=>0,
                'created_at'=>date('Y-m-d H:i:s')
            ]);
            $post['paymentid'] = $paymentid;
            return view('place-wallet')->with('post',$post);
        } elseif ($request->isMethod('get')) {
            // Handle GET request
            return view('place-wallet')->with('post',$post);
        }
        return abort(405); // Method Not Allowed
    }

    public function doConfirmWalletPayment(Request $request)
    {
        $post=$request->all();

        if($post['payment_method']=='flutterwave'){
            $flutterwavePayment= new flutterwavePayment;
            return $flutterwavePayment->walletPayment($request);
        }
        else if($post['payment_method']=='razorpay'){
            $razorpayPayment= new razorpayPayment;
            return $razorpayPayment->walletPayment($request);
        }
        else if($post['payment_method']=='paypal'){
            $paypalPayment= new paypalPayment;
            return $paypalPayment->walletPayment($request);
        }else if($post['payment_method']=='instamojo'){
            $instamojoPayment=new instamojoPayment;
            return $instamojoPayment->walletPayment($request);

        }else if($post['payment_method']=='paystack'){
            $paystackPayment=new paystackPayment;
            return $paystackPayment->walletPayment($request);

        }else if($post['payment_method']=='phonepe'){
            $phonepePayment=new phonepePayment;
            return $phonepePayment->walletPayment($request);
        }

    }

public function saveTokenWallet(Request $request){
    try {
        $post = $request->all();

        // Validate payment method
        request()->validate([
            'payment_method' => 'required',
        ]);

        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }

        // Set Stripe API key
        \Stripe\Stripe::setApiKey(setting('stripe_secret_key'));

        // Create Stripe customer
        $customer = \Stripe\Customer::create([
            'name' => Auth::user()->name,
            'source' => $post['stripeToken']
        ]);

        $stripe_user_id = $customer->id;

        // Retrieve user payment
        $user_payment = UserPayment::where('id', $post['paymentid'])->first();
        if (empty($user_payment)) {
            return redirect()->back()->withError('User payment is empty.');
        }

        // Update user payment with payment reference ID and method
        $user_payment->payment_refferance_id = $stripe_user_id;
        $user_payment->method = $post['payment_method'];
        $user_payment->save();

        // Calculate total payment amount in cents
        $total_payment = round(100 * $post['amount']);

        // Create Stripe charge
        $data = \Stripe\Charge::create([
            "amount" => $total_payment,
            "currency" => AppSetting::get_setting('default_currency_code'),
            'customer' => $stripe_user_id,
            "description" => __('lang.admin_order_placed_succesfully'),
            'metadata' => [
                'name' => $request->name,
                'email' => $request->email ?? Auth::user()->email,
                'user_id' => $user_id
            ]
        ]);

        if (isset($data['status']) && $data['status'] === 'succeeded') {
            // Payment succeeded
            $user_payment = UserPayment::where('payment_refferance_id', $data['customer'])->first();

            if (!empty($user_payment)) {
                // Update transaction details
                $user_payment->payment_transection_id = $data['id'];
                $user_payment->payment_transection_data = json_encode($data);
                $user_payment->payment_status = 1; // Payment succeeded
                $user_payment->save();

                // Add credit to user wallet
                $wallet = [
                    'user_id' => $user_id,
                    'order_id' => -1,
                    'payment_id' => $user_payment->id,
                    'type' => 'credit',
                    'amount' => $post['amount'],
                    'description' => 'We have credited ' . \Helpers::currency($post['amount']) . ' in your wallet.',
                    'created_at' => date('Y-m-d H:i:s')
                ];
                $user_wallet = UserWallet::insertGetId($wallet);

                // Return success response
                return response()->json([
                    'success' => true,
                    'message' => __('lang.add_amount_successfully_in_wallet'),
                    'data' => [
                        'user_payment_id' => $user_payment->id,
                        'user_wallet' => $user_wallet
                    ]
                ], 200);
            }

            // Wallet not found
            return response()->json([
                'success' => false,
                'message' => 'Wallet not found.'
            ], 404);

        } else {
            // Payment failed or cancelled
            $user_payment = UserPayment::where('payment_refferance_id', $data['customer'])->first();

            if (!empty($user_payment)) {
                $user_payment->payment_status = 2; // Payment failed or cancelled
                $user_payment->save();

                $message = $user_payment->payment_status == 3
                    ? "Wallet payment has been cancelled."
                    : "Wallet payment has failed.";

                // Return failure response
                return response()->json([
                    'success' => false,
                    'message' => $message
                ], 400);
            }

            // User payment not found
            return response()->json([
                'success' => false,
                'message' => __('lang.admin_you_have_canceled_the_transaction')
            ], 404);
        }
    } catch (\Exception $e) {
        // Return error response with the exception message
        return response()->json([
            'success' => false,
            'message' => $e->getMessage()
        ], 500);
    }
}

    public function setLanguage(Request $request){
        $post = $request->all();
        if (array_key_exists($post['lang_code'], Config::get('languages'))) {
            if (isset($post['lang_code'])) {
                $direction = \Helpers::getLangData($post['lang_code']);
                if (auth()->user() && auth()->user()->type == 'user') {
                    User::where('id',auth()->user()->id)->update(['language_code'=>$post['lang_code']]);
                    Session::put('locale', $post['lang_code']);
                    Session::put('direction', $direction);
                    setcookie('lang_code',$post['lang_code'],time()+60*60*24*365);
                }else{
                    Session::put('locale', $post['lang_code']);
                    Session::put('direction', $direction);
                    setcookie('lang_code',$post['lang_code'],time()+60*60*24*365);
                }
            }
        }
        return redirect()->back();
    }

    /**
     * Log the user out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     */

    public function userLogout(Request $request)
    {
        Auth::logout();
        return redirect('/')->with('success', __('lang.alert_logout_successfully'));
    }

    public function updateProfile(Request $request)
    {
        // Check if the new email is unique, excluding the current user's email
        $emailIsExist = User::where('email', $request->input('email'))
                        ->where('id', '<>', $request->id)
                        ->exists();
            if($emailIsExist){
                return redirect()->back()->withError('Email is already exist.');
            }
            $input = [
                'name' => $request->input('name'),
                'email' => $request->input('email'),
                'updated_at' => now(),
            ];

        User::where('id', $request->input('id'))->update($input);
        return redirect()->back()->with('message', __('lang.alert_profile_updated_successfully'));
    }

    public function addCard(Request $request){
        $post = $request->all();

        request()->validate([
            'card_holder_name' => 'required',
            'card_type' => 'required',
            'card_no' => 'required',
            'month' => 'required',
            'year' => 'required',
            'cvv' => 'required'
        ]);

        if(!empty($post)){
            $input = array(
                'user_id' =>  isset($post['user_id']) ? $post['user_id'] : '',
                'card_type' => isset($post['card_type']) ? $post['card_type'] : 'VISA',
                'card_holder_name' => isset($post['card_holder_name']) ? $post['card_holder_name'] : '',
                'card_no' => isset($post['card_no']) ? $post['card_no'] : '',
                'month' => isset($post['month']) ? $post['month'] : '',
                'year' => isset($post['year']) ? $post['year'] : '',
                'cvv' => isset($post['cvv']) ? $post['cvv'] : '',
                'set_as_default' => 0,
                'created_at' => date("Y-m-d H:i:s")
            );
            $card = UserCards::insert($input);
            Session::flash('message', __('lang.alert_card_added_successfully'));
            return redirect()->back()->with('message',__('lang.alert_card_added_successfully'));
        }else{
            return redirect()->back();
        }
    }

    public function deleteMyAddress($id)
    {
        // Remove the foreign key constraint
        \DB::statement('ALTER TABLE orders DROP FOREIGN KEY orders_delivery_address_id_foreign');

        // Now update orders to set delivery_address_id to NULL
        \DB::table('orders')->where('delivery_address_id', $id)->update(['delivery_address_id' => null]);

        // Now delete the address
        DeliveryAddresses::where('id', $id)->delete();

        return redirect()->back()->with('message', __('lang.alert_address_deleted_successfully'));
    }


    public function addUpdateAddress(Request $request){
        $post = $request->all();
        if(!empty($post)){
            $user_id = 0;
            if (Auth::check()) {
                $user_id = Auth::user()->id;
            }
              // Validate delivery address
            if (!DeliveryAreas::isValidDeliveryAddress(
                $post['zipcode'],
                $post['city'] ?? null,
                $post['country'] ?? null,
                $post['latitude'] ?? null,
                $post['longitude'] ?? null
            )) {
                return redirect()->back()->with('message', __('lang.alert_invalid_address'));
            }
            
            $location_name = null;
            $google_address = null;
            $state = null;
            $city = null;
            
            if(setting('google_address_map_api_key') != '' && setting('is_enable_google_map_address') == 1){
                
                if(isset($post['location_name']) && $post['location_name']!=''){
                    $location_name = $post['location_name'];
                }
                
                if(isset($post['google_address']) && $post['google_address']!=''){
                    $google_address = $post['google_address'];
                }
                
                if(isset($post['state']) && $post['state']!=''){
                    $state = $post['state'];
                }
                
                if(isset($post['city']) && $post['city']!=''){
                    $city = $post['city'];
                }
            
            }else{
                  
                $deliveryAreas = DeliveryAreas::where('zip_code',$post['zipcode'])->with('state','city')->first();
                if($deliveryAreas){
                    $location_name = $deliveryAreas->location_name;
                    $google_address = $deliveryAreas->location_name;
                    $state = $deliveryAreas->state->state_name;
                    $city = $deliveryAreas->city_id ? City::where('id',$deliveryAreas->city_id)->value('city_name') ?? null : null;
                }
            }


            $postUpdate = array(
                'type' => $post['type'],
                'address' => $post['address'],
                'google_address' => $google_address ?? null,
                'location_name' => $location_name ?? null,
                'note' => $post['note'],
                'city' => $city ?? null,
                'state' => $state ?? null,
                'country' => $post['country'] ?? null,
                'zipcode' => $post['zipcode'],
                'latitude' => $post['latitude'] ?? null,
                'longitude' => $post['longitude'] ?? null,
                'is_default' => 0
            );
            if(isset($post['id'])){
                $postUpdate['updated_at'] = date("Y-m-d H:i:s");
                $id = DeliveryAddresses::where('id',$post['id'])->update($postUpdate);
                return redirect()->back()->with('message',__('lang.alert_address_updated_successfully'));
            }else{
                $postUpdate['user_id'] = $user_id;
                $postUpdate['created_at'] = date("Y-m-d H:i:s");
                $id = DeliveryAddresses::insertGetId($postUpdate);
                return redirect()->back()->with('message',__('lang.alert_address_added_successfully'));
            }
        }else{
            return redirect()->back()->with('message',__('lang.alert_select_mandatory_fields'));
        }
    }

    public function verifyUser(Request $request){
        $user=Auth::user();
        if(!empty($user)){
           if($user->email=='' || $user->email=='--' || $user->name=='' || $user->name=='--') {
            return response()->json(['status'=>false,'redirect'=>false]);
           }else{
            return response()->json(['status'=>true]);
           }
        }
        return response()->json(['status'=>false, 'redirect'=>true]);
    }
    
    public function saveUserDetails(Request $request){
        $user=Auth::user();
        if(!empty($user)){
            $rules = [
                'username' => 'required|string|max:255',
                'email' => 'required|email|max:255|unique:users'
            ];
            $validator = Validator::make($request->all(), $rules);
            if ($validator->fails()) {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput()->with('profileModalOpen', true); ;
            }
            $user->email=$request->email;
            $user->name=$request->username;
            $user->save();
            return redirect()->back()->with('message','Profile updated successfully! Now you can continue with checkout process.');
            //return response()->json(['status'=>true,'message' => 'Profile updated successfully!']);
        }
        return redirect('/signin')->with('message','Invalid user.');
    }
    
    public function updateToken(Request $request){
        try{
            $user=Auth::user();
            if(empty($user)){
                return response()->json([
                    'success'=>false
                ],500);
            }
            $tokens=[];
            $allTokens=[];
             // Decode JSON and handle errors
            $decodedTokens = json_decode($user->fcm_token, true);
            // Check if decoding failed or if the result is not an array
            if (json_last_error() !== JSON_ERROR_NONE || !is_array($decodedTokens)) {
                $decodedTokens = [];
            }

            $tokens = $decodedTokens;

            if (in_array($request->token, $tokens)) {
                return response()->json([
                    'success'=>true
                ]);
            }
            if(empty($tokens)){
                array_push($allTokens, $request->token);
            }elseif(count($tokens)<5){
                $allTokens=$tokens;
                array_push($allTokens, $request->token);
            }else{
                array_shift($tokens);
                $allTokens=$tokens;
                array_push($allTokens, $request->token);
            }
            $user->fcm_token= json_encode($allTokens);
            $user->save();
            return response()->json([
                'success'=>true
            ]);
        }catch(\Exception $e){
            report($e);
            return response()->json([
                'success'=>false
            ],500);
        }
    }

    public function checkUpdateUserCart(Request $request)
    {
        $user = auth()->user();
        $cartItems = Cart::where('user_id', $user->id)->with('product')->get();
        $updatedCartItems = [];
        foreach ($cartItems as $cartItem) {
            $product = $cartItem->product;
            $oldPrice = $cartItem->per_item_amount;
            $oldQuantity = $cartItem->quantity;

            // Dconsidering discount if available
            $effectivePrice = ($product->discount_price !== null && $product->discount_price >'0.0') ? $product->discount_price : $product->price;

            // Check if the effective price or minimum order quantity has changed
            $priceChanged = $oldPrice != $effectivePrice;
            $minOrderQtyChanged = $oldQuantity < $product->minimum_order_quantity;

            if ($priceChanged || $minOrderQtyChanged) {
                // Update the cart item's price and quantity if necessary
                $cartItem->per_item_amount = $effectivePrice;

                if ($minOrderQtyChanged) {
                    $cartItem->quantity = $product->minimum_order_quantity;
                }

                $cartItem->per_delivery_amount = $cartItem->quantity * $cartItem->per_item_amount;
                $cartItem->total_delivery_amount = $cartItem->per_delivery_amount * $cartItem->no_of_delivery;

                // Save changes to the cart item
                $cartItem->save();

                // Add updated cart item to the array
                $updatedCartItems[] = [
                    'cart_id' => $cartItem->id,
                    'product_id' => $cartItem->product_id,
                    'product_name' => $product->name,
                    'old_price' => $oldPrice,
                    'new_price' => $cartItem->per_item_amount,
                    'old_quantity' => $oldQuantity,
                    'new_quantity' => $cartItem->quantity,
                    'discounted_price' => $product->discount_price,
                ];
            }
        }
        return response()->json([
            'status' => 'success',
            'message' => count($updatedCartItems) > 0 ? 'Cart updated with new prices and quantities.' : 'No changes in the cart.',
            'updatedItems' => $updatedCartItems,
        ]);
    }
    
    
    /**
     * get city.
     *
     * @param  Request  $request
     * @return \Illuminate\Http\Response
    **/
    public function getCityStateByZipcode(Request $request)
    {
        $post = $request->all();
        
        $deliveryAreas = DeliveryAreas::where('zip_code',$post['zip_code'])->with('city')->with('state')->first();
        $city = '';
        $state = '';
        
        if($deliveryAreas){
            $state = $deliveryAreas->state ? $deliveryAreas->state->state_name ?? null : null;
            $city = $deliveryAreas->city_id ? City::where('id',$deliveryAreas->city_id)->value('city_name') ?? null : null;
        }

        $response = [
            'status' => true,
            'state' => $state,
            'city' => $city,
            'message' => "Data fetched successfully.",
        ];
        return response($response);
    }
    
    
    public function getZipCodes(Request $request)
    {
        $search = $request->input('search');
    
        // Query delivery areas based on the search term
        $deliveryAreas = DeliveryAreas::where('zip_code', 'LIKE', "%{$search}%")
            ->orWhere('location_name', 'LIKE', "%{$search}%")
            ->get();
    
        // Return JSON response
        return response()->json($deliveryAreas);
    }


}