<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\CmsPages;
use App\Models\CmsPagesTranslation;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;

class SiteContentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = CmsPages::with('translation')->orderBy('id','DESC')->get();
        return view('site_contents.index',compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = CmsPages::find($id);
        return view('site_contents.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $postUpdate = array(
            'page_title' => $input['page_title'],
            'description' => $input['description']
        );
        CmsPages::where('id',$id)->update($postUpdate);
        return redirect()->route('site_contents.index')->with('success',__('lang.message_record_updated_successfully'));
    }


    /**
     * Update the status
     */
    public function changeStatus($id){

        $data = CmsPages::find($id);

        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }

        return redirect()->route('site_contents.index')
                        ->with('success',__('lang.message_status_updated_successfully'));

    }

     /**
     * view translation
     */
    public function translation($id)
    {
        $data = CmsPages::find($id);
        $languages = Languages::where('status',1)->get();
        foreach ($languages as $row) {
            $row->details = CmsPagesTranslation::where('cms_id',$id)->where('lang_code',$row->language_code)->first();
            if(!$row->details){
                $postData = array(
                    'cms_id' => $id,
                    'lang_code' => $row->language_code,
                    'page_title' => $data->page_title,
                    'description' => $data->description,
                    'created_at' => date("Y-m-d H:i:s")
                );
                CmsPagesTranslation::insert($postData);
                $row->details = CmsPagesTranslation::where('cms_id',$id)->where('lang_code',$row->language_code)->first();
            }
        }
        return view('site_contents.translation',compact('data'))->with('languages',$languages);
    }

    public function updateTranslation($id,Request $request)
    {
        $post = $request->all();

        request()->validate([
            'language_code' => 'required',
            'page_title' => 'required',
            'description' => 'required',
        ]);
        $input = $request->all();

        for ($i=0; $i < count($input['language_code']); $i++) { 
            if($input['language_code'][$i] == 'en'){
                $updateData = array(
                    'page_title' => $input['page_title'][$i],
                    'description'  => $input['description'][$i]
                );
                CmsPages::where('id',$id)->update($updateData);
            }

            $postData = array(
                'lang_code' => $input['language_code'][$i],
                'page_title' => $input['page_title'][$i],
                'description' => $input['description'][$i],
                'updated_at' => date("Y-m-d H:i:s")
            );
            CmsPagesTranslation::where('id',$input['translation_id'][$i])->update($postData);
        }
        
        return redirect()->route('site_contents.index')
                        ->with('success',__('lang.message_translation_updated_successfully'));
    }


    public function translateByThirdParty(Request $request)
    {
        $post = $request->all();
        $data = \Helpers::translate($post['text'],$post['name']);
        return response($data);
    }

    public function translationByGoogle(Request $request)
    {
        $post = $request->all();
        $data = \Helpers::googleTranslation($post['text'],$post['code']);
        return response($data);
    }
}
