<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Role;
use App\Models\Permission;
use App\Http\Requests\Role\StoreRoleRequest;
use App\Http\Requests\Role\UpdateRoleRequest;
use DB;
use Session;


class RoleController extends Controller
{
    /**
     * Display a listing of the live news.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    */
public function index(Request $request)
{
    try {
        $data['result'] = Role::getLists($request->all());
        $data['permission'] = Permission::orderBy('module')->groupBy('group')->get();

        foreach ($data['permission'] as $row) {
            $row->permission = Permission::where('group', $row->group)
                ->orderBy('module') // Order by the module name
                ->orderBy('id') // Add this line to maintain the order within each module
                ->orderBy('permission_name') // Then order alphabetically by permission_name
                ->get();
        }

        return view('roles.index', $data);            
    } 
    catch (\Exception $ex) {
        return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile());
    }
}


    /**
     * Store a newly created live news in storage.
     *
     * @param  \App\Http\Requests\StoreRoleRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreRoleRequest $request)
    {
        try{
            $validated = $request->validated();
            $added = Role::addUpdate($request->all());
            if($added['status']){
                return redirect('admin/role')->with('success', __('lang.message_record_created_successfully')); 
            }
            else{
                return redirect()->back()->with('error', $added['message']);
            }
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Update the specified live news in storage.
     *
     * @param  \App\Http\Requests\UpdateLiveNewsRequest  $request
     * @param  \App\Models\LiveNews  $liveNews
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateRoleRequest $request)
    {
        try{
            $validated = $request->validated();
            $updated = Role::addUpdate($request->all(),$request->input('id'));
            if($updated['status']){
                return redirect('admin/role')->with('success',__('lang.message_record_updated_successfully')); 
                
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Remove the specified live news from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            $deleted = Role::deleteRecord($id);
            if($deleted['status']){
                return redirect()->back()->with('success', __('lang.message_record_deleted_successfully')); 
            }
            else{
                return redirect()->back()->with('error', $deleted['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Remove the specified category from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function changeStatus($id,$status)
    {
        try{
            $updated = Role::changeStatus($status,$id);
            if($updated['status']){
                return redirect()->back()->with('success', __('lang.message_status_updated_successfully'));
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
}
