<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\PushNotification;
use App\Models\UserAuthLogin;
use Illuminate\Support\Facades\Session;
class PushNotificationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = PushNotification::getLists();
        return view('notifications.index',compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'title' => 'required',
            'description' => 'required',
        ]);
        $input = $request->all();
        $postData = array(
            'title' => $input['title'],
            'description' => $input['description'],
            'created_at' => date("Y-m-d H:i:s")
        );
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/notification/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $postData['image'] = "$profileImage";
        }
        PushNotification::create($postData);

        $tokens = array();
        $player_ids = array();
        if(setting('is_enable_one_signal')){
            $allTokens = UserAuthLogin::where('player_id','!=','web')->where('player_id','!=','')->where('player_id','!=','1')->pluck('player_id');
            foreach ($allTokens as $r) {
                array_push($player_ids, $r);
            }
        }else{
            $allPlayers = UserAuthLogin::where('fcm_token','!=','web')->where('fcm_token','!=','')->where('fcm_token','!=','1')->pluck('fcm_token');
            foreach ($allPlayers as $p) {
                array_push($tokens, $p);
            }
        }

        $key = setting('fcm_key');
        if(setting('is_enable_one_signal')){
            $c = \Helpers::sendNotification($player_ids,$input['description'],$input['title'],$key);
        }else{
            $c = \Helpers::sendNotification($tokens,$input['description'],$input['title'],$key);

            if($c == 401){
                return redirect()->back()->with('error',__('lang.message_upload_firebase_credentails_json_file'));
            }
        }

        return redirect()->route('notifications.index')
                        ->with('success',__('lang.message_record_created_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        PushNotification::find($id)->delete();
        return redirect()->route('notifications.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
    }
}
