<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Paytm\Checksum\PaytmChecksum;

class PaytmController extends Controller
{

    private $merchantKey = 'TmRz@ltVegOR&2%d';
    private $merchantId = 'lPwWtJ64184445159312';
    private $website = 'WEBSTAGING'; // Change to 'DEFAULT' for production
    private $industryType = 'Retail';
    private $channelId = 'WEB';
    private $paytmUrl = 'https://securegw.paytm.in/order/process';

    public function initiatePayment(Request $request)
    {
        $orderId = 'ORDER_' . time();

        $params = [
            'MID'              => $this->merchantId,
            'WEBSITE'          => $this->website,
            'INDUSTRY_TYPE_ID' => $this->industryType,
            'CHANNEL_ID'       => $this->channelId,
            'ORDER_ID'         => $orderId,
            'CUST_ID'          => 'CUSTOMER_ID', // Replace with your customer ID
            'TXN_AMOUNT'       => '1.00',        // Replace with the actual transaction amount
            'CALLBACK_URL'     => route('paytm.callback'),
        ];

        $checksum = PaytmChecksum::generateSignature($params, $this->merchantKey);
        $params['CHECKSUMHASH'] = $checksum;

        return view('paymentgateway.paytm', ['paytmUrl' => $this->paytmUrl, 'params' => $params]);
    }

    public function handleCallback(Request $request)
    {
        $paytmChecksum = $request->input('CHECKSUMHASH');
        $isValidChecksum = PaytmChecksum::verifySignature($request->all(), $this->merchantKey, $paytmChecksum);

        if ($isValidChecksum) {
            // Payment successful, process the order
            // Update your database or perform other actions
            return view('paytm.success');
        } else {
            // Payment failed, handle accordingly
            return view('paytm.failure');
        }
    }
}
