<?php

namespace App\Http\Controllers\PaymentGateway;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Session;
use Stripe;
use App\Models\UserPayment;
use app\Helpers;
use App\Models\AppSetting;
use App\Models\OrderProduct;
use App\Models\Order;
use Illuminate\Support\Facades\Auth;


class StripePaymentController extends Controller
{
    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function stripe()
    {
        return view('paymentgateway.stripe');
    }

    /**
     * success response method.
     *
     * @return \Illuminate\Http\Response
     */
    public function payment($request,$orderId,$user_id)
    {
        $user=Auth::user();
        \Stripe\Stripe::setApiKey(setting('stripe_secret_key'));
        $customer = Stripe\Customer::create(array(
            'name' => $request->name,
            'email' => 'akshitamishra08@gmail.com',
            'source' => $request['stripeToken'],
        ));
        $order= Order::find($orderId);
        if(empty($order)){
            return redirect()->back()->withError('Order/Cart is empty.');
        }else{
            $order->payment_refferance_id=$customer->id;
            $order->save();
        }
        $total_pay = 0;
        $data = Stripe\Charge::create ([
                "amount" =>round(100 * $order->final_amount),
                "currency" => AppSetting::get_setting('default_currency_code'),
                //"source" => $request->stripeToken,
                'customer'=> $customer->id,
                "description" => "Order placed successfully.",
                'metadata' => array(
                    'name' => $request->name ?? $user->name,
                    'email' => $request->email ?? $user->email,
                    'user_id' => $user_id
                )
        ]);
       // dd($data['customer']);
       if (isset($data['status']) && $data['status'] === 'succeeded') {
        // Find the order by payment reference ID
            $order = Order::where('payment_refferance_id', $data['customer'])->first();
            $payment=UserPayment::where('id',$order->payment_id)->first();
            if (!empty($order)) {
                // Update the order with transaction details
                $order->payment_transection_id = $data['id'];
                $order->payment_transection_data = json_encode($data);
                $order->payment_status = 1; // Payment succeeded
                $order->save();

                // Clear the user's cart
                \Helpers::clearAuthUserCart();
                if(!empty($payment)){
                    $payment->payment_refferance_id=$data['customer'];
                    $payment->payment_transection_id=$data['id'];
                    $payment->payment_transection_data=  json_encode($data);
                    $payment->payment_status=1;
                    $payment->status='Paid';
                    $payment->save();
                }

                // Return success response with HTTP 200 OK
                return response()->json([
                    'success' => true,
                    'message' => 'Your payment has been done and order placed successfully.',
                    'data' => [
                        'orderId' => $order->id
                    ]
                ], 200);
            }

            // Order not found, return error response with HTTP 404 Not Found
            return response()->json([
                'success' => false,
                'message' => 'Order not found.'
            ], 404);

        } else {
            // Handle failed or cancelled payment
            $order = Order::where('payment_refferance_id', $data['customer'])->first();
            $payment=UserPayment::where('id',$order->payment_id)->first();
            if (!empty($order)) {
                // Update payment status
                $order->payment_status = 2; // Payment failed or cancelled
                $order->save();
                if(!empty($payment)){
                    $payment->payment_refferance_id=$data['customer'];
                    $payment->payment_status=2;
                    $payment->status='Failed';
                    $payment->save();
                }

                // Determine the message based on payment status
                $message = $order->payment_status == 3
                    ? "Order payment has been cancelled."
                    : "Order payment has been failed.";

                // Return failure response with HTTP 400 Bad Request
                return response()->json([
                    'success' => false,
                    'message' => $message
                ], 400);
            }

            // If order is not found, return error response with HTTP 404 Not Found
            return response()->json([
                'success' => false,
                'message' => __('lang.admin_you_have_canceled_the_transaction')
            ], 404);
        }
    }
}
