<?php

namespace App\Http\Controllers\PaymentGateway;

use App\Http\Controllers\Controller;
use App\Models\AppSetting;
use Illuminate\Http\Request;
use App\Models\OrderProduct;
use App\Models\Order;
use League\CommonMark\Extension\Attributes\Node\Attributes;
use Razorpay\Api\Api;
use App\Models\UserPayment;
use App\Models\UserWallet;
use Illuminate\Support\Facades\Auth;

class RazorpayController extends Controller
{
    private $razorpay_key='';
    private $razorpay_secret='';
    public function __construct()
    {
        $this->razorpay_key=AppSetting::get_setting('razorpay_key');
        $this->razorpay_secret=AppSetting::get_setting('razorpay_secret');

    }
    public function payment($request,$orderId,$orderPostData,$user){
        try{
            $order= Order::find($orderId);
            $user_payment=UserPayment::where('id',$order->payment_id)->first();
            if(empty($order)){
                return redirect()->back()->withError('Order/Cart is empty.');
            }
            $api = new Api($this->razorpay_key,$this->razorpay_secret);
            $payment = $api->payment->fetch($request['razorpay_payment_id'])->capture(['amount'=>$order->final_amount*100,'currency' => AppSetting::get_setting('default_currency_code')]);
            if ($payment->status === 'captured') {
                if (!empty($payment->acquirer_data)) {
                    $order->payment_refferance_id=$payment->id;
                    $order->payment_transection_id=json_encode((array)$payment->acquirer_data);
                    $order->payment_transection_data=json_encode((array)$payment);
                    $order->payment_status=1;
                    $order->save();
                    \Helpers::clearAuthUserCart();
                    if(!empty($user_payment)){
                        $user_payment->payment_refferance_id=$payment->id;
                        $user_payment->payment_transection_id=json_encode((array)$payment->acquirer_data);
                        $user_payment->payment_transection_data=json_encode((array)$payment);
                        $user_payment->payment_status=1;
                        $user_payment->status='Paid';
                        $user_payment->save();
                    }
                    return redirect('orders')->with(['message'=>'Your payment has been done and order placed successfully.']);
                }
                return redirect('orders')->withError('Order not found.');
            } else {
                $order->payment_refferance_id=$request['razorpay_payment_id'];
                $order->payment_status=$request->status=='cancelled'?3:2;
                $order->save();
                if(!empty($user_payment)){
                    $user_payment->payment_refferance_id=$request['razorpay_payment_id'];
                    $user_payment->payment_status=$request->status=='cancelled'?3:2;
                    $user_payment->status='Failed';
                    $user_payment->save();
                }
                $message=$order->payment_status==3 ? "Order payment has been cancelled.":"Order payment has been failed.";
                return redirect('orders')->withError($message);
            }
        }catch(\Exception $e){
            return redirect('orders')->withError($e->getMessage());
        }
    }

    public function walletPayment($request){
        try{
            // ==================================================
            $user_payments= UserPayment::find($request['paymentid']);
            $user_payments->method='razorpay';
            $user_payments->save();
            // ===================================================
            $user_payment= UserPayment::find($request['paymentid']);
            $user_id = 0;
            if (Auth::check()) {
                $user_id = Auth::user()->id;
            }
            if(empty($user_payment)){
                return redirect()->back()->withError('wallet payment not happen.Try again');
            }
            $api = new Api($this->razorpay_key,$this->razorpay_secret);
            $payment = $api->payment->fetch($request['razorpay_payment_id'])->capture(['amount'=>$user_payment->price*100,'currency' => AppSetting::get_setting('default_currency_code')]);
            if ($payment->status === 'captured') {
                    if (!empty($payment->acquirer_data)) {
                        $user_payment->payment_refferance_id=$payment->id;
                        $user_payment->payment_transection_id=json_encode((array)$payment->acquirer_data);
                        $user_payment->payment_transection_data=json_encode((array)$payment);
                        $user_payment->payment_status=1;
                        $user_payment->method=$request['payment_method'];
                        $user_payment->save();
                        $wallet = [
                            'user_id'=>$user_id,
                            'order_id'=>-1,
                            'payment_id'=>$user_payment->id,
                            'type'=>'credit',
                            'amount'=>$user_payment->price,
                            'description'=> 'We have credit '.\Helpers::currency($user_payment->price).' in your wallet.',
                            'created_at'=>date('Y-m-d H:i:s')
                        ];
                        $user_wallet = UserWallet::insertGetId($wallet);
                        return redirect('wallet')->with(['message'=>'Your wallet has been credited with'.$user_payment->price]);
                    }
                    return redirect('orders')->withError('Wallet payment not found.');
            } else {
                $user_payment->payment_refferance_id=$request['razorpay_payment_id'];
                $user_payment->payment_status=$request->status=='cancelled'?3:2;
                $user_payment->method=$request['payment_method'];
                $user_payment->save();
                $message=$user_payment->payment_status==3 ? "Order payment has been cancelled.":"Order payment has been failed.";
                return redirect('wallet')->withError($message);
            }
        }catch(\Exception $e){
            return redirect('wallet')->withError($e->getMessage());
        }
    }
}
