<?php

namespace App\Http\Controllers\PaymentGateway;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Ixudra\Curl\Facades\Curl;
use Illuminate\Support\Facades\Auth;
use app\Helpers;
use App\Models\AppSetting;
use App\Models\OrderProduct;
use App\Models\Order;
use App\Models\UserPayment;
use App\Models\UserWallet;

class PhonePeController extends Controller
{
    private $url = '';
    private $merchant_id = '';
    private $salt_index = 1;
    private $salt_key= '';
    private $is_live= false;

    public function __construct()
    {
        if(!$this->is_live){
            $this->url='https://api-preprod.phonepe.com/apis/pg-sandbox';
        }else{
            $this->url='https://api.phonepe.com/apis/hermes';
        }
        $this->merchant_id = AppSetting::get_setting('phonepe_merchant_id');
        $this->salt_key =AppSetting::get_setting('phonepe_salt_key');
    }
    public function payment($request,$orderId,$orderPostData,$user)
    {
        $order= Order::find($orderId);
        if(empty($order)){
            return redirect()->back()->withError('Order/Cart is empty.');
        }
        $merchantTransactionId='PP'.rand(10000, 99999).'U'.$user->id.'T'.$order->id;
        $order->payment_refferance_id=$merchantTransactionId;
        $order->save();
        $data = array (
            "merchantId" => $this->merchant_id,
            "merchantTransactionId" =>$merchantTransactionId,
            "merchantUserId" => $user->id,
            "amount" => $order->final_amount*100,
            "redirectUrl" => route('phonepe.success.payment'),
            "redirectMode" => 'POST',
            "callbackUrl" => route('phonepe.success.payment'),
            "mobileNumber" => $user->phone  ?? "+919000000000",
            'paymentInstrument' =>
            array (
            'type' => 'PAY_PAGE',
            ),
        );
        $encode = base64_encode(json_encode($data));
        $string = $encode.'/pg/v1/pay'.$this->salt_key;
        $sha256 = hash('sha256',$string);
        $finalXHeader = $sha256.'###'.$this->salt_index;
        $url = $this->url."/pg/v1/pay";
        $response = Curl::to($url)
            ->withHeader('Content-Type:application/json')
            ->withHeader('X-VERIFY:'.$finalXHeader)
            ->withData(json_encode(['request' => $encode]))
            ->post();
        $rData = json_decode($response, true); // Get an associative array instead of an object
        if (isset($rData['error'])) {
            return redirect()->back()->withErrors(['error' => __('lang.admin_payment_failed')]);
        }
        if (!isset($rData['data']['instrumentResponse']['redirectInfo']['url'])) {
            return redirect()->back()->withErrors(['error' => __('lang.admin_payment_failed')]);
        }else{
            return redirect()->to($rData['data']['instrumentResponse']['redirectInfo']['url']);
        }
    }

    public function success(Request $request)
    {
        $input = $request->all();
        $finalXHeader = hash('sha256','/pg/v1/status/'.$this->merchant_id.'/'.$input['transactionId'].$this->salt_key).'###'.$this->salt_index;
        $response = Curl::to($this->url.'/pg/v1/status/'.$this->merchant_id.'/'.$input['transactionId'])
                ->withHeader('Content-Type:application/json')
                ->withHeader('accept:application/json')
                ->withHeader('X-VERIFY:'.$finalXHeader)
                ->withHeader('X-MERCHANT-ID:'.$input['transactionId'])
                ->get();
        $response= json_decode($response,true);
        if(!empty($response) && $response['code']=='PAYMENT_SUCCESS'){
                $order= Order::where('payment_refferance_id',$response['data']['merchantTransactionId'])->first();
                $payment=UserPayment::where('id',$order->payment_id)->first();
                if(!empty($order)){
                    $order->payment_transection_id=$response['data']['transactionId'];
                    $order->payment_transection_data= json_encode($response['data']);
                    $order->payment_status=1;
                    $order->save();
                    \Helpers::clearAuthUserCart();
                    if(!empty($payment)){
                        $payment->payment_refferance_id=$response['data']['merchantTransactionId'];
                        $payment->payment_transection_id=$response['data']['transactionId'];
                        $payment->payment_transection_data=json_encode($response['data']);
                        $payment->payment_status=1;
                        $payment->status='Paid';
                        $payment->save();
                    }
                    return redirect('orders')->with(['message'=>'Your payment has been done and order placed successfully.']);
                }
                return redirect('orders')->withError('Order not found.');
        }else{
            $order= Order::where('payment_refferance_id',$input['transactionId'])->first();
            $payment=UserPayment::where('id',$order->payment_id)->first();
            if(!empty($order)){
                $order->payment_status=$request->status=='cancelled'?3:2;
                $order->save();
                if(!empty($payment)){
                    $payment->payment_refferance_id=$input['transactionId'];
                    $payment->payment_status=$request->status=='cancelled'?3:2;
                    $payment->status='Failed';
                    $payment->save();
                }
                $message=$order->payment_status==3 ? "Order payment has been cancelled.":"Order payment has been failed.";
                return redirect('orders')->withError($message);
            }
            return redirect('orders')->withError('Order not found.');
        }

    }
    public function walletPayment($request)
    {
        $UserPayment= UserPayment::find($request['paymentid']);
        $user_id = 0;
        if (Auth::check()) {
            $user= Auth::user();
        }
        if(empty($UserPayment)){
            return redirect()->back()->withError('Wallet is empty.');
        }
        $merchantTransactionId='W'.rand(10000, 99999).'U'.$user->id.'T'.$request['paymentid'];
        $UserPayment->payment_refferance_id=$merchantTransactionId;
        $UserPayment->method=$request['payment_method'];
        $UserPayment->save();
        $data = array (
            "merchantId" => $this->merchant_id,
            "merchantTransactionId" =>$merchantTransactionId,
            "merchantUserId" => $user->id,
            "amount" => $UserPayment->price*100,
            "redirectUrl" => route('phonepe-wallet.success.payment'),
            "redirectMode" => 'POST',
            "callbackUrl" => route('phonepe-wallet.success.payment'),
            "mobileNumber" => $user->phone  ?? "+919000000000",
            'paymentInstrument' =>
            array (
            'type' => 'PAY_PAGE',
            ),
        );
        $encode = base64_encode(json_encode($data));
        $string = $encode.'/pg/v1/pay'.$this->salt_key;
        $sha256 = hash('sha256',$string);
        $finalXHeader = $sha256.'###'.$this->salt_index;
        $url = $this->url."/pg/v1/pay";
        $response = Curl::to($url)
            ->withHeader('Content-Type:application/json')
            ->withHeader('X-VERIFY:'.$finalXHeader)
            ->withData(json_encode(['request' => $encode]))
            ->post();
        $rData = json_decode($response, true); // Get an associative array instead of an object
        if (isset($rData['error'])) {
            return redirect()->back()->withErrors(['error' => __('lang.admin_payment_failed')]);
        }
        if (!isset($rData['data']['instrumentResponse']['redirectInfo']['url'])) {
            return redirect()->back()->withErrors(['error' => __('lang.admin_payment_failed')]);
        }else{
            return redirect()->to($rData['data']['instrumentResponse']['redirectInfo']['url']);
        }
    }

    public function walletSuccess(Request $request)
    {
        $input = $request->all();
        $user_id = 0;
        if (Auth::check()) {
            $user= Auth::user();
        }
        $finalXHeader = hash('sha256','/pg/v1/status/'.$this->merchant_id.'/'.$input['transactionId'].$this->salt_key).'###'.$this->salt_index;
        $response = Curl::to($this->url.'/pg/v1/status/'.$this->merchant_id.'/'.$input['transactionId'])
                ->withHeader('Content-Type:application/json')
                ->withHeader('accept:application/json')
                ->withHeader('X-VERIFY:'.$finalXHeader)
                ->withHeader('X-MERCHANT-ID:'.$input['transactionId'])
                ->get();
        $response= json_decode($response,true);
        if(!empty($response) && $response['code']=='PAYMENT_SUCCESS'){
                $UserPayment= UserPayment::where('payment_refferance_id',$response['data']['merchantTransactionId'])->first();
                if(!empty($UserPayment)){
                    $UserPayment->payment_transection_id=$response['data']['transactionId'];
                    $UserPayment->payment_transection_data= json_encode($response['data']);
                    $UserPayment->payment_status=1;
                    $UserPayment->save();
                     /* wallet amount save */
                    $wallet = [
                        'user_id'=>$user->id,
                        'order_id'=>-1,
                        'payment_id'=>$UserPayment->id,
                        'type'=>'credit',
                        'amount'=>$UserPayment->price,
                        'description'=> 'We have credit '.\Helpers::currency($UserPayment->price).' in your wallet.',
                        'created_at'=>date('Y-m-d H:i:s')
                    ];
                    $user_wallet = UserWallet::insertGetId($wallet);
                    return redirect('wallet')->with(['message'=>'Wallet payment has been done.']);
                }
                return redirect('wallet')->withError('Wallet not found.');
        }else{
            $UserPayment= UserPayment::where('payment_refferance_id',$input['transactionId'])->first();
            if(!empty($UserPayment)){
                $UserPayment->payment_status=$request->status=='cancelled'?3:2;
                $UserPayment->save();
                $message=$UserPayment->payment_status==3 ? "Wallet payment has been cancelled.":"Wallet payment has been failed.";
                return redirect('Wallet')->withError($message);
            }
            return redirect('Wallet')->withError('Wallet not found.');
        }

    }
}
