<?php

namespace App\Http\Controllers\PaymentGateway;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Anand\LaravelPaytmWallet\Facades\PaytmWallet;
use Paytm\Checksum\PaytmChecksum;

class PaytmController extends Controller
{
    public function initiate()
    {
        return view('paymentgateway.paytm');
    }

    public function paymentMethod(Request $request)
    {
        $amount = 1500; // Amount to be paid

        $userData = [
            'name' => $request->name,
            'mobile' => $request->mobile,
            'email' => $request->email,
            'fee' => $amount,
            'order_id' => $request->mobile."_".rand(1,1000)
        ];

        // Prepare the payment
        $payment = PaytmWallet::with('receive');

        $payment->prepare([
            'order' => 'cus_02',
            'user' => 2,
            'mobile_number' => '7489858983',
            'email' => 'pawanrajput2909@gmail.com',
            'amount' => $amount,
            'callback_url' => route('status')
        ]);

        return $payment->receive();  // Initiate a new payment
    }

    public function paymentCallback(Request $request)
    {
        // Retrieve the transaction details
        $transaction = PaytmWallet::with('receive');

        $response = $transaction->response();
        $order_id = $transaction->getOrderId();

        // Verify the checksum
        $isValidChecksum = PaytmChecksum::verifySignature($request->all(), 'TmRz@ltVegOR&2%d', $response['CHECKSUMHASH']);

        if ($isValidChecksum) {
            // Checksum is valid, process the payment
            if ($transaction->isSuccessful()) {
                // Update the database as per the result from the API call
                // Paytm::where('order_id', $order_id)->update(['status' => 1, 'transaction_id' => $transaction->getTransactionId()]);
                return redirect(route('initiate.payment'))->with('message', "Your payment is successful.");
            } elseif ($transaction->isFailed()) {
                // Paytm::where('order_id', $order_id)->update(['status' => 0, 'transaction_id' => $transaction->getTransactionId()]);
                return redirect(route('initiate.payment'))->with('message', "Your payment is failed.");
            } elseif ($transaction->isOpen()) {
                // Paytm::where('order_id', $order_id)->update(['status' => 2, 'transaction_id' => $transaction->getTransactionId()]);
                return redirect(route('initiate.payment'))->with('message', "Your payment is processing.");
            }
        } else {
            // Checksum is invalid, handle accordingly
            return redirect(route('initiate.payment'))->with('message', "Invalid checksum. Payment verification failed.");
        }
    }
}
