<?php

namespace App\Http\Controllers\PaymentGateway;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Paystack;// Paystack package
use app\Helpers;
use Illuminate\Support\Facades\Config;
use App\Models\AppSetting;
use App\Models\OrderProduct;
use App\Models\Order;
use App\Models\UserPayment;
use App\Models\UserWallet;
use Illuminate\Support\Facades\Auth;

class PaystackController extends Controller
{
    public function __construct()
    {
        Config::set('paystack.publicKey', AppSetting::get_setting('paystack_public_key'));
        Config::set('paystack.secretKey', AppSetting::get_setting('paystack_secret_key'));
        Config::set('paystack.merchantEmail', AppSetting::get_setting('paystack_merchant_email'));
    }
    public function payment(Request $request,$orderId,$orderPostData)
    {
        try{
            $order= Order::find($orderId);
            if(empty($order)){
                return redirect()->back()->withError('Order/Cart is empty.');
            }
            $reference=Paystack::genTranxRef();
            $order->payment_refferance_id=$reference;
            $order->save();
            $data = array(
                "amount" => $order->final_amount,
                "reference" => $reference,
                "email" =>    $request->email,
                "currency" => AppSetting::get_setting('default_currency_code'),
                "orderID" => $order->id,
            );
            return Paystack::getAuthorizationUrl($data)->redirectNow()->with('order_id', $orderId);;

        }catch(\Exception $e) {
           return Redirect::back()->with('error', __('lang.admin_paystack_token_expired'));
        }
    }

    public function success(Request $request){
        $data = Paystack::getPaymentData();
        if(isset($data['status']) && $data['status']=='true'){
            $order= Order::where('payment_refferance_id',$data['data']['reference'])->first();
            $payment=UserPayment::where('id',$order->payment_id)->first();
            if(!empty($order)){
                $order->payment_transection_id=$data['data']['id'];
                $order->payment_transection_data= json_encode($data['data']);
                $order->payment_status=1;
                $order->save();
                \Helpers::clearAuthUserCart();
                if(!empty($payment)){
                    $payment->payment_refferance_id=$data['data']['reference'];
                    $payment->payment_transection_id=$data['data']['id'];
                    $payment->payment_transection_data= json_encode($data['data']);
                    $payment->payment_status=1;
                    $payment->status='Paid';
                    $payment->save();
                }
                return redirect('orders')->with(['message'=>'Your payment has been done and order placed successfully.']);
            }
            return redirect('orders')->withError('Order not found.');
        } else {
            $order= Order::where('payment_refferance_id',$request->reference)->first();
            $payment=UserPayment::where('id',$order->payment_id)->first();
                if(!empty($order)){
                    $order->payment_status=2;
                    $order->save();
                    if(!empty($payment)){
                        $payment->payment_refferance_id=$request->reference;
                        $payment->payment_status=2;
                        $payment->status='Failed';
                        $payment->save();
                    }
                    $message=$order->payment_status==3 ? "Order payment has been cancelled.":"Order payment has been failed.";
                    return redirect('orders')->withError($message);
                }
            return redirect('orders')->withError( __('lang.admin_you_have_canceled_the_transaction'));
        }

    }

    public function walletPayment($request)
    {
        //dd($request);
        try{
            $user_id = 0;
            if (Auth::check()) {
                $user= Auth::user();
            }
            $UserPayment= UserPayment::find($request['paymentid']);
            if(empty($UserPayment)){
                return redirect()->back()->withError('Wallet is empty.');
            }
            $reference=Paystack::genTranxRef();
            $UserPayment->payment_refferance_id=$reference;
            $UserPayment->method=$request['payment_method'];
            $UserPayment->save();
            $data = array(
                "amount" => $UserPayment->price,
                "reference" => $reference,
                "email" =>    $user->email,
                "currency" => AppSetting::get_setting('default_currency_code'),
                "order_id" => $request['paymentid'],
                "metadata"=>'wallet'
            );
            return Paystack::getAuthorizationUrl($data)->redirectNow()->with('payment_id', $request['paymentid']);

        }catch(\Exception $e) {
           return redirect('wallet')->with('error', __('lang.admin_paystack_token_expired'));
        }
    }
/*     public function walletSuccess(Request $request){
        $data = Paystack::getPaymentData();
        $user_id = 0;
        if (Auth::check()) {
            $user= Auth::user();
        }
        if(isset($data['status']) && $data['status']=='true'){
            $UserPayment= UserPayment::where('payment_refferance_id',$data['data']['reference'])->first();
            if(!empty($order)){
                $UserPayment->payment_transection_id=$data['data']['id'];
                $UserPayment->payment_transection_data= json_encode($data['data']);
                $UserPayment->payment_status=1;
                $UserPayment->save();

                $wallet = [
                    'user_id'=>$user->id,
                    'order_id'=>-1,
                    'payment_id'=>$UserPayment->id,
                    'type'=>'credit',
                    'amount'=>$UserPayment->price,
                    'description'=> 'We have credit '.\Helpers::currency($UserPayment->price).' in your wallet.',
                    'created_at'=>date('Y-m-d H:i:s')
                ];
                $user_wallet = UserWallet::insertGetId($wallet);
                return redirect('wallet')->with(['message'=>'Wallet payment has been done.']);
            }
            return redirect('wallet')->withError('Wallet not found.');
        } else {
            $UserPayment= UserPayment::where('payment_refferance_id',$request->reference)->first();
                if(!empty($order)){
                    $UserPayment->payment_status=2;
                    $UserPayment->save();
                    $message=$UserPayment->payment_status==3 ? "Wallet payment has been cancelled.":"Wallet payment has been failed.";
                    return redirect('Wallet')->withError($message);
                }
            return redirect('Wallet')->withError( __('lang.admin_you_have_canceled_the_transaction'));
        }

    }
 */
}
