<?php

namespace App\Http\Controllers\PaymentGateway;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Srmklive\PayPal\Services\ExpressCheckout;
use Srmklive\PayPal\Services\PayPal as PayPalClient;
use Illuminate\Support\Facades\Auth;
use app\Helpers;
use App\Models\AppSetting;
use App\Models\OrderProduct;
use App\Models\Order;
use App\Models\UserPayment;
use App\Models\UserWallet;

class PayPalController extends Controller
{
    private $config='';
    public function __construct()
    {
        $app_id=AppSetting::get_setting('paypal_app_id');
        if(empty($app_id)){
            $this->config = [
                'mode'    => 'sandbox',
                'sandbox' => [
                    'client_id'         => AppSetting::get_setting('paypal_client_id'),
                    'client_secret'     => AppSetting::get_setting('paypal_secret_key'),
                    'app_id'            => "APP-80W284485P519543T",
                ],
                'payment_action' => 'Sale',
                'currency'       => AppSetting::get_setting('default_currency_code'),
                'notify_url'     => url('/paypal/notify'),
                'locale'         => 'en_US',
                'validate_ssl'   => false,
            ];
        }else{
            $this->config = [
                'mode'    => 'live',
                'live' => [
                    'client_id'         => AppSetting::get_setting('paypal_client_id'),
                    'client_secret'     => AppSetting::get_setting('paypal_secret_key'),
                    'app_id'            => $app_id,
                ],
                'payment_action' => 'Sale',
                'currency'       => AppSetting::get_setting('default_currency_code'),
                'notify_url'     => url('/paypal/notify'),
                'locale'         => 'en_US',
                'validate_ssl'   => true,
            ];
        }
    }

    public function payment(Request $request,$orderId,$orderPostData)
    {
        $order= Order::find($orderId);
        if(empty($order)){
            return redirect()->back()->withError('Order/Cart is empty.');
        }
        $provider = new PayPalClient($this->config);
        $paypalToken = $provider->getAccessToken();
        $response = $provider->createOrder([
            "intent" => "CAPTURE",
            "application_context" => [
                "return_url" => route('paypal.payment.success'),
                "cancel_url" => route('paypal.payment.cancel'),
                "shipping_preference" => "NO_SHIPPING", // This disables the shipping address
            ],
            "purchase_units" => [
                0 => [
                    "amount" => [
                        "currency_code" => AppSetting::get_setting('default_currency_code'),
                        "value" => $order->final_amount,
                    ],
                    "payer" => [
                        "name" => [
                            "given_name" => Auth::user()->name,
                        ],
                        "email_address" => Auth::user()->email,
                    ],
                ],
            ],
            /* "application_context" => [
                "user_action" => "PAY_NOW", // This forces the immediate payment
                "brand_name" => "Water App",
                "landing_page" => "BILLING", // This specifies the guest checkout
            ], */
        ]);
        if (isset($response['id']) && $response['id'] != null) {
            $order->payment_refferance_id=$response['id'];
            $order->save();
            foreach ($response['links'] as $links) {
                if ($links['rel'] == 'approve') {
                    return redirect()->away($links['href']);
                }
            }
            return redirect()
                ->route('paypal.payment/cancel')
                ->with('error', __('lang.something_went_wrong'));

        } else {
            echo json_encode($response);exit;
            return redirect()
                ->route('paypal.payment/cancel')
                ->with('error', $response['message'] ??  __('lang.something_went_wrong'));
        }
    }

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function paymentCancel(Request $request)
    {
        $order= Order::where('payment_refferance_id',$request->token)->first();
        $payment=UserPayment::where('id',$order->payment_id)->first();
            if(!empty($order)){
                $order->payment_status=3;
                $order->save();
                if(!empty($payment)){
                    $payment->payment_status=3;
                    $payment->status='Failed';
                    $payment->save();
                }
                $message=$order->payment_status==3 ? "Order payment has been cancelled.":"Order payment has been failed.";
                return redirect('orders')->withError($message);
            }
        return redirect('orders')->withError( __('lang.admin_you_have_canceled_the_transaction'));
    }

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function paymentSuccess(Request $request)
    {
        $provider = new PayPalClient($this->config);
        $paypalToken = $provider->getAccessToken();
        $response = $provider->capturePaymentOrder($request['token']);
        $user_id = Auth::user()->id;
        if (isset($response['status']) && $response['status'] == 'COMPLETED') {
            $order= Order::where('payment_refferance_id',$response['id'])->first();
            $payment=UserPayment::where('id',$order->payment_id)->first();
            if(!empty($order)){
                $order->payment_transection_id=$response['purchase_units'][0]['payments']['captures'][0]['id'];
                $order->payment_transection_data= json_encode($response['purchase_units'][0]);
                $order->payment_status=1;
                $order->save();
                \Helpers::clearAuthUserCart();
                if(!empty($payment)){
                    $payment->payment_refferance_id=$response['id'];
                    $payment->payment_transection_id=$response['purchase_units'][0]['payments']['captures'][0]['id'];
                    $payment->payment_transection_data= json_encode($response['purchase_units'][0]);
                    $payment->payment_status=1;
                    $payment->status='Paid';
                    $payment->save();
                }
                return redirect('orders')->with(['message'=>'Your payment has been done and order placed successfully.']);
            }
            return redirect('orders')->withError('Order not found.');
        } else {
            $order= Order::where('payment_refferance_id',$response['id'])->first();
            $payment=UserPayment::where('id',$order->payment_id)->first();
            if(!empty($order)){
                $order->payment_transection_id=$response['purchase_units'][0]['payments']['captures'][0]['id'];
                $order->payment_transection_data= json_encode($response['purchase_units'][0]);
                $order->payment_status=2;
                $order->save();
                if(!empty($payment)){
                    $payment->payment_refferance_id=$response['id'];
                    $payment->payment_transection_id=$response['purchase_units'][0]['payments']['captures'][0]['id'];
                    $payment->payment_transection_data= json_encode($response['purchase_units'][0]);
                    $payment->payment_status=2;
                    $payment->status='Failed';
                    $payment->save();
                }
            }
            return redirect('orders')->withError($response['message'] ?? 'Payment Cancel due to paypal server error.');
        }
    }

    public function walletPayment($request)
    {
        $UserPayment= UserPayment::find($request['paymentid']);
        if(empty($UserPayment)){
            return redirect()->back()->withError('Wallet is empty.');
        }
        $provider = new PayPalClient($this->config);
        $paypalToken = $provider->getAccessToken();
        $response = $provider->createOrder([
            "intent" => "CAPTURE",
            "application_context" => [
                "return_url" => route('paypal-wallet.payment.success'),
                "cancel_url" => route('paypal-wallet.payment.cancel'),
                "shipping_preference" => "NO_SHIPPING", // This disables the shipping address
            ],
            "purchase_units" => [
                0 => [
                    "amount" => [
                        "currency_code" => AppSetting::get_setting('default_currency_code'),
                        "value" => $UserPayment->price,
                    ],
                    "payer" => [
                        "name" => [
                            "given_name" => Auth::user()->name,
                        ],
                        "email_address" => Auth::user()->email,
                    ],
                ],
            ],
            /* "application_context" => [
                "user_action" => "PAY_NOW", // This forces the immediate payment
                "brand_name" => "Water App",
                "landing_page" => "BILLING", // This specifies the guest checkout
            ], */
        ]);
        if (isset($response['id']) && $response['id'] != null) {
            $UserPayment->payment_refferance_id=$response['id'];
            $UserPayment->method=$request['payment_method'];
            $UserPayment->save();
            foreach ($response['links'] as $links) {
                if ($links['rel'] == 'approve') {
                    return redirect()->away($links['href']);
                }
            }
            return redirect()
                ->route('paypal-wallet.payment/cancel')
                ->with('error', __('lang.something_went_wrong'));

        } else {
            return redirect()
                ->route('paypal-wallet.payment/cancel')
                ->with('error', $response['message'] ??  __('lang.something_went_wrong'));
        }
    }


    /**
     * Write code on Method
     *
     * @return response()
     */
    public function walletPaymentSuccess(Request $request)
    {
        $provider = new PayPalClient($this->config);
        $paypalToken = $provider->getAccessToken();
        $response = $provider->capturePaymentOrder($request['token']);
        $user_id = Auth::user()->id;
        if (isset($response['status']) && $response['status'] == 'COMPLETED') {
            $UserPayment= UserPayment::where('payment_refferance_id',$response['id'])->first();
            if(!empty($UserPayment)){
                $UserPayment->payment_transection_id=$response['purchase_units'][0]['payments']['captures'][0]['id'];
                $UserPayment->payment_transection_data= json_encode($response['purchase_units'][0]);
                $UserPayment->payment_status=1;
                $UserPayment->save();

                /* wallet amount save */
                $wallet = [
                    'user_id'=>$user_id,
                    'order_id'=>-1,
                    'payment_id'=>$UserPayment->id,
                    'type'=>'credit',
                    'amount'=>$UserPayment->price,
                    'description'=> 'We have credit '.\Helpers::currency($UserPayment->price).' in your wallet.',
                    'created_at'=>date('Y-m-d H:i:s')
                ];
                $user_wallet = UserWallet::insertGetId($wallet);
                return redirect('wallet')->with(['message'=>'Your wallet payment has been done.']);
            }
            return redirect('wallet')->withError('wallet not found.');
        } else {
            $UserPayment= UserPayment::where('payment_refferance_id',$response['id'])->first();
            if(!empty($order)){
                $UserPayment->payment_transection_id=$response['purchase_units'][0]['payments']['captures'][0]['id'];
                $UserPayment->payment_transection_data= json_encode($response['purchase_units'][0]);
                $UserPayment->payment_status=2;
                $UserPayment->save();
            }
            return redirect('wallet')->withError($response['message'] ?? 'Wallet payment Cancel due to paypal server error.');
        }
    }
    public function walletPaymentCancel(Request $request)
    {
        $UserPayment= UserPayment::where('payment_refferance_id',$request->token)->first();
            if(!empty($UserPayment)){
                $UserPayment->payment_status=3;
                $UserPayment->save();
                $message=$UserPayment->payment_status==3 ? "Wallet payment has been cancelled.":"Wallet payment has been failed.";
                return redirect('orders')->withError($message);
            }
        return redirect('wallet')->withError( __('lang.admin_you_have_canceled_the_transaction'));
    }

}
