<?php

namespace App\Http\Controllers\PaymentGateway;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\LiqPayService;
use App\Models\AppSetting;
use App\Models\OrderProduct;
use App\Models\Order;
use League\CommonMark\Extension\Attributes\Node\Attributes;
use Razorpay\Api\Api;
use App\Models\UserPayment;
use App\Models\UserWallet;
use Illuminate\Support\Facades\Auth;

class LiqPayController extends Controller
{
    protected $liqpayService;

    public function __construct(LiqPayService $liqpayService)
    {
        $this->liqpayService = $liqpayService;
    }

    public function createPayment($request,$orderId,$orderPostData,$user)
    {

        $order= Order::find($orderId);
        $user_payment=UserPayment::where('id',$order->payment_id)->first();
        if(empty($order)){
            return redirect()->back()->withError('Order/Cart is empty.');
        }

        $params = [
            'amount'     => $request->amount,
            'currency'   => $request->currency,
            'description'=> $request->description ?? 'description',
            'order_id'   => uniqid(),
        ];

        $form = $this->liqpayService->createPayment($params);

        return view('paymentgateway.liqpay.payment_form', compact('form'));
    }

    public function handleCallback(Request $request)
    {
        $data = $request->input('data');
        $signature = $request->input('signature');

        // Validate signature
        $calculatedSignature = base64_encode(sha1(setting('liqpay_private_key') . $data . setting('liqpay_private_key'), true));
        if ($calculatedSignature !== $signature) {
            return response()->json(['message' => 'Invalid signature'], 403);
        }

        $decodedData = json_decode(base64_decode($data), true);

        // Handle payment success or failure
        if ($decodedData['status'] === 'success') {
            // Payment was successful
            return response()->json(['message' => 'Payment successful']);
        } else {
            // Payment failed
            return response()->json(['message' => 'Payment failed']);
        }
    }
}
