<?php

namespace App\Http\Controllers\PaymentGateway;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Instamojo\Instamojo;
use App\Models\AppSetting;
use Exception;
use Illuminate\Support\Facades\Auth;
use app\Helpers;
use App\Models\OrderProduct;
use App\Models\Order;
use App\Models\UserPayment;
use App\Models\UserWallet;
use App\Notifications\FcmNotification;

class InstamojoController extends Controller
{
    private $api='';
    public function __construct()
    {
        $this->api = new \Instamojo\Instamojo(
            AppSetting::get_setting('instamojo_api_key'),AppSetting::get_setting('instamojo_auth_token'),AppSetting::get_setting('instamojo_api_endpoint'));
    }
    public function payment($request,$orderId,$orderPostData,$user)
    {
        $order= Order::find($orderId);
        if(empty($order)){
            return redirect()->back()->withError('Order/Cart is empty.');
        }
        try {
            $response = $this->api->paymentRequestCreate([
                "purpose" => "Water App Product purchasing",
                "amount" =>  $order->final_amount,
                "buyer_name" => $request->customer_name ?? $user->name,
                "send_email" => true,
                'send_sms' => true,
                "email" => $request->customer_email ?? $user->email,
                "phone" => $request->phone ?? $user->phone,
                "redirect_url" => route('instamojo.success.payment'),
                'webhook' => 'http://www.example.com/webhook/',
            ]);
            if (isset($response['id']) && $response['id'] != null) {
                $order->payment_refferance_id=$response['id'];
                $order->save();
                header('Location: ' . $response['longurl']);
                exit();
            }else{
                return back()->with(['message'=>__('lang.something_went_wrong')]);
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 1);
        }
    }

    public function instamojoSuccess(Request $request)
    {
        if(empty($request->payment_request_id)){
            return redirect('orders')->withError('Unauthorized or Invalid Transaction');
        }elseif(isset($request->payment_request_id) && $request->payment_status=='Credit'){
            $data = $this->api->paymentRequestStatus(request('payment_request_id'));
            if($data['status']=='Completed'){
                $order= Order::where('payment_refferance_id',$data['id'])->first();
                $payment=UserPayment::where('id',$order->payment_id)->first();
                if(!empty($order)){
                    $order->payment_transection_id=$data['payments'][0]['payment_id'];
                    $order->payment_transection_data= json_encode($data['payments']);
                    $order->payment_status=1;
                    $order->save();
                    \Helpers::clearAuthUserCart();
                    /* send desktop notification to user */
                   /*  $users=Auth::user();
                    $users->notify(new FcmNotification(
                        'New Order : ',
                        'New Order received.',
                        ['url' => '/admin/orders/'.$order->id] // Optional additional data
                    )); */
                    if(!empty($payment)){
                        $payment->payment_refferance_id=$data['id'];
                        $payment->payment_transection_id=$data['payments'][0]['payment_id'];
                        $payment->payment_transection_data= json_encode($data['payments']);
                        $payment->payment_status=1;
                        $payment->status='Paid';
                        $payment->save();
                    }
                    return redirect('orders')->with(['message'=>__('lang.admin_payment_done')]);
                }
                return redirect('orders')->withError('Order not found.');
            }
        }else{
            $order= Order::where('payment_refferance_id',$request->payment_request_id)->first();
            $payment=UserPayment::where('id',$order->payment_id)->first();
            if(!empty($order)){
                $order->payment_transection_id=$request->payment_id;
                $order->payment_status=$request->status=='cancelled'?3:2;
                $order->save();
                if(!empty($payment)){
                    $payment->payment_refferance_id=$request->payment_request_id;
                    $payment->payment_status=$request->status=='cancelled'?3:2;
                    $payment->status='Failed';
                    $payment->save();
                }
                $message=$order->payment_status==3 ? "Order payment has been cancelled.":"Order payment has been failed.";
                return redirect('orders')->withError($message);
            }
            return redirect('orders')->withError('Order not found.');
        }
    }
    public function walletPayment($request)
    {
        $UserPayment= UserPayment::find($request['paymentid']);
        $user_id = 0;
        if (Auth::check()) {
            $user= Auth::user();
        }
        if(empty($UserPayment)){
            return redirect()->back()->withError('Wallet is empty.');
        }
        try {
            $response = $this->api->paymentRequestCreate([
                "purpose" => "Wallet recharge",
                "amount" =>  $UserPayment->price,
                "buyer_name" => $user->name,
                "send_email" => true,
                'send_sms' => true,
                "email" => $user->email,
                "phone" => $user->phone,
                "redirect_url" => route('instamojo-wallet.success.payment'),
                'webhook' => 'http://www.example.com/webhook/',
            ]);
            if (isset($response['id']) && $response['id'] != null) {
                $UserPayment->payment_refferance_id=$response['id'];
                $UserPayment->method=$request['payment_method'];
                $UserPayment->save();
                header('Location: ' . $response['longurl']);
                exit();
            }else{
                return back()->with(['message'=>__('lang.something_went_wrong')]);
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 1);
        }
    }

    public function instamojoWalletSuccess(Request $request)
    {
        $user_id = 0;
        if (Auth::check()) {
            $user= Auth::user();
        }
        if(empty($request->payment_request_id)){
            return redirect('orders')->withError('Unauthorized or Invalid Transaction');
        }elseif(isset($request->payment_request_id) && $request->payment_status=='Credit'){
            $data = $this->api->paymentRequestStatus(request('payment_request_id'));
            if($data['status']=='Completed'){
                $UserPayment= UserPayment::where('payment_refferance_id',$data['id'])->first();
                if(!empty($UserPayment)){
                    $UserPayment->payment_transection_id=$data['payments'][0]['payment_id'];
                    $UserPayment->payment_transection_data= json_encode($data['payments']);
                    $UserPayment->payment_status=1;
                    $UserPayment->save();
                    /* wallet amount save */
                    $wallet = [
                        'user_id'=>$user->id,
                        'order_id'=>-1,
                        'payment_id'=>$UserPayment->id,
                        'type'=>'credit',
                        'amount'=>$UserPayment->price,
                        'description'=> 'We have credit '.\Helpers::currency($UserPayment->price).' in your wallet.',
                        'created_at'=>date('Y-m-d H:i:s')
                    ];
                    $user_wallet = UserWallet::insertGetId($wallet);
                    return redirect('wallet')->with(['message'=>__('lang.admin_payment_done')]);
                }
                return redirect('wallet')->withError('Wallet not found.');
            }
        }else{
            $UserPayment= UserPayment::where('payment_refferance_id',$request->payment_request_id)->first();
            if(!empty($UserPayment)){
                $UserPayment->payment_transection_id=$request->payment_id;
                $UserPayment->payment_status=$request->status=='cancelled'?3:2;
                $UserPayment->save();
                $message=$UserPayment->payment_status==3 ? "Wallet payment has been cancelled.":"Wallet payment has been failed.";
                return redirect('wallet')->withError($message);
            }
            return redirect('wallet')->withError('Wallet not found.');
        }
    }
}

