<?php

namespace App\Http\Controllers\PaymentGateway;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Config;
use App\Models\AppSetting;
use Illuminate\Http\Request;
use App\Models\OrderProduct;
use App\Models\Order;
use App\Models\UserPayment;
use App\Models\UserWallet;
use Illuminate\Support\Facades\Auth;
use KingFlamez\Rave\Facades\Rave as Flutterwave;

class FlutterwaveController extends Controller
{
    public function __construct()
    {
        Config::set('flutterwave.publicKey', AppSetting::get_setting('rave_public_key'));
        Config::set('flutterwave.secretKey', AppSetting::get_setting('rave_secret_key'));
        Config::set('flutterwave.secretHash', AppSetting::get_setting('rave_encryption_key'));
    }
    /**
     * Initialize Rave payment process
     * @return void
     */
    public function payment($request,$orderId,$orderPostData,$user)
    {
        $order= Order::find($orderId);
        if(empty($order)){
            return redirect()->back()->withError('Order/Cart is empty.');
        }
        $reference = Flutterwave::generateReference();
        $order->payment_refferance_id=$reference;
        $order->save();
            // Enter the details of the payment
        $data = [
            'payment_options' => 'card,banktransfer',
            'amount' => $order->final_amount,
            'email' => request()->customer_email,
            'tx_ref' => $reference,
            'currency' =>AppSetting::get_setting('default_currency_code'),
            'redirect_url' => route('flutterwave.success'),
            'customer' => [
                'email' => request()->customer_email,
                "phone_number" => $user->phone,
                "name" => request()->customer_name
            ],
            "customizations" => [
                "title" => 'water App',
                "description" => "water product"
            ]
        ];
        $payment = Flutterwave::initializePayment($data);

        if ($payment) {
            if ($payment['status'] !== 'success') {
                return redirect()->back()->withError($payment['message']);
            }
            return redirect($payment['data']['link']);
        } else {
            return redirect()->back()->withErrors('Payment initialization failed: ' . ($payment['message'] ?? 'Unknown error'));
        }
    }
    /**
     * Obtain Rave success information
     * @return void
     */
    public function success(Request $request)
    {
        if(empty($request->tx_ref)){
            return redirect('orders')->withError('Unauthorized or Invalid Transaction');
        }elseif($request->status=='successful'){
            $transactionID = Flutterwave::getTransactionIDFromCallback();
            $data = Flutterwave::verifyTransaction($transactionID);
            if($data['status']=='success'){
                $order= Order::where('payment_refferance_id',$data['data']['tx_ref'])->first();
                $payment=UserPayment::where('id',$order->payment_id)->first();
                if(!empty($order)){
                    $order->payment_transection_id=$data['data']['id'];
                    $order->payment_transection_data= json_encode($data['data']);
                    $order->payment_status=1;
                    $order->save();
                    \Helpers::clearAuthUserCart();
                    if(!empty($payment)){
                        $payment->payment_refferance_id=$data['data']['tx_ref'];
                        $payment->payment_transection_id=$data['data']['id'];
                        $payment->payment_transection_data= json_encode($data['data']);
                        $payment->payment_status=1;
                        $payment->status='Paid';
                        $payment->save();
                    }
                    return redirect('orders')->with(['message'=>'Your payment has been done and order placed successfully.']);
                }
                return redirect('orders')->withError('Order not found.');
            }
        }else{
            $order= Order::where('payment_refferance_id',$request->tx_ref)->first();
            $payment=UserPayment::where('id',$order->payment_id)->first();
            if(!empty($order)){
                $order->payment_status=$request->status=='cancelled'?3:2;
                $order->save();
                if(!empty($payment)){
                    $payment->payment_status=$request->status=='cancelled'?3:2;
                    $payment->status='Failed';
                    $payment->save();
                }
                $message=$order->payment_status==3 ? "Order payment has been cancelled.":"Order payment has been failed.";
                return redirect('orders')->withError($message);

            }
            return redirect('orders')->withError('Order not found.');
        }
    }

    /* wallet */
    public function walletPayment($request)
    {
        //dd($request);
        $user_id = 0;
        if (Auth::check()) {
            $user= Auth::user();
        }
        $user_payment= UserPayment::find($request['paymentid']);
        if(empty($user_payment)){
            return redirect()->back()->withError('Wallet is empty.');
        }
        $reference = Flutterwave::generateReference();
        $user_payment->payment_refferance_id=$reference;
        $user_payment->method=$request['payment_method'];
        $user_payment->save();
            // Enter the details of the payment
        $data = [
            'payment_options' => 'card,banktransfer',
            'amount' => $user_payment->price,
            'email' => $user->email,
            'tx_ref' => $reference,
            'currency' =>AppSetting::get_setting('default_currency_code'),
            'redirect_url' => route('flutterwave-wallet.success'),
            'customer' => [
                'email' => $user->email,
                "phone_number" => $user->phone,
                "name" => $user->name
            ],
            "customizations" => [
                "title" => 'Wallet',
                "description" => "Wallet Payment via Flutterwave."
            ]
        ];
        $payment = Flutterwave::initializePayment($data);
        if($payment){
            if ($payment['status'] !== 'success') {
                return redirect('wallet')->with('error',$payment['message']);
            }
            return redirect($payment['data']['link']);
        }else{
            return redirect('wallet')->with('error','wallet payment not done due to server error.');
        }
    }

    /**
     * Obtain Rave success information
     * @return void
     */
    public function walletSuccess(Request $request){
        $user_id = 0;
        if (Auth::check()) {
            $user_id = Auth::user()->id;
        }
        if(empty($request->tx_ref)){
            return redirect('wallet')->withError('Unauthorized or Invalid Transaction');
        }elseif($request->status=='successful'){
            $transactionID = Flutterwave::getTransactionIDFromCallback();
            $data = Flutterwave::verifyTransaction($transactionID);
            if($data['status']=='success'){
                $UserPayment= UserPayment::where('payment_refferance_id',$data['data']['tx_ref'])->first();
                if(!empty($UserPayment)){
                    $UserPayment->payment_transection_id=$data['data']['id'];
                    $UserPayment->payment_transection_data= json_encode($data['data']);
                    $UserPayment->payment_status=1;
                    $UserPayment->save();
                    /* wallet amount save */
                    $wallet = [
                        'user_id'=>$user_id,
                        'order_id'=>-1,
                        'payment_id'=>$UserPayment->id,
                        'type'=>'credit',
                        'amount'=>$UserPayment->price,
                        'description'=> 'We have credit '.\Helpers::currency($UserPayment->price).' in your wallet.',
                        'created_at'=>date('Y-m-d H:i:s')
                    ];
                    $user_wallet = UserWallet::insertGetId($wallet);
                    return redirect('wallet')->with(['message'=>'Your wallet payment has been done.']);
                }
                return redirect('wallet')->with('error','Wallet not found.');
            }
        }else{
            $UserPayment= UserPayment::where('payment_refferance_id',$request->tx_ref)->first();
            if(!empty($UserPayment)){
                $UserPayment->payment_status=$request->status=='cancelled'?3:2;
                $UserPayment->save();
                $message=$UserPayment->payment_status==3 ? "Wallet payment has been cancelled.":"Wallet payment has been failed.";
                return redirect('wallet')->with('error',$message);
            }
            return redirect('wallet')->with('error','Wallet not found.');
        }
    }

}
