<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\UserPayment;
use App\Models\User;

class PaymentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = UserPayment::getLists();

        $filter = array();
        $filter['user'] = User::where('id','!=',1)->where('type','user')->get();

        // Add the new payment method to the filters
        $filter['payment_methods'] = ['cash','wallet','razorpay', 'paypal', 'stripe', 'paytm', 'phonepe', 'instamojo', 'flutterwave','paystack'];

        // Add the new payment status to the filters
        $filter['payment_statuses'] = ['Paid', 'Waiting for Client','Processing', 'Failed'];

        return view('payments.index',compact('data'))
            ->with('i', ($request->input('page', 1) - 1) * 5)->with('filter',$filter);;
    }
}
