<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\NonWorkingDays;
use Illuminate\Support\Facades\Session;

class NonWorkinDaysController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = NonWorkingDays::getLists();
        return view('non_working_days.index',compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = NonWorkingDays::getLists();
        $input = $request->all();
        if(isset($input['date_range']) && $input['date_range']!=''){
            $string = explode(' to ',$input['date_range']);

            $input['start_date'] = $string[0];
            $input['end_date'] = isset($string[1])?$string[1]:$string[0];
        }
        foreach ($data as $holiday){
            if(isset($input['start_date'])){
                for($x=0; $x < count($data); $x++){
                    if (($input['start_date'] >= $holiday->start_date) && ($input['end_date'] <= $holiday->end_date) || ($input['start_date'] <= $holiday->end_date) && ($input['end_date'] >= $holiday->start_date)) {
                        Session::flash('error', 'These dates already exist in holidays.');
                            return redirect()->back();
                        
                    }
                }
            }
        }
        NonWorkingDays::create($input);

        return redirect()->route('holidays.index')
                        ->with('success',__('lang.message_record_created_successfully'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $data = NonWorkingDays::find($id);
        $holidays = NonWorkingDays::getLists();
        if(isset($input['date_range']) && $input['date_range']!=''){
            $string = explode(' to ',$input['date_range']);

            $input['start_date'] = $string[0];
            $input['end_date'] = isset($string[1])?$string[1]:$string[0];
        }
        foreach ($holidays as $holiday){
            if(isset($input['start_date'])){
                for($x=0; $x < count($holidays); $x++){
                    if ((($input['start_date'] >= $holiday->start_date) && ($input['end_date'] <= $holiday->end_date) || ($input['start_date'] <= $holiday->end_date) && ($input['end_date'] >= $holiday->start_date)) && $holiday->id != $id) {
                        Session::flash('error', __('lang.message_selected_dates_already_exists'));
                        return redirect()->back();
                    }
                }
            }
        }
        $data->update($input);
        return redirect()->route('holidays.index')
                        ->with('success',__('lang.message_record_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        NonWorkingDays::find($id)->delete();
        return redirect()->route('holidays.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
    }
}
