<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use BeycanPress\EnvatoLicenseChecker;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\File;

class LicenseController extends Controller
{
    //
    public function index()
    {
        return view('license.verify');
    }

    public function verify(Request $request)
    {
        $client = new Client();
        $response = $client->request('GET', 'http://license.technofox.co.in/api/verify-code?code='.$request->purchase_code.'&item_id='.config('constant.item_id').'&base_url='.$request->base_url);
        $data = json_decode($response->getBody());
        if ($data->status==true) {
            // An error occurred
            File::put(base_path('.env'), str_replace(
                'CODE_VERIFIED=',
                'CODE_VERIFIED=true',
                file_get_contents(base_path('.env'))
            ));
            return redirect()->back()->with('success',"Code verified successfully.");
        } else {
            // return $data;
            return redirect()->back()->withInput($request->only('purchase_code'))->with('error', $data->message);
        }
    }
}
