<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Languages;
use App\Models\AllLanguages;
use App\Models\LanguagesKeywords;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Session;
use GuzzleHttp\Client;
use DB;

class LanguagesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = Languages::getLists();
        $languages = AllLanguages::all();
        return view('languages.index',compact('data','languages'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'language_name' => 'required',
            'language_code' => 'required|unique:languages,language_code',
            'language_direction' => 'required',
        ]);

        $input = $request->all();
        
        $is_default_lang = '0';

        if(isset($input['is_default'])){

            $is_default_lang = '1';

            $isCheck = Languages::where('is_default','1')->update(['is_default' => '0']);
        }

        $postData = array(
            'language_name' => $input['language_name'],
            'language_code' => $input['language_code'],
            'language_direction' => $input['language_direction'],
            'is_default' => $is_default_lang,
            'created_at' => date("Y-m-d H:i:s")
        );


        $language = Languages::create($postData);
        $fileName = 'lang.php';
        $path = resource_path('/lang/'.$input['language_code']); // Specify the path where you want to create the folder
        $filePath = $path . '/'.$fileName;
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
        if (!file_exists($filePath)) {
            file_put_contents($filePath, '<?php return [];');
        }
        $language = Languages::where('language_code',$input['language_code'])->first();
        if ($language) {
            $detail = "<?php
                return [
                    /*
                    |--------------------------------------------------------------------------
                    | Pagination Language Lines
                    |--------------------------------------------------------------------------
                    |
                    | The following language lines are used by the paginator library to build
                    | the simple pagination links. You are free to change them to anything
                    | you want to customize your views to better match your application.
                    |
                    */
            ";
            $default_language = Languages::where('is_default',1)->first();
            $translations = LanguagesKeywords::where('lang_code',$default_language->language_code)->get();
            foreach ($translations as $row) {
                $translationArr = array(
                    'lang_code'=>$language->language_code,
                    'group'=>$row->group,
                    'keyword'=>$row->keyword,   
                    'value'=>$row->value,
                    'created_at'=>date('Y-m-d H:i:s')
                );
                LanguagesKeywords::insert($translationArr);
                $row->value = str_replace("'", "",$row->value);
                $detail .= "'".$row->keyword."' => '".$row->value."',\n";
            }
            $detail .= "];";
                
            File::put($filePath, $detail);
        }
        return redirect()->route('languages.index')
                        ->with('success',__('lang.message_record_created_successfully'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();

        // Fetch the language record
        $language = Languages::findOrFail($id);

        // Handle default language logic
        $language->is_default = $request->has('is_default') ? '1' : '0';

        if ($language->is_default === '1') {
            // Reset all others
            Languages::where('is_default', '1')->where('id', '!=', $id)->update(['is_default' => '0']);
        }

        // Update other fields
        $language->language_name = $input['language_name'];
        $language->language_code = $input['language_code'];
        $language->language_direction = $input['language_direction'];
        $language->updated_at = now();

        $language->save();

        return redirect()->route('languages.index')->with('success', __('lang.message_record_updated_successfully'));
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $isCheck = Languages::where('id',$id)->first();

        if($isCheck->is_default == 1){
            return redirect()->route('languages.index')
                        ->with('success',__('lang.message_can_not_delete_default_record'));
        }else{
            Languages::find($id)->delete();
            return redirect()->route('languages.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
        }

        
    }

    public function changeStatus($id){
        $data = Languages::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        return redirect()->route('languages.index')
                        ->with('success',__('lang.message_status_updated_successfully'));
    }
}
