<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\LanguagesKeywords;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\File;

class GenralUpdateController extends Controller
{
    public function updateLanguageFiles()
    {
        try {
            $languages = Languages::where('status', 1)->get();

            foreach ($languages as $lang) {
                $translations = LanguagesKeywords::whereIn('group', ['web', 'admin'])
                    ->where('lang_code', $lang->language_code)
                    ->get();

                $data = "<?php\nreturn [\n";

                foreach ($translations as $row) {
                    $row->value = str_replace("'", "", $row->value);
                    $data .= "    '" . $row->keyword . "' => '" . $row->value . "',\n";
                }

                $data .= "];";

                $fileName = 'lang.php';
                $path = resource_path("lang/{$lang->language_code}");
                $filePath = $path . '/' . $fileName;

                if (!File::exists($path)) {
                    File::makeDirectory($path, 0755, true);
                }
                File::put($filePath, $data);
            }

            // Return success response
            return response()->json(['success' => true, 'message' => 'Language files updated successfully!']);
        } catch (\Exception $e) {
            // Return failure response
            return response()->json(['success' => false, 'message' => 'Failed to update language files.']);
        }
    }
}
