<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Driver;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\Rule;

class DriverController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = User::getLists('driver');

        $filter = array();
        // Add the new status to the filters
        $filter['status'] = \Helpers::getStatusType();
        return view('drivers.index',compact('data'))->with('filter',$filter);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        request()->validate([
            'email' => 'unique:users',
            'phone' => 'unique:users|numeric|digits:10',
            'password' => 'required|min:8',
        ]);

        $input = $request->all();

            $input['password'] = Hash::make($input['password']);
            if ($image = $request->file('image')) {
                $destinationPath = public_path('app-assets/images/drivers/');
                $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $input['image'] = "$profileImage";
            }
            $driver = User::create($input);
            $driverData = array(
                'user_id'=>$driver->id,
            );    
            return redirect()->route('drivers.index')->with('success',__('lang.message_record_created_successfully'));
        }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $driver = User::find($id);    
        return view('drivers.edit',compact('driver'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $validatedData = $request->validate([
            'email' => [
            'required',
            // Rule::unique('users')->ignore($id),
            ],
            'phone' => [
            'required',
            // 'numeric',
            // 'digits:10',
            // Rule::unique('users')->ignore($id),
            ],
            'name' => 'required',
        ]);

        $input = $request->all();
        if (empty($input['password'])) {
            unset($input['password']);
        } else {
            $input['password'] = Hash::make($input['password']);
        }

        $driver = User::find($id);
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/drivers/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }else{
            unset($input['image']);
        }
        $driver->update($input);
        return redirect()->route('drivers.index')->with('success',__('lang.message_record_updated_successfully'));

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::find($id)->delete();
        return redirect()->route('drivers.index')
                        ->with('success', __('lang.message_record_deleted_successfully'));
    }

    public function changeStatus($id){
        $data = User::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        return redirect()->route('drivers.index')
                        ->with('success',__('lang.message_status_updated_successfully'));
    }
}
