<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\DeliveryAreas;
use Illuminate\Support\Facades\Session;

class DeliveryAreasController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = DeliveryAreas::getLists();
        $filter = array();
        $filter['status'] = \Helpers::getStatusType();
        return view('delivery_areas.index',compact('data'))->with('filter',$filter);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        DeliveryAreas::create($input);
        Session::flash('success', 'Created successfully!');
        return redirect()->route('delivery_areas.index')
                        ->with('success','Created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = DeliveryAreas::find($id);    
        return view('delivery_areas.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $data = DeliveryAreas::find($id);
        $data->update($input);
        Session::flash('success', 'Updated successfully!');
        return redirect()->route('delivery_areas.index')
                        ->with('success','Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        DeliveryAreas::find($id)->delete();
        Session::flash('success', 'Deleted successfully!');
        return redirect()->route('delivery_areas.index')
                        ->with('success','Deleted successfully');
    }

    public function changeStatus($id){
        $data = DeliveryAreas::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        Session::flash('success', 'Status change successfully!');
        return redirect()->route('delivery_areas.index')
                        ->with('success','Status change successfully');
    }
}
