<?php

namespace App\Http\Controllers\DeliveryArea;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\State;
use App\Models\DeliveryAddresses;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\Rule;

class StateController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = State::getLists();
        $filter = array();
        $filter['status'] = \Helpers::getStatusType();
        return view('delivery_areas.state.index',compact('data'))->with('filter',$filter);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the request
        $request->validate([
            'state_name' => 'required|unique:states,state_name|max:255',
        ]);
    
        // Get all inputs and create the state
        $input = $request->all();
        State::create($input);
    
        // Set success message and redirect
        return redirect()->route('state.index')
                        ->with('success', __('lang.message_record_created_successfully'));
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
      //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request)
    {
        $id = $request->id;
    
        // Validate the request
        $request->validate([
            'state_name' => [
                'required',
                'max:255',
                Rule::unique('states', 'state_name')->ignore($id),
            ],
        ]);
    
        // Find the state and update it
        $data = State::findOrFail($id);
    
        // Update DeliveryAddresses associated with this state
        $deliveryAddresses = DeliveryAddresses::where('state', $data->state_name)->get();
        foreach ($deliveryAddresses as $row) {
            $row->update(['state' => $request->state_name]);
        }
    
        // Update the state name
        $data->update(['state_name' => $request->state_name]);
    
        // Set success message and redirect
        return redirect()->route('state.index')
                        ->with('success', __('lang.message_record_updated_successfully'));
    }

    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        State::find($id)->delete();
        return redirect()->route('state.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
    }
    
    
    /**
     * Update the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus($id){
        $data = State::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        return redirect()->route('state.index')
                        ->with('success',__('lang.message_status_updated_successfully'));
    }
}