<?php

namespace App\Http\Controllers\DeliveryArea;
use App\Http\Controllers\Controller;
use anlutro\LaravelSettings\Facade as Setting;
use Illuminate\Http\Request;
use App\Models\DeliveryAreas;
use App\Models\State;
use App\Models\City;
use Illuminate\Support\Facades\Session;

class DeliveryAreasController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = DeliveryAreas::getLists();
        $state = State::where('status',1)->get();
        $city = City::where('status',1)->get();
        $filter = array();
        $filter['status'] = \Helpers::getStatusType();
        $filter['state'] = State::where('status',1)->get();
        $filter['city'] = City::where('status',1)->get();
        return view('delivery_areas.index',compact('data','state','city'))->with('filter',$filter);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        DeliveryAreas::create($input);
        return redirect()->route('delivery_areas.index')
                        ->with('success', __('lang.message_record_created_successfully'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = DeliveryAreas::find($id);   
        $state = State::where('status',1)->get();
        $city = City::where('status',1)->get();
        return view('delivery_areas.edit',compact('data','state','city'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $data = DeliveryAreas::find($id);
        $data->update($input);
        return redirect()->route('delivery_areas.index')
                        ->with('success', __('lang.message_record_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        DeliveryAreas::find($id)->delete();
        return redirect()->route('delivery_areas.index')
                        ->with('success', __('lang.message_record_deleted_successfully'));
    }

    public function changeStatus($id){
        $data = DeliveryAreas::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        return redirect()->route('delivery_areas.index')
                        ->with('success', __('lang.message_status_updated_successfully'));
    }
    
    
    /**
     * get city.
     *
     * @param  Request  $request
     * @return \Illuminate\Http\Response
    **/
    public function getCityByStateId(Request $request)
    {
        $post = $request->all();
        $city = City::where('state_id',$post['state_id'])->get();
        $sendArr = array(
            'city' => $city,
        );
        
        if(isset($post['city_id']) && $post['city_id'] !=''){
            $sendArr['city_id'] = $post['city_id']; 
        }

        $data['html'] = view('delivery_areas.get_city')->with($sendArr)->render();
        $response = [
            'status' => true,
            'message' => __('lang.message_data_fetched_successfully'),
            'data' => $data
        ];
        return response($response);
    }
    
}