<?php

namespace App\Http\Controllers\DeliveryArea;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\State;
use App\Models\City;
use App\Models\DeliveryAddresses;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\Rule;

class CityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = City::getLists();
        $state = State::where('status',1)->get();
        $filter = array();
        $filter['status'] = \Helpers::getStatusType();
        $filter['state'] = State::where('status',1)->get();
        return view('delivery_areas.city.index',compact('data','state'))->with('filter',$filter);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // Validate the request
        $request->validate([
            'city_name' => 'required|unique:cities,city_name|max:255',
        ]);
    
        // Get all inputs and create the state
        $input = $request->all();
        City::create($input);
    
        // Set success message and redirect
        return redirect()->route('city.index')
                        ->with('success', __('lang.message_record_created_successfully'));
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
      //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request)
    {
        $id = $request->id;
    
        // Validate the request
        $request->validate([
            'city_name' => [
                'required',
                'max:255',
                Rule::unique('cities', 'city_name')->ignore($id),
            ],
        ]);
    
        // Find the city and update it
        $data = City::findOrFail($id);
    
        // Optionally, if you need to update related DeliveryAddresses (if applicable)
        $deliveryAddresses = DeliveryAddresses::where('city', $data->city_name)->get();
        foreach ($deliveryAddresses as $row) {
            $row->update(['city' => $request->city_name]);
        }
        
        $data->update([
            'city_name' => $request->city_name,
            'state_id' => $request->state_id,
        ]);
    
        // Set success message and redirect
        return redirect()->route('city.index')
                        ->with('success', __('lang.message_record_updated_successfully'));
    }

    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        City::find($id)->delete();
        return redirect()->route('city.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
    }
    
    
    /**
     * Update the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changeStatus($id){
        $data = City::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        return redirect()->route('city.index')
                        ->with('success',__('lang.message_status_updated_successful'));
    }
}