<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\OrderProduct;
use App\Models\OrderProductsDelivery;
use App\Models\Order;
use App\Models\LanguagesKeywords;
use Illuminate\Support\Facades\DB;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $post = $request->all();
        $response = array();
        $tommorowDate = date("Y-m-d",strtotime("+1 day"));
        $response['sales'] = Order::sum('final_amount');
        $response['customers'] = User::where('type','user')->count();
        $response['pending_orders'] = OrderProductsDelivery::where('delivery_date',$tommorowDate)->where('order_status_id',1)->count();
        $response['pending_orders_date'] = $tommorowDate;
        $response['active_subscription'] = OrderProduct::where('end_date',">=",date("Y-m-d"))->where('order_frequency','!=','once')->count();

        $response['date_range'] = array();
        $response['order_count'] = array();
        $response['user_count'] = array();
        
        if(isset($post['date_range'])){
            $date = explode("to",$post['date_range']);
            $response['chart_start_date'] = (isset($date[0]))?date("Y-m-d",strtotime(trim($date[0]))):date("Y-m-01");
            $response['chart_end_date'] = (isset($date[1]))?date("Y-m-d",strtotime(trim($date[1]))):date("Y-m-01");
        }else{
            $response['chart_start_date'] = date("Y-m-01");
            $response['chart_end_date']  = date("Y-m-d");
        }

        $i = 0;
        $currentDate = $response['chart_start_date'];
        $endDate = $response['chart_end_date'] ;

        while($currentDate<$endDate){
            array_push($response['date_range'], date('Y-m-d', strtotime('+' . $i . ' day', strtotime($response['chart_start_date']))));
            $currentDate = date('Y-m-d', strtotime('+' . $i . ' day', strtotime($response['chart_start_date'])));
            $i++;
        }
        foreach ($response['date_range'] as $date) {
            $orderCount = Order::whereDate('created_at', $date)->count();
            array_push($response['order_count'],$orderCount);
            $userCount = User::where('type','user')->whereDate('created_at', $date)->count();
            array_push($response['user_count'],$userCount);
        }

        $latestOrder = Order::getLatest();

        return view('dashboard.index')->with('response',$response)->with('data',$latestOrder);
    }

    public function check_keywords(Request $request)
    {
        $ids = array();
        $keywords = array();
        $keywordsLang = LanguagesKeywords::where('lang_code','en')->get();
        if(count($keywordsLang)){
            foreach($keywordsLang as $keywordsLang_data){
                if(!in_array($keywordsLang_data->keyword,$keywords)){
                    array_push($keywords,$keywordsLang_data->keyword);
                    array_push($ids,$keywordsLang_data->id);
                }
            }
        }
        for($i=0;$i<count($ids);$i++){
            LanguagesKeywords::where('keyword',$keywords[$i])->where('id','!=',$ids[$i])->delete();
        }
        return "Deleted Successfully";
    }
}