<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Currencies;
use App\Models\AppSetting;
use Illuminate\Support\Facades\Session;

class CurrencyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = Currencies::orderBy('id','DESC')->get();
        return view('currencies.index',compact('data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();

        $is_default_currency = '0';
        $status = '0';
        if(isset($input['is_default'])){

            $is_default_currency = '1';
            $status = '1';

            $isCheck = Currencies::where('is_default','1')->where('status','1')->update(['is_default' => '0','status' => '0']);
        }


        $input['is_default'] = $is_default_currency;
        $input['status'] = $status;

        Currencies::create($input);
        $check_default = Currencies::where('is_default',1)->first();
        if($check_default){
            Setting::set('default_currency_code', $check_default->code);
            Setting::set('default_currency_decimal_digits', $check_default->decimal_digits);
            Setting::set('default_currency_rounding', $check_default->rounding);
            Setting::set('default_currency', $check_default->symbol);

            AppSetting::where('key','default_currency_code')->update(array('value'=>$check_default->code,'updated_at' => date("y-m-d H:i:s")));
            AppSetting::where('key','default_currency_decimal_digits')->update(array('value'=>$check_default->decimal_digits,'updated_at' => date("y-m-d H:i:s")));
            AppSetting::where('key','default_currency_rounding')->update(array('value'=>$check_default->rounding,'updated_at' => date("y-m-d H:i:s")));
            AppSetting::where('key','default_currency')->update(array('value'=>$check_default->symbol,'updated_at' => date("y-m-d H:i:s")));
            Setting::save();
        }
        
        return redirect()->route('currencies.index')
                        ->with('success',__('lang.message_record_created_successfully'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Currencies::find($id);
    
        return view('currencies.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
            $input = $request->all();
            $currencies = Currencies::find($id);

            $is_default_currency = '0';
            $status = '0';
            if(isset($input['is_default'])){

                $is_default_currency = '1';
                $status = '1';
                $isCheck = Currencies::where('is_default','1')->where('status','1')->update(['is_default' => '0','status' => '0']);

            }
            $update = Currencies::where('id',$id)->first();
            $update->is_default = $is_default_currency;
            $update->status = $status;
            $update->update();

            $currencies->update($input);
            $check_default = Currencies::where('is_default','1')->first();
            if($check_default){
                Setting::set('default_currency_code', $check_default->code);
                Setting::set('default_currency_decimal_digits', $check_default->decimal_digits);
                Setting::set('default_currency_rounding', $check_default->rounding);
                Setting::set('default_currency', $check_default->symbol);

                AppSetting::where('key','default_currency_code')->update(array('value'=>$check_default->code,'updated_at' => date("y-m-d H:i:s")));
                AppSetting::where('key','default_currency_decimal_digits')->update(array('value'=>$check_default->decimal_digits,'updated_at' => date("y-m-d H:i:s")));
                AppSetting::where('key','default_currency_rounding')->update(array('value'=>$check_default->rounding,'updated_at' => date("y-m-d H:i:s")));
                AppSetting::where('key','default_currency')->update(array('value'=>$check_default->symbol,'updated_at' => date("y-m-d H:i:s")));
                Setting::save();
            }
            return redirect()->route('currencies.index')
                            ->with('success',__('lang.message_record_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $isCheck = Currencies::where('id',$id)->first();

        if($isCheck->is_default == 1){
            return redirect()->route('currencies.index')
                        ->with('success',__('lang.message_can_not_delete_default_record'));
        }else{
            Currencies::find($id)->delete();
            return redirect()->route('currencies.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
        }

    }

    public function changeStatus($id){

        // New one
        $data = Currencies::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        
        Setting::set('default_currency_code', $data->code);
        Setting::set('default_currency_decimal_digits', $data->decimal_digits);
        Setting::set('default_currency_rounding', $data->rounding);
        Setting::set('default_currency', $data->symbol);

        AppSetting::where('key','default_currency_code')->update(array('value'=>$data->code,'updated_at' => date("y-m-d H:i:s")));
        AppSetting::where('key','default_currency_decimal_digits')->update(array('value'=>$data->decimal_digits,'updated_at' => date("y-m-d H:i:s")));
        AppSetting::where('key','default_currency_rounding')->update(array('value'=>$data->rounding,'updated_at' => date("y-m-d H:i:s")));
        AppSetting::where('key','default_currency')->update(array('value'=>$data->symbol,'updated_at' => date("y-m-d H:i:s")));
        Setting::save();

        return redirect()->route('currencies.index')
                        ->with('success',__('lang.message_status_updated_successfully'));
    }
}
