<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Coupon;
use App\Models\CouponTranslation;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;

class CouponController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // Deactivate expired coupons
        Coupon::where('end_date', '<', date('Y-m-d'))
            ->where('status', 1)
            ->update(['status' => 0]);

        // Fetch the filtered list of coupons
        $coupons = Coupon::getLists($request->all());
        
        $filter = array();
        $filter['status'] = \Helpers::getStatusType();
        $filter['type'] =  \Helpers::getCouponType();

        return view('coupons.index', compact('coupons'))->with('filter', $filter);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $dates = explode("to",$input['start_date']);
        $input['start_date'] = date("Y-m-d",strtotime(trim($dates[0])));
        if(isset($dates[1])){
            $input['end_date'] = date("Y-m-d",strtotime(trim($dates[1])));
        }else{
            $input['end_date'] = date("Y-m-d",strtotime(trim($dates[0])));
        }
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/coupons/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }
        Coupon::create($input);
        return redirect()->route('coupons.index')
                        ->with('success',__('lang.message_record_created_successfully'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $coupon = Coupon::find($id);    
        return view('coupons.edit',compact('coupon'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $dates = explode("to",$input['start_date']);
        $input['start_date'] = date("Y-m-d",strtotime(trim($dates[0])));
        if(isset($dates[1])){
            $input['end_date'] = date("Y-m-d",strtotime(trim($dates[1])));
        }else{
            $input['end_date'] = date("Y-m-d",strtotime(trim($dates[0])));
        }
        $coupon = Coupon::find($id);
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/coupons/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }else{
            unset($input['image']);
        }
        $coupon->update($input);
        return redirect()->route('coupons.index')
                        ->with('success',__('lang.message_record_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Coupon::find($id)->delete();
        return redirect()->route('coupons.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
    }

    public function translation($id)
    {
        $coupon = Coupon::find($id);
        $languages = Languages::where('status',1)->get();
        foreach ($languages as $row) {
            $row->details = CouponTranslation::where('coupon_id',$id)->where('lang_code',$row->language_code)->first();
            if(!$row->details){
                $postData = array(
                    'coupon_id' => $id,
                    'lang_code' => $row->language_code,
                    'coupon_name' => $coupon->coupon_name,
                    'description' => $coupon->description,
                    'created_at' => date("Y-m-d H:i:s")
                );
                CouponTranslation::insert($postData);
                $row->details = CouponTranslation::where('coupon_id',$id)->where('lang_code',$row->language_code)->first();
            }
        }
        return view('coupons.translation',compact('coupon'))->with('languages',$languages);
    }

    public function updateTranslation($id,Request $request)
    {
        $post = $request->all();

        request()->validate([
            'language_code' => 'required',
            'coupon_name' => 'required',
            'description' => 'required',
        ]);
        $input = $request->all();

        for ($i=0; $i < count($input['language_code']); $i++) { 
            if($input['language_code'][$i] == 'en'){
                $updateData = array(
                    'coupon_name'  => $input['coupon_name'][$i],
                    'description'  => $input['description'][$i]
                );
                Coupon::where('id',$id)->update($updateData);
            }

            $postData = array(
                'lang_code' => $input['language_code'][$i],
                'coupon_name' => $input['coupon_name'][$i],
                'description' => $input['description'][$i],
                'updated_at' => date("Y-m-d H:i:s")
            );
            CouponTranslation::where('id',$input['translation_id'][$i])->update($postData);
        }
        
        return redirect()->route('coupons.index')
                        ->with('success',__('lang.message_translation_updated_successfully'));
    }

    public function changeStatus($id){
        $data = Coupon::find($id);
        if($data->status == 1){
            $data->update(['status' => 0]);
        }else{
            $data->update(['status' => 1]);
        }
        return redirect()->route('coupons.index')
                        ->with('success', __('lang.message_record_updated_successfully'));
    }
}
