<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Contactus;
use App\Models\User;
use Illuminate\Support\Facades\Mail;

class ContactUsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Contactus::getLists();

        $filter = array();
        // Add the new status to the filters
        $filter['status'] = [__('lang.status_replied'), __('lang.status_notreplied')];
        return view('contact_us.index',compact('data'))->with('filter',$filter);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();

        $email = $input['email'];

        $subject = __('lang.message_reply_to_your_contact_form_inquiry');

        $emailData = array(
            'app_name'=>"Website",
            'username'=> $input['name'],
            'mail_signature'=> "Support Team",
            'reply_text'=> $input['message'],
            "logo" => url('/app-assets/images/logo.png')
        );

        try {
            \Mail::send('email.contact-reply', $emailData, function($message) use ($email, $subject) {
                $message->to($email)->subject($subject);
            });
        } catch (\Exception $e) {
            dd($e->getMessage());
        }


        $status_update = array(
            'is_replied' => 1
        );
        Contactus::where('id',$input['contact_id'])->update($status_update);
        return redirect()->route('contact_us.index')
                        ->with('success',__('lang.message_reply_send_successfully'));
    }
}
