<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Prettus\Validator\Exceptions\ValidatorException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Models\Role as Roles;
use Spatie\Permission\Models\Permission;
use App\Models\Permission as PermissionModel;
use App\Models\Role as RoleModel;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function getLoginView(Request $request)
    {
        return view('auth.login');
    }


    /**
     * Log the user out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function logout(Request $request)
    {
        $this->guard()->logout();

        $request->session()->invalidate();

        return $this->loggedOut($request) ?: redirect('/admin-login');
    }

      /**
     * Handle an authentication attempt.
     *
     * @param  \Illuminate\Http\Request $request
     *
     * @return Response
     */
    public function authenticate(Request $request)
    {   
        $post = $request->all();
        $credentials = [
            'email' => $post['login-email'],
            'password' => $post['login-password'],
        ];
        if (Auth::validate($credentials)){
            if (Auth::attempt($credentials)) {
              //echo json_encode(Auth::user());exit;
                if(Auth::user()->type == 'admin'){
                  	//echo json_encode("admin");exit;
                    Auth::loginUsingId(Auth::user()->id);
                    return redirect()->intended('admin/dashboard')->with('message','You have successfully logged in. Now you can start to explore!','👋 Welcome Admin!');
                }else if(Auth::user()->type == 'subadmin'){
                  	//echo json_encode("subadmin");exit;
                    Auth::loginUsingId(Auth::user()->id);
                    return redirect()->intended('admin/dashboard')->with('message','You have successfully logged in. Now you can start to explore!','👋 Welcome Subadmin!');
                }else{
                  	//echo json_encode("type else");exit;
                    Session::flash('error', "Invalid email and password."); 
                    return redirect()->to('admin-login')->with('error', "Invalid email and password.");
                }
            }else{
              	//echo json_encode("attempt else");exit;
                Session::flash('error', "Invalid email and password."); 
                return redirect()->to('admin-login')->with('error', "Invalid email and password.");
            }
        }else{
          	//echo json_encode("validate else");exit;
            Session::flash('error', "Invalid email and password."); 
            return redirect()->to('admin-login')->with('error', "Invalid email and password.");
        }
    }
}
