<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Session;
use App\Helpers\Helpers;
use App\Mail\CustomMail;
use Illuminate\Support\Facades\Mail;
use Swift_TransportException;
use Illuminate\Support\Facades\Log;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    
    /**
    * admin forgot password email view
    **/
    public function forgetPassword()
    {
      return view('auth.passwords.email');
    }


    /**
    * admin forgot password view and email verification
    **/
 public function emailVerificationForPassword(Request $request)
{
    $post = $request->all();

    // Validate email presence and format
    $request->validate([
        'email' => 'required|email',
    ]);

    $user = User::where('email', $post['email'])->where('type', 'admin')->first();

    if ($user) {
        if (isset($post['submit'])) {
            $otp = rand(1000, 9999);

            // Send email only if the email is valid
            if (!empty($post['email'])) {
                try {
                    // Send email
                    $data = array();
                    $data['otp'] = $otp;    
                    $data['name'] = $user->name;
                    $data['text'] = "Here is a one-time verification code for your use: ".$otp;
                    //Todo Email
                    $c = \Helpers::sendEmail('email.forgot-password',$data,$user->email,$user->name, setting('site_title'). ' forgot password '.$data['otp'], setting('site_title'),'8210jp@gmail.com','');
                    
                    User::where('id',$user->id)->update(['otp'=>$otp]);
                    // $msgData = "<p> Name: $user->name </p>
                    //     <p>Here is a one-time verification code for your use: " . $otp . "</p>";

                    // // This line may throw an exception on failure
                    // Mail::to($post['email'])->send(new CustomMail($msgData));

                    // If execution reaches here, the email was sent successfully
                    User::where('id', $user->id)->update(['otp' => $otp]);

                    Session::flash('success', "Otp sent successfully!");
                    return view('auth.passwords.verification')->with('success', 'Otp sent successfully!');
                } catch (Swift_TransportException $e) {
                    // Log the exception message for debugging
                    Log::error("SMTP Authentication Error: " . $e->getMessage());

                    // Redirect with a general error message
                    return redirect()->to('admin-forget-password')->with('error', 'SMTP authentication failed. Please check your SMTP account details.');
                } catch (\Exception $e) {
                    // Handle other exceptions here if needed
                    Log::error("Email Sending Error: " . $e->getMessage());

                    // Redirect with a general error message
                    return redirect()->to('admin-forget-password')->with('error', 'Email sending failed. Please try again later.');
                }
            }
        }

        Session::flash('success', "Otp sent successfully!");
        return view('auth.passwords.verification')->with('success', 'Otp sent successfully!');
    } else {
        return redirect()->to('admin-forget-password')->with('error', 'Invalid email');
    }
}


    /**
    * admin forgot password reset
    **/
    public function resetPasswordPost(Request $request)
    {
        $post = $request->all();
         
        if ($post['password'] == $post['confirm-password']){

          $isCheck = User::where('email',$post['email'])->where('type','admin')->first();

            if ($isCheck){

            if($post['otp'] == $isCheck->otp){

               $isCheck->password = Hash::make($post['password']);
               $isCheck->update();
               return redirect()->to('admin-login')->with('success', "Password change successfully");

            }else{
            return redirect()->back()->with('error', 'Invalid OTP!');
            }

            }else{
                return redirect()->to('admin-forget-password')->with('error', "Invalid Url");
            }


        }else{

            return redirect()->back()->with('error', 'Password and Confirm is not same!');
        }
    }



}
