<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;
use anlutro\LaravelSettings\Facade as ContentSetting;
use Illuminate\Support\Facades\Validator;
use App\Models\AppSetting;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class AppSettingController extends Controller
{

    public function setLanguage(Request $request){
        $post = $request->all();
        if (array_key_exists($post['lang'], Config::get('languages'))) {
            if (isset($post['lang'])) {
                $direction = \Helpers::getLangData($post['lang']);

                App::setLocale($post['lang']);
                Session::put('admin_locale', $post['lang']);
                Session::put('admin_direction', $direction);
                setcookie('admin_lang_code',$post['lang'],time()+60*60*24*365);
            }
        }
        return redirect()->back();
    }

    public function index($type = null, $tab = null)
    {
        if (empty($type)) {
            Flash::error(trans('lang.app_setting_global') . 'not found');
            return redirect()->back();
        }
        if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_stripe'))){
            AppSetting::where('key','enable_stripe')->update(['value'=>0]);
            Setting::set('enable_stripe', 0);
            Setting::save();
        }
        if(!in_array(setting('default_currency_code'),config('constant.supported_currencies_paypal'))){
            AppSetting::where('key','enable_paypal')->update(['value'=>0]);
            Setting::set('enable_paypal', 0);
            Setting::save();
        }

        $fileData = storage_path('data/countryData.json');
        $jsonContent = File::get($fileData);
        $countriesData = json_decode($jsonContent, true);
        if ($countriesData == null) {
            $countriesData=[];
        }else{
            $countriesData=$countriesData['countries'];
        }
        $appSetting  = AppSetting::get();
        $countryKey= -1;
        $requireSetting=  Config::get('app.requireSetting');
        $haveValueSetting=[];
        foreach($appSetting as $key => $setting){
            if($setting->key=='countryCodes'){
                $setting->value =json_decode($setting->value, true);
                $appSetting[$key] = $setting;
                $countryKey=$key;
                array_push($haveValueSetting, $setting->key);
            }elseif(in_array($setting->key, $requireSetting)){
                array_push($haveValueSetting, $setting->key);
            }
        }
        //default value to require setting
        foreach($requireSetting as $set){
            if(!in_array($set, $haveValueSetting)){
                $newSetting = new AppSetting;
                $newSetting->value='';
                if($set=='enable_test_mode'){
                    $newSetting->value=1;
                }elseif($set=='is_enable_mail_order_receive'){
                    $newSetting->value=0;
                }
                $newSetting->key=$set;
                $appSetting->push($newSetting);
            }
        }
        return view('settings.' . $type . '.' . $tab . '')->with(['data'=>$appSetting, 'countries'=>$countriesData, 'country_key'=>$countryKey]);
    }

    public function updateSetting(Request $request)
    {
        $post = $request->all();
        $obj = new AppSetting();
        $data = $request->all();
        $paymentGatewayKey = [];
        $startFormatKeys = [];

        $page_name = (isset($post['page_name']))?$post['page_name']:'';
        if($page_name!=''){
            $myAr = array();
            if($page_name=='non-working-days')
            {
                $myAr = array("mon_working","tue_working","wed_working","thu_working","fri_working","sat_working","sun_working");
            }
            else if($page_name=='payment')
            {
                $paymentGatewayKey = [
                    "enable_wallet", "enable_oppwa", "enable_cod", "enable_razorpay", 'razorpay_key', 'razorpay_secret',
                    'enable_stripe', 'stripe_key', 'stripe_secret_key', 'enable_paypal', 'paypal_client_id', 'paypal_secret_key',
                    'enable_paytm', 'paytm_merchant_id', 'paytm_merchant_key', 'paytm_merchant_website', 'paytm_channel', 
                    'paytm_industry_type', 'enable_phonepe', 'phonepe_merchant_id', 'phonepe_salt_key', 'enable_instamojo',
                    'instamojo_api_key', 'instamojo_auth_token', 'instamojo_api_endpoint', 'enable_flutterwave', 'rave_public_key',
                    'rave_secret_key', 'rave_encryption_key', 'enable_paystack', 'paystack_public_key', 'paystack_secret_key',
                    'paystack_merchant_email', 'enable_liqpay', 'liqpay_public_key', 'liqpay_private_key'
                ];

                foreach ($paymentGatewayKey as $key) {
                    if (strpos($key, 'enable_') === 0) {
                        // Handle all 'enable_*' keys dynamically
                        $data[$key] = isset($data[$key]) ? ($data[$key] == 'on' ? 1 : $data[$key]) : 0;
                        continue;
                    }

                    $appSettingData = AppSetting::where('key', $key)->first();
                    $existingValue = $appSettingData->value ?? null;

                    if (isset($data[$key]) && substr($existingValue, -5) == substr($data[$key], -5)) {
                        $data[$key] = $existingValue;
                    }
                }

            }
            else if($page_name=='notifications')
            {
                $myAr = array("is_enable_one_signal","is_enable_firebase_notification");


                $appSettingData = AppSetting::where('key', 'one_signal_key')->first();
                $one_signal_key = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($one_signal_key, -5) == substr($data['one_signal_key'], -5)) {
                    $data['one_signal_key'] = $one_signal_key;
                }

                $appSettingData = AppSetting::where('key', 'one_signal_app_id')->first();
                $one_signal_app_id = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($one_signal_app_id, -5) == substr($data['one_signal_app_id'], -5)) {
                    $data['one_signal_app_id'] = $one_signal_app_id;
                }
                
                
                $appSettingData = AppSetting::where('key', 'firebase_project_id')->first();
                $firebase_project_id = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($firebase_project_id, -5) == substr($data['firebase_project_id'], -5)) {
                    $data['firebase_project_id'] = $firebase_project_id;
                }
                
                
                if(!empty($request->file('firebase_json_file'))) {
                    $this->save_firebase_setting($request);
                }

            }elseif($page_name=='sms_setting'){

                $data_test_mode_setting = @$post['enable_test_mode'] ? @$post['enable_test_mode'] : 0 ;
                $data_firebase_setting = @$post['is_enable_firebase'] ? @$post['is_enable_firebase'] : 0 ;
                $data_twilio_setting = @$post['is_enable_twilio'] ? @$post['is_enable_twilio'] : 0 ;
                $data_firebase_message_setting = @$post['enable_firebase_message'] ? @$post['enable_firebase_message'] : 0 ;
                $data_firebase_notification_setting = @$post['is_enable_firebase_notification'] ? @$post['is_enable_firebase_notification'] : 0 ;
                $is_enabled_fast_2_sms = @$post['is_enabled_fast_2_sms'] ? @$post['is_enabled_fast_2_sms'] : 0 ;
                $is_enabled_2_factor = @$post['is_enabled_2_factor'] ? @$post['is_enabled_2_factor'] : 0 ;

                AppSetting::where(['key'=>'is_enable_firebase_notification'])->update(['value'=> $data_firebase_notification_setting]);
                
                // Determine the settings based on conditions
                if ($data_firebase_setting) {
                    // Firebase is enabled: Disable Test Mode and Twilio
                    AppSetting::where(['key' => 'is_enabled_2_factor'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enabled_fast_2_sms'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'enable_test_mode'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enable_firebase'])->update(['value' => 1]);
                    AppSetting::where(['key' => 'enable_firebase_message'])->update(['value' => @$post['enable_firebase_message'] ? @$post['enable_firebase_message'] : 1]);
                    AppSetting::where(['key' => 'is_enable_firebase_notification'])->update(['value' => @$post['is_enable_firebase_notification'] ? @$post['is_enable_firebase_notification'] : 0]);
                    AppSetting::where(['key' => 'is_enable_twilio'])->update(['value' => 0]);

                } elseif ($data_twilio_setting) {
                    
                    AppSetting::where(['key' => 'is_enabled_2_factor'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enabled_fast_2_sms'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'enable_test_mode'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enable_firebase'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'enable_firebase_message'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enable_twilio'])->update(['value' => 1]);
                } elseif ($is_enabled_fast_2_sms) {
                
                    AppSetting::where(['key' => 'is_enabled_fast_2_sms'])->update(['value' => 1]);
                    AppSetting::where(['key' => 'is_enabled_2_factor'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'enable_test_mode'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enable_firebase'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'enable_firebase_message'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enable_twilio'])->update(['value' => 0]);
                } elseif ($is_enabled_fast_2_sms) {
                
                    AppSetting::where(['key' => 'is_enabled_fast_2_sms'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enabled_2_factor'])->update(['value' => 1]);
                    AppSetting::where(['key' => 'enable_test_mode'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enable_firebase'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'enable_firebase_message'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enable_twilio'])->update(['value' => 0]);
                } else {

                    AppSetting::where(['key' => 'enable_test_mode'])->update(['value' => 1]);
                    AppSetting::where(['key' => 'is_enabled_2_factor'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enable_firebase'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'enable_firebase_message'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enable_twilio'])->update(['value' => 0]);
                    AppSetting::where(['key' => 'is_enabled_fast_2_sms'])->update(['value' => 0]);
                }

                
                $appSettingData = AppSetting::where('key', '2_factor_api_key')->first();
                $factor_2_api_key = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($factor_2_api_key, -5) == substr($data['2_factor_api_key'], -5)) {
                    $data['2_factor_api_key'] = $factor_2_api_key;
                }

                $appSettingData = AppSetting::where('key', 'fast_2_sms_sender_id')->first();
                $fast_2_sms_sender_id = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($fast_2_sms_sender_id, -5) == substr($data['fast_2_sms_sender_id'], -5)) {
                    $data['fast_2_sms_sender_id'] = $fast_2_sms_sender_id;
                }


                $appSettingData = AppSetting::where('key', 'fast_2_sms_api_key')->first();
                $fast_2_sms_api_key = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($fast_2_sms_api_key, -5) == substr($data['fast_2_sms_api_key'], -5)) {
                    $data['fast_2_sms_api_key'] = $fast_2_sms_api_key;
                }



                $appSettingData = AppSetting::where('key', 'twilio_account_sid')->first();
                $twilio_account_sid = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($twilio_account_sid, -5) == substr($data['twilio_account_sid'], -5)) {
                    $data['twilio_account_sid'] = $twilio_account_sid;
                }


                $appSettingData = AppSetting::where('key', 'twilio_auth_token')->first();
                $twilio_auth_token = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($twilio_auth_token, -5) == substr($data['twilio_auth_token'], -5)) {
                    $data['twilio_auth_token'] = $twilio_auth_token;
                }


                $appSettingData = AppSetting::where('key', 'twilio_phone_number')->first();
                $twilio_phone_number = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($twilio_phone_number, -5) == substr($data['twilio_phone_number'], -5)) {
                    $data['twilio_phone_number'] = $twilio_phone_number;
                }


                $appSettingData = AppSetting::where('key', 'firebase_api_key')->first();
                $firebase_api_key = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($firebase_api_key, -5) == substr($data['firebase_api_key'], -5)) {
                    $data['firebase_api_key'] = $firebase_api_key;
                }


                $appSettingData = AppSetting::where('key', 'firebase_auth_domain')->first();
                $firebase_auth_domain = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($firebase_auth_domain, -5) == substr($data['firebase_auth_domain'], -5)) {
                    $data['firebase_auth_domain'] = $firebase_auth_domain;
                }


                $appSettingData = AppSetting::where('key', 'firebase_storage_bucket')->first();
                $firebase_storage_bucket = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($firebase_storage_bucket, -5) == substr($data['firebase_storage_bucket'], -5)) {
                    $data['firebase_storage_bucket'] = $firebase_storage_bucket;
                }


                $appSettingData = AppSetting::where('key', 'firebase_messaging_sender_id')->first();
                $firebase_messaging_sender_id = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($firebase_messaging_sender_id, -5) == substr($data['firebase_messaging_sender_id'], -5)) {
                    $data['firebase_messaging_sender_id'] = $firebase_messaging_sender_id;
                }

        
                $appSettingData = AppSetting::where('key', 'firebase_app_id')->first();
                $firebase_app_id = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($firebase_app_id, -5) == substr($data['firebase_app_id'], -5)) {
                    $data['firebase_app_id'] = $firebase_app_id;
                }


                $appSettingData = AppSetting::where('key', 'firebase_messaging_vapid_publickey')->first();
                $firebase_messaging_vapid_publickey = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($firebase_messaging_vapid_publickey, -5) == substr($data['firebase_messaging_vapid_publickey'], -5)) {
                    $data['firebase_messaging_vapid_publickey'] = $firebase_messaging_vapid_publickey;
                }



                $appSettingData = AppSetting::where('key', 'firebase_measurement_id')->first();
                $firebase_measurement_id = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($firebase_measurement_id, -5) == substr($data['firebase_measurement_id'], -5)) {
                    $data['firebase_measurement_id'] = $firebase_measurement_id;
                }

            }
            elseif($page_name=='orders'){
                $data_setting_order = @$post['is_enable_mail_order_receive'] ? @$post['is_enable_mail_order_receive'] : 0 ;
                AppSetting::where(['key'=>'is_enable_mail_order_receive'])->update(['value'=>$data_setting_order]);
                $myAr = array("default_tax","shipping_charge","minimum_order_value","nearest_delivery_date");
            }elseif($page_name == 'google_map_address'){
                $data_setting_order = @$post['is_enable_google_map_address'] ? @$post['is_enable_google_map_address'] : 0 ;
                AppSetting::where(['key'=>'is_enable_google_map_address'])->update(['value'=>$data_setting_order]);
                
                $appSettingData = AppSetting::where('key', 'google_address_map_api_key')->first();
                $google_address_map_api_key = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($google_address_map_api_key, -5) == substr($data['google_address_map_api_key'], -5)) {
                    $data['google_address_map_api_key'] = $google_address_map_api_key;
                }
            }elseif($page_name == 'app_google_map_address'){
                $data_setting_order = @$post['is_enable_app_google_map_address'] ? @$post['is_enable_app_google_map_address'] : 0 ;
                AppSetting::where(['key'=>'is_enable_app_google_map_address'])->update(['value'=>$data_setting_order]);
            }elseif($page_name == 'global_settings'){
                $appSettingData = AppSetting::where('key', 'google_translate_api_key')->first();
                $google_translate_api_key = $appSettingData->value ?? null;
                
                // Check if the last 5 characters match
                if (substr($google_translate_api_key, -5) == substr($data['google_translate_api_key'], -5)) {
                    $data['google_translate_api_key'] = $google_translate_api_key;
                }
            }elseif($page_name == 'app_setting'){
                $is_android_app_force_update = @$post['is_android_app_force_update'] ? @$post['is_android_app_force_update'] : 0 ;
                AppSetting::where(['key'=>'is_android_app_force_update'])->update(['value'=>$is_android_app_force_update]);

                $is_ios_app_force_update = @$post['is_ios_app_force_update'] ? @$post['is_ios_app_force_update'] : 0 ;
                AppSetting::where(['key'=>'is_ios_app_force_update'])->update(['value'=>$is_ios_app_force_update]);

                $myAr = array("rate_us_android","rate_us_ios");
            }


            $startFormatKeys = array(
                'one_signal_key',
                'one_signal_app_id',
                '2_factor_api_key',
                'fast_2_sms_sender_id',
                'fast_2_sms_api_key',
                'twilio_account_sid',
                'twilio_auth_token',
                'twilio_phone_number',
                'firebase_api_key',
                'firebase_auth_domain',
                'firebase_project_id',
                'firebase_storage_bucket',
                'firebase_messaging_sender_id',
                'firebase_app_id',
                'firebase_messaging_vapid_publickey',
                'firebase_measurement_id',
                'google_address_map_api_key',
                'google_translate_api_key'
            );


            foreach ($data as $key => $value) {
                $exist = AppSetting::where('key',$key)->first();
                if ($exist) {
                    $id = AppSetting::where('id',$exist->id)->update(array('value'=>$value));
                }else{
                    AppSetting::insert(array('key'=>$key,'value'=>$value));
                }
            }

            foreach ($myAr as $r) {
                $value = (isset($post[$r]))?$post[$r]:'';
                $exist = AppSetting::where('key',$r)->first();

                if(in_array($r,$paymentGatewayKey)){
                    continue;
                }

                if(in_array($r,$startFormatKeys)){
                    continue;
                }

                if($exist){
                    AppSetting::where('id',$exist->id)->update(array('value'=>$value,'updated_at' => date("y-m-d H:i:s")));
                }else{
                    AppSetting::insert(array('value'=>$value,'key'=>$r,'updated_at' => date("y-m-d H:i:s")));
                }
            }


            // ====================Image Handle===================================
            if ($image = $request->file('about_product')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "about_product." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['about_product'] = "$profileImage";
            }else{
                unset($post['about_product']);
            }

            if ($image = $request->file('website_logo')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "website_logo." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['website_logo'] = "$profileImage";
            }else{
                unset($post['website_logo']);
            }


            if ($image = $request->file('app_logo')) {
                $destinationPath = public_path('site-assets/images/app/');
                $profileImage = date('YmdHis') . "app_logo." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['app_logo'] = "$profileImage";
            }else{
                unset($post['app_logo']);
            }
            
            
            if ($image = $request->file('splash_screen')) {
                $destinationPath = public_path('site-assets/images/app/');
                $profileImage = date('YmdHis') . "splash_screen." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['splash_screen'] = "$profileImage";
            }else{
                unset($post['splash_screen']);
            }


            if ($image = $request->file('website_favicon')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "website_favicon." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['website_favicon'] = "$profileImage";
            }else{
                unset($post['website_favicon']);
            }

            if ($image = $request->file('mobile_image')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "mobile_image." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['mobile_image'] = "$profileImage";
            }else{
                unset($post['mobile_image']);
            }


            if ($image = $request->file('icon_1')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "icon_1." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['icon_1'] = "$profileImage";
            }else{
                unset($post['icon_1']);
            }

            if ($image = $request->file('icon_2')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "icon_2." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['icon_2'] = "$profileImage";
            }else{
                unset($post['icon_2']);
            }

            if ($image = $request->file('icon_3')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "icon_3." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['icon_3'] = "$profileImage";
            }else{
                unset($post['icon_3']);
            }

            if ($image = $request->file('icon_4')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "icon_4." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['icon_4'] = "$profileImage";
            }else{
                unset($post['icon_4']);
            }

            if ($image = $request->file('website_bg_image')) {
                $destinationPath = public_path('site-assets/images/website/');
                $profileImage = date('YmdHis') . "website_bg_image." . $image->getClientOriginalExtension();
                $image->move($destinationPath, $profileImage);
                $post['website_bg_image'] = "$profileImage";
            }else{
                unset($post['website_bg_image']);
            }

            foreach ($post as $key => $value) {

                if(in_array($key,$paymentGatewayKey)){
                    continue;
                }

                if(in_array($key,$startFormatKeys)){
                    continue;
                }
                
                $exist = $obj->where('key',$key)->first();
                if ($exist) {
                    $id = $obj->where('id',$exist->id)->update(array('value'=>$value));
                }else{
                    $obj->insert(array('key'=>$key,'value'=>$value));
                }
            }

        }
        
        $settingsc = $obj->all();
        foreach ($settingsc as $row) {
            ContentSetting::set($row->key, $row->value);
        }
        ContentSetting::save();
            
        $envFilePath = base_path('.env');
        $replacementPairs = array();
        if(isset($post['mail_driver']) && $post['mail_driver']!=''){
            $replacementPairs['MAIL_MAILER'] = $post['mail_driver'];
            $replacementPairs['MAIL_DRIVER'] = $post['mail_driver'];
        }
        if(isset($post['mail_host']) && $post['mail_host']!=''){
            $replacementPairs['MAIL_HOST'] = $post['mail_host'];
        }
        if(isset($post['mail_port']) && $post['mail_port']!=''){
            $replacementPairs['MAIL_PORT'] = $post['mail_port'];
        }
        if(isset($post['mail_username']) && $post['mail_username']!=''){
            $replacementPairs['MAIL_USERNAME'] = $post['mail_username'];
        }
        if(isset($post['mail_password']) && $post['mail_password']!=''){
            $replacementPairs['MAIL_PASSWORD'] = $post['mail_password'];
        }
        if(isset($post['mail_encrytion']) && $post['mail_encrytion']!=''){
            $replacementPairs['MAIL_ENCRYPTION'] = $post['mail_encrytion'];
        }
        if(isset($post['mail_from_name']) && $post['mail_from_name']!=''){
            $replacementPairs['MAIL_FROM_NAME'] = $post['mail_from_name'];
        }
        $envContents = file_get_contents($envFilePath);
        if(count($replacementPairs)>0){
            foreach ($replacementPairs as $key => $value) {
                $search = "{$key}=";
                $replacement = "{$key}={$value}";
                $envContents = preg_replace("/^{$key}=.*/m", $replacement, $envContents);
            }

            file_put_contents($envFilePath, $envContents);
        }
        return redirect()->back()->with('success', __('lang.message_info_updated_successfully'));
    }

    private function isValidJson($string)
    {
        json_decode($string);
        return (json_last_error() === JSON_ERROR_NONE);
    }

    private function save_firebase_setting($request){
        $rules = [
            'firebase_json_file' => 'file|mimetypes:application/json,text/plain,application/octet-stream|max:2048',
        ];
        $validator = Validator::make($request->all(), $rules, []);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $file = $request->file('firebase_json_file');
        $path_storage = storage_path('app/public/firebase');
        $public_path = public_path();
        $firebase_dir='firebase'; // suggest to make directory on storage folder (app/firebase)
        $fileContent = file_get_contents($file->getPathname());
        file_put_contents($path_storage.'/firebase_credentials.json', $fileContent);
        $firebase_messaging_sw = file_get_contents($path_storage.'/firebase-messaging-sw.js');
        $firebase_messaging_sw = str_replace('{{apiKey}}', $request->firebase_api_key,  $firebase_messaging_sw );
        $firebase_messaging_sw = str_replace('{{authDomain}}', $request->firebase_auth_domain,  $firebase_messaging_sw );
        $firebase_messaging_sw = str_replace('{{projectId}}', $request->firebase_project_id,  $firebase_messaging_sw );
        $firebase_messaging_sw = str_replace('{{storageBucket}}', $request->firebase_storage_bucket,  $firebase_messaging_sw );
        $firebase_messaging_sw = str_replace('{{messagingSenderId}}', $request->firebase_messaging_sender_id,  $firebase_messaging_sw );
        $firebase_messaging_sw = str_replace('{{appId}}', $request->firebase_app_id,  $firebase_messaging_sw );
        $firebase_messaging_sw = str_replace('{{measurementId}}', $request->firebase_measurement_id,  $firebase_messaging_sw );
        file_put_contents($public_path.'/firebase-messaging-sw.js', $firebase_messaging_sw);

        $firebase_messaging_js = file_get_contents($path_storage.'/firebase.js');
        $firebase_messaging_js = str_replace('{{apiKey}}', $request->firebase_api_key,  $firebase_messaging_js );
        $firebase_messaging_js = str_replace('{{authDomain}}', $request->firebase_auth_domain,  $firebase_messaging_js );
        $firebase_messaging_js = str_replace('{{projectId}}', $request->firebase_project_id,  $firebase_messaging_js );
        $firebase_messaging_js = str_replace('{{storageBucket}}', $request->firebase_storage_bucket,  $firebase_messaging_js );
        $firebase_messaging_js = str_replace('{{messagingSenderId}}', $request->firebase_messaging_sender_id,  $firebase_messaging_js );
        $firebase_messaging_js = str_replace('{{appId}}', $request->firebase_app_id,  $firebase_messaging_js );
        $firebase_messaging_js = str_replace('{{measurementId}}', $request->firebase_measurement_id,  $firebase_messaging_js );
        $firebase_messaging_js = str_replace('{{vapidKey}}', $request->firebase_messaging_vapid_publickey,  $firebase_messaging_js );
        $firebase_messaging_js = str_replace('{{route_fcm_token}}',route('fcmToken'),  $firebase_messaging_js );
        file_put_contents($public_path.'/firebase.js', $firebase_messaging_js);
        /* store rest of the settings:  */
        $requestData = $request->all();
        foreach ($requestData as $key => $value) {
            if($key=='countryCodes'){
                $value= json_encode($value);
            }
            $settingName = $key; // Extract the setting name
            $settingValue = $value; // Get the corresponding value
            AppSetting::save_setting($settingName,$settingValue);
        }
        return redirect()->back()->with('success', __('lang.message_firebase_json_file_uploaded_successfully'));
    }

    function defaultSettingsUpdate(Request $request)
    {
        $key = $request->key;
        return true;
    }

}