<?php

namespace App\Http\Controllers;
use anlutro\LaravelSettings\Facade as Setting;

use Illuminate\Http\Request;
use App\Models\Partners;
use App\Models\PartnersTranslation;
use App\Models\Languages;
use Illuminate\Support\Facades\Session;

class AboutUsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Partners::getLists();
        $filter = array();
        // Add the new status to the filters
        $filter['status'] = [__('lang.admin_about_us_award'),__('lang.admin_about_us_partner')];
        return view('about_us.index',compact('data'))->with('filter',$filter);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/partners/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }
        //echo json_encode($input);exit;
        Partners::create($input);
        return redirect()->route('about_us.index')
                        ->with('success',__('lang.message_record_created_successfully'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Partners::find($id);
        return view('about_us.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();

        $data = Partners::find($id);
        if ($image = $request->file('image')) {
            $destinationPath = public_path('app-assets/images/partners/');
            $profileImage = date('YmdHis') . "." . $image->getClientOriginalExtension();
            $image->move($destinationPath, $profileImage);
            $input['image'] = "$profileImage";
        }else{
            unset($input['image']);
        }

        $data->update($input);
        return redirect()->route('about_us.index')
                        ->with('success',__('lang.message_record_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Partners::find($id)->delete();
        return redirect()->route('about_us.index')
                        ->with('success',__('lang.message_record_deleted_successfully'));
    }

    public function translation($id)
    {
        $data = Partners::find($id);
        $languages = Languages::where('status',1)->get();
        foreach ($languages as $row) {
            $row->details = PartnersTranslation::where('partner_id',$id)->where('lang_code',$row->language_code)->first();
            if(!$row->details){
                $postData = array(
                    'partner_id' => $id,
                    'lang_code' => $row->language_code,
                    'name' => $data->name,
                    'created_at' => date("Y-m-d H:i:s")
                );
                PartnersTranslation::insert($postData);
                $row->details = PartnersTranslation::where('partner_id',$id)->where('lang_code',$row->language_code)->first();
            }
        }
        return view('about_us.translation',compact('data'))->with('languages',$languages);
    }

    public function updateTranslation($id,Request $request)
    {
        $post = $request->all();

        request()->validate([
            'language_code' => 'required',
            'name' => 'required'
        ]);
        $input = $request->all();

        for ($i=0; $i < count($input['language_code']); $i++) {
            if($input['language_code'][$i] == 'en'){
                $updateData = array(
                    'name'        => $input['name'][$i]
                );
                Partners::where('id',$id)->update($updateData);
            }

            $postData = array(
                'lang_code' => $input['language_code'][$i],
                'name' => $input['name'][$i],
                'updated_at' => date("Y-m-d H:i:s")
            );
            PartnersTranslation::where('id',$input['translation_id'][$i])->update($postData);
        }

        return redirect()->route('about_us.index')
                        ->with('success',__('lang.message_translation_updated_successfully'));
    }
}
