<?php

namespace App\Http\Controllers\API;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\UserWallet;
use App\Models\UserPayment;

class UserWalletAPIController extends Controller
{
    
    public function __construct(Request $request)
    {
        // parent::__construct();
        $this->request = $request;
        $this->language = $request->header('lang-code') && $request->header('lang-code') != '' ? $request->header('lang-code') : 'en';
        app()->setLocale($this->language);
    }
    
    public function addWalletAmount(Request $request)
    {
        try{
            $walletId = '';
            $post = $request->all();
            $user_id = 0;
            if($request->userAuthData){
                $user_id = $request->userAuthData->user_id;
            }
            if ($user_id) {
                $userPaymentData = [
                    "user_id" => $user_id,
                    "description" => 'wallet amount added',
                    "price" => $post['wallet_amount'] ?? 0,
                    "status" => "Paid",
                    'created_at' => now() // Using now() for better readability
                ];
    
                // Add optional fields if they exist
                if (isset($post['payment_transection_id'])) {
                    $userPaymentData['payment_transection_id'] = $post['payment_transection_id'];
                }
                if (isset($post['payment_transection_data'])) {
                    $userPaymentData['payment_transection_data'] = $post['payment_transection_data'];
                }
                if (isset($post['payment_refferance_id'])) {
                    $userPaymentData['payment_refferance_id'] = $post['payment_refferance_id'];
                }
                if (isset($post['payment_status'])) {
                    $userPaymentData['payment_status'] = $post['payment_status'];
                }
                $UserPayment = UserPayment::insertGetId($userPaymentData);

                if(isset($post['payment_status'])){
                    if($post['payment_status'] == 1){
                        $wallet = [
                            'user_id'=>$user_id,
                            'payment_id'=>$UserPayment,
                            'type'=>'credit',
                            'amount'=>$post['wallet_amount'] ?? 0,
                            'description'=>'wallet amount added',
                            'created_at' => date("y-m-d H:i:s")
                        ];  
                        
                         $walletId = UserWallet::insertGetId($wallet);
                         return $this->sendResponse($walletId, __('lang.message_payment_success'));
                    }else{
                        return $this->sendResponse($UserPayment,__('lang.message_payment_failed'));
                    }
                    
                }else{
                    $wallet = [
                            'user_id'=>$user_id,
                            'payment_id'=>$UserPayment,
                            'type'=>'credit',
                            'amount'=>$post['wallet_amount'] ?? 0,
                            'description'=>'wallet amount added',
                            'created_at' => date("y-m-d H:i:s")
                        ];
                    
                    $walletId = UserWallet::insertGetId($wallet);
                    return $this->sendResponse($walletId,__('lang.message_payment_success'));
                }

                return $this->sendResponse($walletId,__('lang.message_payment_success'));
            }else{
                return $this->sendError(__('lang.message_user_not_found'), 401);
            }

        }catch(RepositoryException $e){
            return $this->sendError($e->getMessage());
        }
    }

    public function list(Request $request)
    {
        try{
            $user_id = 0;
            if($request->userAuthData){
                $user_id = $request->userAuthData->user_id;
            }
            if ($user_id) {
                $UserWallet = UserWallet::where('user_id',$user_id)->orderBy('id','DESC')->get();
                return $this->sendResponse($UserWallet,__('lang.message_data_retrieve_successfully'));
            }else{
                return $this->sendError(__('lang.message_user_not_found'), 401);
            }
        }catch(RepositoryException $e){
            return $this->sendError($e->getMessage());
        }
    }

    public function walletAmountOfuser(Request $request)
    {
        try{
            $user_id = 0;
            if($request->userAuthData){
                $user_id = $request->userAuthData->user_id;
            }
            if ($user_id) {
                $amount = UserWallet::where('user_id',$user_id)->sum('amount');
                return $this->sendResponse($amount, __('lang.message_data_retrieve_successfully'));
            }else{
                return $this->sendError(__('lang.message_user_not_found'), 401);
            }
        }catch(RepositoryException $e){
            return $this->sendError($e->getMessage());
        }
    }
}
