<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Product;
use App\Models\ProductTranslation;
use App\Models\Cart;
use App\Models\Banners;
use App\Models\BannerTranslation;
use DB;

class ProductAPIController extends Controller
{
    
    protected $num_per_page = '20';
    private $language;
    public function __construct(Request $request)
    {
        parent::__construct();
        $this->request = $request;
        $this->language = $request->header('lang-code') && $request->header('lang-code') != '' ? $request->header('lang-code') : 'en';
        app()->setLocale($this->language);
    }

    public function index(Request $request)
    {
        try {
            $response = [
                'banners' => Banners::where('status', 1)->where('banner_type', 'app')->get(),
                'products' => []
            ];
    
            $this->num_per_page = $request->input('perpage', $this->num_per_page);
    
            // Process banner translations
            foreach ($response['banners'] as $bannerRow) {
                $translated_data = BannerTranslation::where('lang_code', $this->language)
                    ->where('banner_id', $bannerRow['id'])
                    ->first();
    
                if ($translated_data) {
                    if (!empty($translated_data->title)) {
                        $bannerRow['title'] = $translated_data->title;
                    }
                    if (!empty($translated_data->sub_title)) {
                        $bannerRow['sub_title'] = $translated_data->sub_title;
                    }
                }
            }
    
            // Validate user token
            $user_id = 0;
            $headerData = $request->header('api-token');
            $tokenData = \Helpers::velidateAuthToken($headerData);
    
            if ($tokenData) {
                $request->userAuthData = $tokenData;
                if ($request->userAuthData) {
                    $user_id = $request->userAuthData->user_id;
                }
            }
    
            $allproducts = Product::where('status', 1)
                ->with('images')
                ->orderBy('created_at', 'DESC')
                ->paginate($this->num_per_page)
                ->appends('perpage', $this->num_per_page);
    
            foreach ($allproducts as $row) {
                // Initialize the images array
                $images = [];
            
                // Check if the product has related images
                if ($row->images && count($row->images) > 0) {
                    foreach ($row->images as $image) {
                        // Add the related image if available, otherwise fallback to the product's default image
                        $images[] = !empty($image->image) ? $image->image : $row->image;
                    }
                } else {
                    // If no related images exist, fallback to the product's default image
                    $images[] = $row->image;
                }
            
                // Update product with processed images
                $row->image = $images;
            
                // Remove the images key to clean up the data
                unset($row->images);
            
                // Add cart info for the user
                $row['cart_info'] = Cart::where('user_id', $user_id)
                    ->where('product_id', $row['id'])
                    ->first();
            
                // Add product translations based on the current language
                $translated_data = ProductTranslation::where('lang_code', $this->language)
                    ->where('product_id', $row['id'])
                    ->first();
            
                if ($translated_data) {
                    if (!empty($translated_data->name)) {
                        $row['name'] = $translated_data->name;
                    }
                    if (!empty($translated_data->description)) {
                        $row['description'] = $translated_data->description;
                    }
                }
            }

    
            $response['products'] = $allproducts;
    
            return $this->sendResponse($response, __('lang.message_data_retrieve_successfully'));
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }


    public function productDetails($id,Request $request)
    {
        try{
            
            $user_id = 0;
            $headerData = ($request->header('api-token')? $request->header('api-token'):$request->header('api-token'));
            $tokenData = \Helpers::velidateAuthToken($headerData);
            if ($tokenData) {
                $request->userAuthData = $tokenData;
                if($request->userAuthData){
                    $user_id = $request->userAuthData->user_id;
                }
            }
            
            $row = Product::where('id', $id)->with('images')->first();
            
            $images = [];
            if ($row && $row->images) {
                foreach ($row->images as $image) {
                    if (!empty($image->image)) {
                        $images[] = asset('app-assets/images/products/'.$image->image);
                    }
                }
                if($row->discount_price == 0.00 || $row->discount_price == 0){
                   $row->discount_price = null;
                }
                
            }
            
            // Add the processed images array to the product object
            $row->image = $images;
            
            // Remove the images key from the object
            unset($row->images);


            $row['cart_info'] = Cart::where('user_id',$user_id)->where('product_id',$row['id'])->first();
            $translated_data = ProductTranslation::where('lang_code',$this->language)->where('product_id',$row['id'])->first();
            if($translated_data){
                if($translated_data->name!=''){
                    $row['name'] = $translated_data->name;
                }
                if($translated_data->description!=''){
                    $row['description'] = $translated_data->description;
                }
            }
            return $this->sendResponse($row, __('lang.message_data_retrieve_successfully'));
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

    public function search(Request $request)
    {
        try {
            $post = $request->all();
            $user_id = 0;
    
            // Validate user token
            $headerData = $request->header('api-token');
            $tokenData = \Helpers::velidateAuthToken($headerData);
            if ($tokenData) {
                $request->userAuthData = $tokenData;
                if ($request->userAuthData) {
                    $user_id = $request->userAuthData->user_id;
                }
            }
    
            // Search for products
            $searchedProducts = Product::where('status', 1)
                ->where(DB::raw('lower(name)'), 'like', '%' . strtolower($post['search']) . '%')
                ->with('images')
                ->get();
    
            foreach ($searchedProducts as $row) {
                // Process images for each product
                $images = [];
                if ($row->images) {
                    foreach ($row->images as $image) {
                        if (!empty($image->image)) {
                            $images[] = asset('app-assets/images/products/'.$image->image);
                        }
                    }
                }
    
                // Add processed images to product
                $row->image = $images;
    
                // Remove the images key
                unset($row->images);
    
                // Add cart info
                $row['cart_info'] = Cart::where('user_id', $user_id)
                    ->where('product_id', $row['id'])
                    ->first();
    
                // Add product translations
                $translated_data = ProductTranslation::where('lang_code', $this->language)
                    ->where('product_id', $row['id'])
                    ->first();
    
                if ($translated_data) {
                    if (!empty($translated_data->name)) {
                        $row['name'] = $translated_data->name;
                    }
                    if (!empty($translated_data->description)) {
                        $row['description'] = $translated_data->description;
                    }
                }
            }
    
            // Response with the searched products
            $response = $searchedProducts;
            return $this->sendResponse($response, __('lang.message_data_retrieve_successfully'));
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

}
