<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\UserPayment;

class PaymentAPIController extends Controller
{
    
    public function __construct(Request $request)
    {
        $this->request = $request;
        $this->language = $request->header('lang-code') && $request->header('lang-code') != '' ? $request->header('lang-code') : 'en';
        
        app()->setLocale($this->language); // This is important
    }


    public function list(Request $request)
    {
        try{
            $user_id = 0;            
            if($request->userAuthData){
                $user_id = $request->userAuthData->user_id;
            }            
            if ($user_id) {
                $payments = UserPayment::where('user_id',$user_id)->orderBy('id','DESC')->get();
                return $this->sendResponse($payments, __('lang.message_data_retrieve_successfully'));
            }else{
                return $this->sendError(__('lang.message_data_not_found'), 401);
            }
        }catch(RepositoryException $e){
            return $this->sendError($e->getMessage());
        }
    }
}
