<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Notification;


class NotificationAPIController extends Controller
{
    
    private $language;
    public function __construct(Request $request)
    {
        parent::__construct();
        $this->request = $request;
        $this->language = $request->header('lang-code') && $request->header('lang-code') != '' ? $request->header('lang-code') : 'en';
        app()->setLocale($this->language);
    }

    public function index(Request $request)
    {    
        
         
        $post = $request->all();
        $user_id = 0;            
        if($request->userAuthData){
            $user_id = $request->userAuthData->user_id;
        }
        Notification::where('user_id',$user_id)->update(array('read_status'=>1));
        $notifications = Notification::where('user_id',$user_id)->orderBy("id","DESC")->paginate(config('constant.paginate.num_per_page'));

        return $this->sendResponse($notifications, __('lang.message_data_not_found'));
    }

    public function unreadCount(Request $request)
    {
        $user_id = 0;

        if($request->userAuthData){
            $user_id = $request->userAuthData->user_id;
        }
        $notification = Notification::where('user_id',$user_id)->where('read_status',0)->count();
        return $this->sendResponse($notification, __('lang.saved_successfully',['operator' => __('Notification')]));
    }

    public function update($id, Request $request)
    {
        $notification = Notification::where('id',$id)->first();

        if (empty($notification)) {
            return $this->sendError(__('lang.message_data_not_found'));
        }
        $input = $request->all();

        if(isset($input['read_at'])){
            if($input['read_at'] == true){
                $input['read_at'] = date("Y-m-d H:i:s");
            }else{
                unset($input['read_at']);
            }
        }
        $notification = Notification::where('id',$id)->update($input);
        return $this->sendResponse($notification, __('lang.saved_successfully',['operator' => __('Notification')]));
    }

    public function destroy(Request $request)
    {

        $user_id = 0;            
        if($request->userAuthData){
            $user_id = $request->userAuthData->user_id;
        }

        Notification::where('user_id',$user_id)->delete();

        return $this->sendResponse([], __('Deleted_successfully',['operator' => __('Notification')]));

    }

    public function getDriverNotificationList(Request $request)
    {
        $post = $request->all();
        $user_id = 0;            
        if($request->userAuthData){
            $user_id = $request->userAuthData->user_id;
        }
        Notification::where('user_id',$user_id)->update(array('read_status'=>1));
        $notifications = Notification::where('user_id',$user_id)->orderBy("id","DESC")->paginate(config('constant.paginate.num_per_page'));

        return $this->sendResponse($notifications, __('lang.message_data_retrieve_successfully'));
    }

    public function deleteAllDriverNotification(Request $request)
    {

        $user_id = 0;            
        if($request->userAuthData){
            $user_id = $request->userAuthData->user_id;
        }

        Notification::where('user_id',$user_id)->delete();

        return $this->sendResponse([], __('Deleted_successfully',['operator' => __('Notification')]));

    }

    public function getDriverNotificationCount(Request $request)
    {
        $user_id = 0;

        if($request->userAuthData){
            $user_id = $request->userAuthData->user_id;
        }
        $notification = Notification::where('user_id',$user_id)->where('read_status',0)->count();
        return $this->sendResponse($notification, __('lang.saved_successfully',['operator' => __('Notification')]));
    }
}
