<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\LanguagesKeywords;

class LanguagesAPIController extends Controller
{
    
    public function __construct(Request $request)
    {
        $this->request = $request;
        $this->language = $request->header('lang-code') && $request->header('lang-code') != '' ? $request->header('lang-code') : 'en';
        app()->setLocale($this->language);
    }


    /**
     * Show keysLists of settings.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function keysLists(Request $request)
    {
        try {
            $response = array();
            
            // Default language
            $lang_code = 'en';
            
            // First, check if the lang-code exists in header and is not empty
            if ($request->hasHeader('lang-code') && !empty($request->header('lang-code'))) {
                $lang_code = $request->header('lang-code');
            }
            // If not in header, check if it's in the GET parameters
            elseif (isset($_GET['lang-code']) && !empty($_GET['lang-code'])) {
                $lang_code = $_GET['lang-code'];
            }
            elseif (isset($_GET['lang_code']) && !empty($_GET['lang_code'])) {
                $lang_code = $_GET['lang_code'];
            }


            $translations = LanguagesKeywords::where('group','api')->where('lang_code',$lang_code)->get();
            foreach ($translations as $row) {
                $response[$row->keyword] = $row->value;
            }

            return $this->sendResponse($response,__('lang.message_data_not_found'));
        } catch (\Exception $e) {
            return $this->sendError($e->getMessage(), 401);
        }
    }

    public function addNewKeys(Request $request)
    {
        try {
            $post = $request->all();
            $lang_code = 'en';
            $lang_code = (isset($post['lang_code']))?$post['lang_code']:$lang_code;
            $group = (isset($post['group']))?$post['group']:'api';
            foreach ($post['data'] as $key => $value) {
                $translations = LanguagesKeywords::where('group',$group)->where('keyword',$key)->where('lang_code',$lang_code)->first();
                if($translations){
                    $inject = array(
                        'value' => $value
                    );
                    $inject['updated_at'] = date('Y-m-d h:i:s');
                    LanguagesKeywords::where('id',$translations->id)->update($inject);
                }else{
                    $inject = array(
                        'lang_code' => $lang_code,
                        'group' => $group,
                        'keyword' => $key,
                        'value' => $value
                    );
                    $inject['created_at'] = date('Y-m-d h:i:s');
                    $id = LanguagesKeywords::insertGetId($inject);
                }
            }
            return $this->sendResponse([], __('lang.message_data_added_successfully'));
        } catch (\Exception $e) {
            return $this->sendError($e->getMessage(), 401);
        }
    }
}
