<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\Coupon;
use App\Models\CouponTranslation;

class CouponAPIController extends Controller
{
    protected $num_per_page = '10';
    private $language;
    public function __construct(Request $request)
    {
        parent::__construct();
        $this->request = $request;
        $this->language = $request->header('lang-code') && $request->header('lang-code') != '' ? $request->header('lang-code') : 'en';
        app()->setLocale($this->language);
    }


    public function couponLists(Request $request)
    {
        try {
            $allcodes = Coupon::where('end_date', '>=', now()->toDateString())
                ->where('start_date', '<=', now()->toDateString())
                ->where('status', 1)
                ->get();
    
            foreach ($allcodes as $row) {
                $translated_data = CouponTranslation::where('lang_code', $this->language)
                    ->where('coupon_id', $row->id)
                    ->first();
    
                if ($translated_data) {
                    if (!empty($translated_data->coupon_name)) {
                        $row->coupon_name = $translated_data->coupon_name;
                    }
                    if (!empty($translated_data->description)) {
                        $row->description = $translated_data->description;
                    }
                }
    
                // ✅ Keep original date, set fixed time (06:00 AM for start, 11:59 PM for end)
                $row->start_date = Carbon::parse($row->start_date)->format('Y-m-d') . "T06:00:00.000000Z";
                $row->end_date = Carbon::parse($row->end_date)->format('Y-m-d') . "T23:59:59.999999Z";
            }
    
            return $this->sendResponse($allcodes, __('lang.message_data_retrieve_successfully'));
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }

    public function doVerifyCode(Request $request)
    {
        try{
            
            $allcodes = Coupon::where('coupon_name',$request->input('code'))->where('end_date','>=',date("Y-m-d"))->where('start_date','<=',date("Y-m-d"))->where('status',1)->orderBy('id','DESC')->first();
            if($allcodes){
                return $this->sendResponse($allcodes, __('lang.message_data_retrieve_successfully'));    
            }else{
                return $this->sendError(__('lang.message_data_not_found'), 401);
            }
        } catch (RepositoryException $e) {
            return $this->sendError($e->getMessage());
        }
    }
}
