<?php
use Illuminate\Support\Facades\Auth;
use App\Models\Cart;
use App\Models\User;
use App\Models\AppSetting;
use App\Models\UserAuthLogin;
use App\Models\Languages;
use App\Models\ProductImage;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\DB;
use Intervention\Image\Facades\Image;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Session;
use Google\Client as GoogleClient;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;

class Helpers {
    public static function getAllLangList(){
        $list  = Languages::where('status',1)->get();
        return $list;
    }
    public static function getLangData($code){
        $direction = "ltr";
        $language  = Languages::where('status',1)->where('language_code',$code)->first();
        if($language){
            $direction = $language->language_direction;
        }
        return $direction;
    }

    /**
     * Check Role has selected that permission
    **/
    public static function checkRoleHasPermission($role_id,$permission_id) {
        // $language = setting('preferred_site_language');
        $permission = DB::table("role_has_permissions")->where("role_has_permissions.role_id",$role_id)
            ->where("role_has_permissions.permission_id",$permission_id)->count();
        if ($permission>0) {
           return 1;
        }else{
            return 0;
        }
    }

    public static function sendSuccessResponse($result = [], $code = 200, $token = '')
    {
        if(is_array($result) && count($result) == 0){
            $result = (object)$result;
        }
        $response = [
            'success'   => $result
        ];
        if($token && $token != ''){
            return response()->json($response, $code)->header('token', $token);
        }
        return response()->json($response, $code);
    }

    /*
     * function for send failure response
     */
    public static function sendFailureResponse($message = 'Something went wrong.', $code = 422)
    {
        $response = [
            'error'   => $message,
        ];
        return response($response, $code);
    }

    public static function generateApiToken(){
        mt_srand((double)microtime()*10000);
        $uuid = rand(1,99999).time();
        $salt = substr(sha1(uniqid(mt_rand(), true)), 0, 40);
        return substr(sha1($salt) . $salt,1,85).$uuid;
    }

    public static function getSignature() {
        $clientId = config('constant.cashfree_payout.test_client_id');;
        $publicKey =
    openssl_pkey_get_public(file_get_contents("/path/to/certificate/public
    _key.pem"));
        $encodedData = $clientId.".".strtotime("now");
        return static::encrypt_RSA($encodedData, $publicKey);
    }

    private static function encrypt_RSA($plainData, $publicKey) { if (openssl_public_encrypt($plainData, $encrypted, $publicKey,
    OPENSSL_PKCS1_OAEP_PADDING))
          $encryptedData = base64_encode($encrypted);
        else return NULL;
        return $encryptedData;
    }

    public static function velidateAuthToken($token){
        $tokenExist  = UserAuthLogin::where('api_token',$token)->with('user')->first();
        if($tokenExist){
            return $tokenExist;
        }
        return false;
    }

    public static function checkNull($val = null)
    {
        if ($val == '' || $val == null) {
            return '--';
        } else {
            return $val;
        }
    }

    public static function checkVerified($value = 0){
        if ($value) {
            return 'Yes';
        }else{
            return 'No';
        }
    }

    /**
     * function for check empty value
     * @param $value
     */
    public static function checkEmpty($value = null)
    {
        if (isset($value) && !empty($value)) {
            $data = trim(strip_tags($value));
            return iconv('ISO-8859-1', 'ASCII//IGNORE', $data);
        } else {
            return null;
        }
    }

    /**
     * function for Common Datetime picker formate
     * @param $value
     */
    public static function commonDateTimePickerFormate($value = null)
    {
        if (isset($value) && !empty($value) && ($value != '0000-00-00' && $value != '0000-00-00 00:00:00' && $value != '1970-01-01')) {
            $value = trim($value);
            return date(setting('date_time_format'), strtotime($value));
        } else {
            return null;
        }
    }

    /**
     * function for Common Date Formate
     * @param $value
     */
    public static function commonDateFormate($value = null)
    {
        if (isset($value) && !empty($value) && ($value != '0000-00-00' && $value != '0000-00-00 00:00:00' && $value != '1970-01-01')) {
            $value = trim($value);
            return date(setting('date_format'), strtotime($value));
        } else {
            return 'NA';
        }
    }

    public static function commonTimeFormate($value = null)
    {
        if (isset($value) && !empty($value) && ($value != '0000-00-00' && $value != '0000-00-00 00:00:00' && $value != '1970-01-01')) {
            $value = trim($value);
            return date(setting('time_format'), strtotime($value));
        } else {
            return 'NA';
        }
    }

    /**
     * function for Common Date Formate
     * @param $value
     */
    public static function showPaymentStatus($value = null)
    {
        switch ($value) {
            case 'Paid':
                return '<span class="badge rounded-pill badge-light-success me-1">Paid</span>';
                break;
            case 'Unpaid':
                return '<span class="badge rounded-pill badge-light-danger me-1">Unpaid</span>';
                break;
            case 'processing':
                return '<span class="badge rounded-pill badge-light-info me-1">Processing</span>';
                break;
            case 'Processing':
                return '<span class="badge rounded-pill badge-light-info me-1">Processing</span>';
                break;
            case 'Waiting for Client':
                return '<span class="badge rounded-pill badge-light-info me-1">Waiting for Client</span>';
                break;
            case 'Failed':
                return '<span class="badge rounded-pill badge-light-danger me-1">Failed</span>';
                break;
            default:
                return $value;
                break;
        }
    }

    /**
     * function for Common Date Formate
     * @param $value
     */
    public static function commonDateTimeFormate($value = null)
    {
        if (isset($value) && !empty($value) && ($value != '0000-00-00' && $value != '0000-00-00 00:00:00' && $value != '1970-01-01')) {
            $value = trim($value);
            return date(setting('date_time_format'), strtotime($value));
        } else {
            return null;
        }
    }

    /**
     * function for check empty date
     * @param $value
     */
    public static function checkEmptydate($value = null)
    {
        if (isset($value) && !empty($value) && ($value != '0000-00-00' && $value != '0000-00-00 00:00:00' && $value != '1970-01-01')) {
            $value = trim($value);
            return date('Y-m-d', strtotime($value));
        } else {
            return 'NA';
        }
    }

    /**
     * function for check empty date
     * @param $value
     */
    public static function checkEmptydateMdY($value = null)
    {
        if (isset($value) && !empty($value) && ($value != '0000-00-00' && $value != '0000-00-00 00:00:00' && $value != '1970-01-01')) {
            $value = trim($value);
            return date('d M Y', strtotime($value));
        } else {
            return null;
        }
    }

    /**
     * function for check empty date
     * @param $value
     */
    public static function checkEmptydateMdYHIS($value = null)
    {
        if (isset($value) && !empty($value) && ($value != '0000-00-00' && $value != '0000-00-00 00:00:00' && $value != '1970-01-01')) {
            $value = trim($value);
            return date('d M Y h:i A', strtotime($value));
        } else {
            return "--";
        }
    }

    /**
     * function for check empty date
     * @param $value
     */
    public static function checkEmptydateTime($value = null)
    {
        if (isset($value) && !empty($value) && ($value != '0000-00-00' && $value != '0000-00-00 00:00:00' && $value != '1970-01-01')) {
            $value = trim($value);
            return date('Y-m-d H:i:s', strtotime($value));
        } else {
            return null;
        }
    }


    /*
     * Method to strip tags globally.
     */

    public static function globalXssClean()
    {
        // Recursive cleaning for array [] inputs, not just strings.
        $sanitized = static::arrayStripTags(Request::all());
        Request::merge($sanitized);
    }

    /**
     * Method to strip tags
     *
     * @param $array
     * @return array
     */
    public static function arrayStripTags($array)
    {
        $result = [];

        foreach ($array as $key => $value) {
            // Don't allow tags on key either, maybe useful for dynamic forms.
            $key = strip_tags($key);

            // If the value is an array, we will just recurse back into the
            // function to keep stripping the tags out of the array,
            // otherwise we will set the stripped value.
            if (is_array($value)) {
                $result[$key] = static::arrayStripTags($value);
            } else {
                // I am using strip_tags(), you may use htmlentities(),
                // also I am doing trim() here, you may remove it, if you wish.
                $result[$key] = trim(strip_tags($value));
            }
        }
        return $result;
    }

    /**
     * Escape output
     *
     * @param $value
     * @return string
     */
    public static function sanitizeOutput($value)
    {
        return addslashes($value);
    }

    /*
     * Convert date
     */

    public static function convertDate($convertDate)
    {
        if ($convertDate != '') {
            $convertDate = str_replace('/', '-', $convertDate);
            return date('Y-m-d', strtotime($convertDate));
        }
    }

    /**
     * Send success ajax response
     *
     * @param string $message
     * @param array $result
     * @return array
     */
    public static function sendSuccessAjaxResponse($message = '', $result = [])
    {
        $response = [
            'status' => true,
            'message' => $message,
            'data' => $result,
        ];
        return $response;
    }

    /**
     * Send failure ajax response
     *
     * @param string $message
     * @return array
     */
    public static function sendFailureAjaxResponse($message = '', $data = [])
    {
        $message = $message == '' ? config('app.message.default_error') : $message;

        $response = [
            'status' => false,
            'message' => $message,
        ];
        return $response;
    }



    /**
     * function for send email
    */
    public static function sendEmail($template, $data, $toEmail, $toName, $subject, $fromName = '', $fromEmail = '',$attachment = '') {
        if ($fromEmail == '') {
            $fromEmail = $fromEmail;
        }
        try {
            $fromName = setting('site_title');
            $data = \Mail::send($template, $data, function ($message) use($toEmail, $toName, $subject, $data, $fromName, $fromEmail, $attachment) {
                $message->to($toEmail, $toName);
                $message->subject($subject);
                if ($fromEmail != '' && $fromName != '') {
                    $message->from($fromEmail, $fromName);
                }
                if($attachment != ''){
                    $message->attach($attachment);
                }
            });
            return 1;
        } catch (\Exception $ex) {
            return $ex;
        }
    }

    /**
     * Generate password
     * @param int $length
     * @return string
     */
    public static function generatePassword($length = 12)
    {
        $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_-=+;:,.?";
        $password = substr(str_shuffle($chars), 0, $length);
        return $password;
    }


    /**
     * Generate otp
     * @param int $length
     * @return string
     */
    public static function generateOtp($length = 6)
    {
        $chars = "1234567890";
        $otp = substr(str_shuffle($chars), 0, $length);
        return $otp;
    }

    /**
     * Resize image
     * @param $fileToResize
     * @return mixed
     */
    public static function resizeImage($imageToResize)
    {
        $img = Image::make($imageToResize)
            ->resize(1200, null)
            ->encode('jpg', 80)
            ->save();
        return $img->basename;
    }

    /**
     * Convert image to jpg
     * @param $imageToConvert
     * @param $convertedFile
     * @return string
     */
    public static function convertToJpg($imageToConvert, $convertedFile)
    {
        $img = Image::make($imageToConvert)
            ->encode('jpg', 80)
            ->save($convertedFile);
        unlink($imageToConvert);
        return $img->dirname . '/' . $img->basename;
    }

    /**
     * Get image width
     * @param $image
     * @return mixed
     */
    public static function getImageWidth($image)
    {
        return Image::make($image)->width();
    }

    /**
     * Get image height
     * @param $image
     * @return mixed
     */
    public static function getImageHeight($image)
    {
        return Image::make($image)->height();
    }

    /**
     * Create folder
     * @param $path
     * @return bool
     */
    public static function createFolder($path)
    {
        return \File::makeDirectory($path, 0777);
    }

    /**
     * Upload files other than images
     * @param $document
     * @param $dir
     * @return string
     */
    public static function uploadDocuments($document, $dir, $fileName = '')
    {
        $date = new DateTime();
        $currentTimeStamp = $date->getTimestamp();

        if ($fileName == '') {
            $documentOriginalName = $currentTimeStamp . '_' . $document->getFilename() . '.' . $document->getClientOriginalExtension();
        } else {
            $documentOriginalName = $fileName . '.' . $document->getClientOriginalExtension();

            //Remove file first if exist
            if (file_exists($dir . $documentOriginalName)) {
                unlink($dir . $documentOriginalName);
            }
        }
        //Store file to folder
        $document->move($dir, $documentOriginalName);
        return $documentOriginalName;
    }

    /**
     * function for add http in url
     * @param $url
     * @return string
     */
    public static function addHttpToUrl($url)
    {
        if (!preg_match("~^(?:f|ht)tps?://~i", $url)) {
            return $url = "http://" . $url;
        } else {
            return $url;
        }
    }

    /**
     * @param $date
     * Format date as ago
     */
    public static function formatDateAgo($date)
    {
        if ($date) {
            return Carbon::createFromTimestamp(strtotime($date))->diffForHumans();
        } else {
            return $date;
        }
    }

    /**
     * Format Date
     * @param $date
     * @return formatted date
     */
    public static function formatDate($date, $not_available = true)
    {
        if ($date) {
            return date(config('app.date_format_php'), strtotime($date));
        } else {
            if ($not_available == false) {
                return '';
            }
            return '';
        }
    }

    /**
     * Format Date
     * @param $date
     * @return formatted date
     */
    public static function formatDateTime($date, $not_available = true)
    {
        if ($date) {
            return date(config('app.date_time_format_php'), strtotime($date));
        } else {
            if ($not_available == false) {
                return null;
            }
            return null;
        }
    }

    /**
     * Show error page
     * @return \Illuminate\Http\Response
     */
    public static function showErrorPage()
    {
        return response()->view('errors.error', [], 500);
    }

    public static function convertFilterDate($keyword)
    {
        $date = '';
        try {
            if (\Carbon\Carbon::createFromFormat(config('app.date_format_php'), $keyword) !== false) {
                $date = self::convertDate($keyword);
            }
        } catch (Exception $e) {
            $date = '';
        }
        return $date;
    }

    /**
     * function for display amount
     * @param $amount
     * @return int|string
     */
    public static function currency($amount)
    {
        if ($amount == '') {
            $amount = 0;
            $amount = setting('default_currency').''.number_format($amount, setting('default_currency_decimal_digits'));
        } elseif ($amount < 0) {
            $amount = -$amount;
            $amount = '-'.setting('default_currency').''.number_format($amount, setting('default_currency_decimal_digits'))  ;
        } else {
            $amount = setting('default_currency').''.number_format($amount, setting('default_currency_decimal_digits'))  ;
        }
        return $amount;
    }

    /**
     * function for remove .00 from amount
     * @param $price
     * @return bool|string
     */
    public static function formatDBAmount($price)
    {
        $price = substr($price, -3) == ".00" ? substr($price, 0, -3) : $price;
        return $price;
    }

    /**
     * function for delete directory
     * @param $dir
     * @return bool
     */
    public static function deleteDirectory($dir)
    {
        if (!file_exists($dir)) {
            return true;
        }

        if (!is_dir($dir)) {
            return unlink($dir);
        }

        foreach (scandir($dir) as $item) {
            if ($item == '.' || $item == '' || $item == '.gitignore') {
                continue;
            }

            if (!self::deleteDirectory($dir . DIRECTORY_SEPARATOR . $item)) {
                return false;
            }
        }
        return rmdir($dir);
    }

    /**
     * Function to generate randomkey
     * @param NA
     * @return random key
     */
    public static function generateRandomKey()
    {
        $salt = substr(sha1(uniqid(mt_rand(), true)), 0, 4);
        return substr(sha1($salt) . $salt, 5, 15);
    }

    /**
     * function for generate new file name
     * @param NA
     * @return Generated new file name
     */
    public static function generateuDynamicFileName()
    {
        return substr(self::generateRandomKey(), 0, 4) . '-' . substr(self::generateRandomKey(), 0, 4) . '-' . substr(self::generateRandomKey(), 0, 4) . '-' . substr(self::generateRandomKey(), 0, 4);
    }

    public static function onlyTwoDecimal($foo)
    {
        return number_format((float) $foo, 2, '.', '');
    }

    public static function getCodetype($val = null)
    {
        if (isset($val) && !empty($val)) {
            $val = trim($val);
            $conf = config('constant.discountCodeType');
            foreach ($conf as $key => $value) {
                if ($val == $value) {
                    return $key;
                }
            }
        }
    }

    public static function showCodeTypeValInFormate($val = null, $amount = null)
    {
        if (isset($val) && !empty($val)) {
            $val = trim($val);
            if ($val == 1) {
                return $amount . ' %';
            }
            if ($val == 2) {
                return static::currency($amount);
            }
        }
    }

    public static function getExtendetimeLine($val = null)
    {
        if (isset($val) && !empty($val)) {
            $val = trim($val);
            $conf = config('constant.extend_delivery');
            foreach ($conf as $key => $value) {
                if ($val == $value) {
                    return $key;
                }
            }
        }
    }

    /**
     * function for desciption popup
     * @param $str word count
     * @param $id saperator id
     * @return Generated new file name
     */

    public static function decriptionPopup($str, $id)
    {
        if (str_word_count(trim($str)) > 5) {
            return implode(' ', array_slice(explode(' ', $str), 0, 5)) . '..<a href="#" style="color:blue;" data-toggle="modal" data-target="#declaraion_heading_' . $id . '">Read more</a>';
        } else {
            if (strlen($str) > 80) {
                return substr($str, 0, 80) . '..<a href="#" style="color:blue;" data-toggle="modal" data-target="#declaraion_heading_' . $id . '">Read more</a>';
            }
            return $str;
        }
    }

    public static function sendSms($msg, $to)
    {
        $twilioAccountSid = setting("twilio_account_sid");
        $twilioAuthToken = setting("twilio_auth_token");
        $fromPhoneNumber = setting("twilio_phone_number");

        // Log the SMS attempt
        Log::info('Sending SMS', [
            'to' => $to,
            'message' => $msg,
            'from' => $fromPhoneNumber
        ]);

        // Build the cURL request
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://api.twilio.com/2010-04-01/Accounts/$twilioAccountSid/Messages.json");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'Body' => $msg,
            'From' => $fromPhoneNumber,
            'To' => $to,
        ]));
        curl_setopt($ch, CURLOPT_USERPWD, "$twilioAccountSid:$twilioAuthToken");

        // Execute the cURL request
        $response = curl_exec($ch);

        // Log the response from Twilio
        if (curl_errno($ch)) {
            Log::error('Twilio API error', ['error' => curl_error($ch)]);
        } else {
            Log::info('Twilio API response', ['response' => $response]);
        }

        // Close cURL session
        curl_close($ch);

        // Return the response
        return $response;
    }
    
    
    public static function sendFast2Sms($otp, $phone)
    {
        try {
            // Retrieve API Key and Sender ID from settings
            $api_key = setting('fast_2_sms_api_key'); // Fast2SMS API key
            $sender_id = setting('fast_2_sms_sender_id'); // Sender ID
            
            // Initialize HTTP client
            $client = new Client();

            // Fast2SMS API endpoint
            $url = 'https://www.fast2sms.com/dev/bulkV2';

            // Send POST request to Fast2SMS API
            $response = $client->post($url, [
                'headers' => [
                    'Authorization' => $api_key, // API key in the header
                ],
                'form_params' => [
                    'sender_id' => $sender_id, // Optional sender ID
                    'message' => "Your OTP is: $otp. Please do not share it with anyone.", // OTP message
                    'language' => 'english', // Language of the message
                    'route' => 'q', // Transactional route
                    'numbers' => $phone, // Recipient phone number
                ],
            ]);

            // Parse the response
            $responseBody = json_decode($response->getBody(), true);

            // Check response status
            if (isset($responseBody['return']) && $responseBody['return'] === true) {
                return true; // OTP sent successfully
            }

            // Log API response in case of failure
            \Log::error('Fast2SMS Error', ['response' => $responseBody]);
            return false;

        } catch (\Exception $e) {
            // Log exceptions
            \Log::error('Fast2SMS Exception', ['error' => $e->getMessage()]);
            return false;
        }
    }

    /**
     * function for send push notification
     * @param $id device token
     * @param $msg message tobe sent for push notification
     * @param $title title
     * @param $key key for API
     * @return Generated new file name
     */
    public static function sendNotification($id,$msg,$title,$key,$img=false,$orderid=false){
        if(setting('is_enable_one_signal')){
            $buttons = [

            ];
            $content = array(
                "en" => $msg
            );
            $headings = array(
                "en" => $title
            );
            $icon = url('site-assets/images/app/'.setting('app_logo'));
            if($orderid != false){
                $dataArr = array("order_id"=>$orderid,"title" => $title);
            }else{
                $dataArr = array("title" => $title);
            }
            $fields = array(
                'app_id' => setting('one_signal_app_id'),
                'included_segments' => array('All'),
                'include_player_ids' => $id,
                'data' => $dataArr,
                // 'big_picture' =>$img,
                'contents' => $content,
                'headings' => $headings,
                'buttons' => $buttons,
                'icon' => $icon
            );
            $fields = json_encode($fields);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8',
                                                    'Authorization: Basic '.setting('one_signal_key')));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_HEADER, FALSE);
            curl_setopt($ch, CURLOPT_POST, TRUE);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

            $response = curl_exec($ch);
            $httpStatus = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            return $httpStatus;

        }else{
            $fcm_tokens = array_unique($id);

            $image = $img;
            if($img == ''){
                $image = asset('site-assets/images/app/'.setting('app_logo'));
            }
            $title = $title ? $title : 'New Notification';
            $cleanedDescription = $msg ? strip_tags($msg) : 'New Notification';
            $description = mb_substr($cleanedDescription, 0, 100, 'UTF-8');
    
            $projectId = setting('firebase_project_id');
            $credentialsFilePath = Storage::path('/public/firebase/firebase_credentials.json');

            if (!setting('firebase_json_file')) {
                // The file not exists
                $httpCode = 401;
                return $httpCode;
            }

            $client = new GoogleClient();
            $client->setAuthConfig($credentialsFilePath);
            $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
            $client->refreshTokenWithAssertion();
            $token = $client->getAccessToken();
    
            $access_token = $token['access_token'];
    
            $headers = [
                "Authorization: Bearer $access_token",
                'Content-Type: application/json',
            ];
    
            $httpCode = 200;
            $messageArr = [];
    
            foreach ($fcm_tokens as $fcm_token) {
                if (!in_array($fcm_token, $messageArr)) {
                    array_push($messageArr, $fcm_token);
                    $data = [
                        "message" => [
                            "token" => $fcm_token,
                            // Data for send params
                            "data" => [
                                "post_id" => (string) $orderid,
                                "title" => (string) $title,
                                "body" => (string) $description,
                                "click_action" => "FLUTTER_NOTIFICATION_CLICK"
                                // "image" => (string) $image 
                            ],
                            // iOS-specific notification with image
                            "apns" => [
                                "payload" => [
                                    "aps" => [
                                        "mutable-content" => 1,
                                        // "imageUrl" => (string) $image,
                                        "post_id" => (string) $orderid,
                                        "click_action" => "FLUTTER_NOTIFICATION_CLICK"
                                        // 'image' => (string) $image, 
                                        // 'large_icon' => (string) $image,
                                        // 'big_picture' => (string) $image
                                    ],
                                ],
                            ],
                        ]
                    ];
                    $payload = json_encode($data);
            
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send");
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                    curl_setopt($ch, CURLOPT_VERBOSE, true);
                    $response = curl_exec($ch);
                    curl_close($ch);
                    
                    $httpCode === 200;
                }
            }
            
            return $httpCode;
        
        }
    }


    // chat gpt translate
    public static function translate($text, $targetLanguage)
    {
        $client = new Client();
        $url = 'https://api.openai.com/v1/completions';
        $apiKey = setting('chat_gpt_api_key');
        $params = [
            "model" => "text-davinci-003",
            'prompt' => "Translate this into " . $targetLanguage . " :\n\n\n" . $text . "\n\n\n",
            "temperature" => 0.3,
            "max_tokens" => 100,
        ];

        try {
            $response = $client->request('POST', $url, [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Authorization' => 'Bearer ' . $apiKey,
                ],
                'json' => $params,
            ]);

            $statusCode = $response->getStatusCode();
            if ($statusCode === 200) {
                $body = $response->getBody();
                $decodedBody = json_decode($body, true);
                $generatedText = $decodedBody['choices'][0]['text'];
                $response_data = array(
                    'status'=>true,
                    'data'=>$generatedText,
                    'message'=>__('lang.message_data_translated_successfully')
                );
                return $response_data;
            } else {
                $response_data = array(
                    'status'=>false,
                    'data'=>[],
                    'message'=>"Unexpected response status - " . $statusCode
                );
                // Handle non-200 response status here
                return $response_data;
            }
        } catch (RequestException $e) {
            // Handle request exceptions here (e.g., network errors, API errors)
            if ($e->hasResponse()) {
                $response = $e->getResponse();
                $body = $response->getBody();
                $error = json_decode($body, true);
                $response_data = array(
                    'status'=>false,
                    'data'=>[],
                    'message'=>$error['error']['message']
                );
                return $response_data;
            } else {
                $response_data = array(
                    'status'=>false,
                    'data'=>[],
                    'message'=>$e->getMessage()
                );
                return $response_data;
            }
        } catch (GuzzleException $e) {
            // Handle Guzzle exceptions here
            $response_data = array(
                'status'=>false,
                'data'=>[],
                'message'=>$e->getMessage()
            );
            return $response_data;
        }
    }


// google translate
    public static function googleTranslation($text, $targetLanguage)
    {
        $apiKey = "AIzaSyD9XbT4h49yaEf3DnnheqFbmpENH4I8mAM";

        $apiUrl = "https://translation.googleapis.com/language/translate/v2?key=$apiKey";

        $data = array(
            "q" => [$text],
            "target" => $targetLanguage
        );

        $ch = curl_init($apiUrl);

        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);

        curl_close($ch);

        $result = json_decode($response, true);

        if ($result && isset($result['data']['translations'][0]['translatedText'])) {
            $translation = $result['data']['translations'][0]['translatedText'];
            $response_data = array(
                'status'=>true,
                'data'=>$translation,
                'message'=>__('lang.message_data_translated_successfully')
            );
            return $response_data;
        } else {
            $response_data = array(
                'status'=>false,
                'data'=>[],
                'message'=>"Unexpected response status"
            );
            return $response_data;
        }

    }

    /* Clears the authenticated user's cart.
    *
    * @return void
    */
    static function clearAuthUserCart()
    {
        if (auth()->check()) {
            $user = auth()->user();
            $user_id = Auth::user()->id;
            Cart::where('user_id',$user_id)->delete();
            Session::put('total_cart', 0);
            Session()->forget('coupon_id');
            Session()->forget('is_coupon_applied');
            Session()->forget('coupon_code');
            Session()->forget('promotional_disount');
        }
    }
    function isFirebaseSMSEnabled()
    {

        $firebaseSettingsKeys = [
            'firebase_api_key',
            'firebase_auth_domain',
            'firebase_project_id',
            'firebase_storage_bucket',
            'firebase_messaging_sender_id',
            'firebase_app_id',
            'firebase_measurement_id',
        ];


        foreach ($firebaseSettingsKeys as $key) {
            $value = DB::table('app_settings')->where('key', $key)->value('value');
            if (empty($value)) {
                return [
                    'enabled' => false,
                    'message' => 'Firebase is disabled due to missing credentials. Please enter the all credentials to enable Firebase.'
                ];
            }
        }
        $this->handleFirebaseSMS();

        return [
            'enabled' => true,
            'message' => 'Firebase is enabled.'
        ];
    }

    function isTwilioEnabled()
    {

        $twilioSettingsKeys = [
            'twilio_account_sid',
            'twilio_auth_token',
            'twilio_phone_number',
        ];


        foreach ($twilioSettingsKeys as $key) {
            $value = AppSetting::where('key', $key)->value('value');
            if (empty($value)) {
                return [
                    'enabled' => false,
                    'message' => 'Twilio is disabled due to missing credentials. Please enter the credentials to enable Twilio.'
                ];
            }
        }
        $this->handleTwilio();

        return [
            'enabled' => true,
            'message' => 'Twilio is enabled.'
        ];
    }


    function isFirebaseNotificationsEnabled()
    {

        $firebaseNotificationKeys = [
            'firebase_api_key',
            'firebase_messaging_sender_id',
            'firebase_project_id',
            'firebase_app_id',
            'firebase_messaging_vapid_publickey',
        ];


        foreach ($firebaseNotificationKeys as $key) {
            $value = AppSetting::where('key', $key)->value('value');
            if (empty($value)) {
                return [
                    'enabled' => false,
                    'message' => 'Firebase notifications are disabled due to missing credentials. Please enter the credentials to enable Firebase notifications.'
                ];
            }
        }
        $this->handleFirebaseNotification();
        return [
            'enabled' => true,
            'message' => 'Firebase notifications are enabled.'
        ];
    }
    function isOneSignalEnabled()
    {

        $oneSignalKeys = [
            'onesignal_app_id',
            'onesignal_rest_api_key',
            'onesignal_user_auth_key',
        ];


        foreach ($oneSignalKeys as $key) {
            $value = AppSetting::where('key', $key)->value('value');
            if (empty($value)) {
                return [
                    'enabled' => false,
                    'message' => 'OneSignal is disabled due to missing credentials. Please enter the credentials to enable OneSignal.'
                ];
            }
        }
        $this->handleOneSignalNotification();
        return [
            'enabled' => true,
            'message' => 'OneSignal is enabled, and Firebase notifications have been disabled.'
        ];
    }

    static function handleTestMode()
    {

        $testMode = AppSetting::where('key', 'enable_test_mode')->value('value');

        if ($testMode) {

            AppSetting::where('key', 'enable_firebase_message')->update(['value' => false]);


            AppSetting::where('key', 'is_enable_twilio')->update(['value' => false]);

            return [
                'test_mode' => true,
                'message' => 'Test mode is enabled. Firebase notifications and Twilio have been disabled.'
            ];
        }

        return [
            'test_mode' => false,
            'message' => 'Test mode is not enabled.'
        ];
    }

    static function handleTwilio()
    {

        $twilio = AppSetting::where('key', 'is_enable_twilio')->value('value');

        if ($twilio) {

            AppSetting::where('key', 'enable_firebase_message')->update(['value' => false]);


            AppSetting::where('key', 'enable_test_mode')->update(['value' => false]);

            return [
                'twilio_mode' => true,
                'message' => 'Twilio is enabled. Firebase and TestMode have been disabled.'
            ];
        }

        return [
            'twilio_mode' => false,
            'message' => 'Twilio is not enabled.'
        ];
    }

    static function handleFirebaseSMS()
    {

        $firebase_message = AppSetting::where('key', 'enable_firebase_message')->value('value');

        if ($firebase_message) {

            AppSetting::where('key', 'is_enable_twilio')->update(['value' => false]);
            AppSetting::where('key', 'enable_test_mode')->update(['value' => false]);

            return [
                'firebase_sms' => true,
                'message' => 'Firebase SMS is enabled. Twilio and TestMode have been disabled.'
            ];
        }

        return [
            'firebase_sms' => false,
            'message' => 'Twilio is not enabled.'
        ];
    }

    static function handleFirebaseNotification()
    {
        $firebaseNotification = AppSetting::where('key', 'is_enable_firebase_notification')->value('value');

        if ($firebaseNotification) {

            AppSetting::where('key', 'is_enable_one_signal')->update(['value' => false]);
            return [
                'firebase_notification' => true,
                'message' => 'Firebase Notification is enabled. One signal is disabled.'
            ];
        }
        return [
            'firebase_notification' => false,
            'message' => 'Twilio is not enabled.'
        ];
    }
    static function handleOneSignalNotification()
    {

        $oneSignalNotification = AppSetting::where('key', 'is_enable_one_signal')->value('value');

        if ($oneSignalNotification) {

            AppSetting::where('key', 'is_enable_firebase_notification')->update(['value' => false]);
            return [
                'onesignal_notification' => true,
                'message' => 'One Signal Notification is enabled. Firebase is disabled.'
            ];
        }
        return [
            'onesignal_notification' => false,
            'message' => 'One signal is not enabled.'
        ];
    }


    /**
     * Upload file with original name
    **/
    public static function uploadFilesAfterResizeCompressOriginalName($file,$folderName) {
        try {
            $fileName = $file->getClientOriginalName();
            $imageName = "";
            if($fileName!=''){
                $finalName = "";
                $explodeFileName = explode(".",$fileName);
                if(isset($explodeFileName[0]) && $explodeFileName[0]!=''){
                    $finalName = Str::slug($explodeFileName[0],'-');
                    $checkExist = ProductImage::where('image',$finalName.'.webp')->first();
                    if($checkExist){
                        $finalName = Str::slug($explodeFileName[0].'-'.Str::random(5).'-'.Str::random(5), '-');
                    }
                }
                $imageName = $finalName.'.webp';
            }
            
            if($file->extension()==='gif'){
                $path1 = public_path('app-assets/'.$folderName.'/products/');
                $image = $file;
                $image->move($path1, $imageName);            
            }else{
                $path1 = public_path('app-assets/'.$folderName.'/products/');
                $image = $file;
                $image->move($path1, $imageName); 
            }            
            return ['status' => true, 'message' => config('constant.common.messages.success_image'),'file_name'=>$imageName];
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
    
    
    public static function getTaxAmount(float $amount, float $percentage): float
    {
        return round(($amount * $percentage) / 100, 2);
    }


    public static function send2FactorSms($otp,$to){

        $curl = curl_init();

        $apiKey = setting('2_factor_api_key');
        $url = "https://2factor.in/API/V1/{$apiKey}/SMS/{$to}/{$otp}/OTP1";

        // Set cURL options
        curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        // Execute cURL request
        $response = curl_exec($curl);
        curl_close($curl);
        $statusCode = 201;

        return $statusCode;
    }


    // for convert key
    public static function maskApiKey($key) {
        if($key && strlen($key) >= 5){
            return str_repeat('*', strlen($key) - 5) . substr($key, -5);
        }else{
            return '';
        }
    }


    public static function getLimitedProductName($name){
        $maxCharacters = 35;
        if (strlen($name) > $maxCharacters) {
            $shortenedName = substr($name, 0, $maxCharacters - 3) . "...";
        } else {
            $shortenedName = $name;
        }

        return $shortenedName;
    }


    public static function getStatusType()
    {
        return [
            'active' => __('lang.admin_active'),
            'deactive' => __('lang.admin_deactive'),
        ];
    }

    public static function getCouponType()
    {
        return [
            'Fixed' => __('lang.admin_coupon_type_fixed'),
            'Percent' => __('lang.admin_coupon_type_percent'),
        ];
    }

}
?>