<?php

namespace App\Exports;

use App\Models\OrderProductsDelivery;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;

class RevenueExport implements FromCollection, WithHeadings, ShouldAutoSize, WithEvents
{
    use Exportable;

    public function collection()
    {
        $revenueData = OrderProductsDelivery::getRevenueReportToExcel();
        return $this->transformData($revenueData);
    }

    public function headings(): array
    {
        return [
            'ID',
            'Order ID',
            'User Name',
            'User Email',
            'User Phone',
            'Driver Name',
            'Product Name',
            'Order Product Quantity',
            'Order Product Total',
            'Delivery Date',
            'Order Status',
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $event->sheet->getDelegate()->getStyle('A1:K1')->applyFromArray([
                    'font' => [
                        'bold' => true,
                    ],
                    'alignment' => [
                        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                    ],
                    'fill' => [
                        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_GRADIENT_LINEAR,
                        'rotation' => 90,
                        'startColor' => ['argb' => 'FFA0A0A0'],
                        'endColor' => ['argb' => 'FFFFFFFF'],
                    ],
                ]);
            },
        ];
    }

    private function transformData(Collection $revenueData): Collection
    {
        return $revenueData->map(function ($row) {
            return [
                'ID' => $row->id,
                'Order ID' => $row->order_id,
                'User Name' => $row->user_name,
                'User Email' => $row->user_email,
                'User Phone' => $row->user_phone,
                'Driver Name' => $row->driver_name,
                'Product Name' => $row->product_name,
                'Order Product Quantity' => $row->order_product_quantity,
                'Order Product Total' => $row->order_product_total_delivery_amount,
                'Delivery Date' => $row->delivery_date,
                'Order Status' => $row->order_status,
            ];
        });
    }
}
