<?php


namespace App\Exports;

use App\Models\Order;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class OrdersExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    public function collection()
    {
        $orders = Order::getExportData(); // Adjust based on your logic

        return $this->transformData($orders);
    }

    public function headings(): array
    {
        return [
            'ID',
            'User Name',
            'User Email',
            'Order Status ID',
            'Delivery Address',
            'Payment Status',
            'Subtotal',
            'Final Amount',
            'Tax',
            'Payment Method',
            'Timeslot Name',
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                // Adjust column widths based on your content
                $event->sheet->getDelegate()->getColumnDimension('A')->setWidth(15);
                $event->sheet->getDelegate()->getColumnDimension('B')->setWidth(20);
                // ... Adjust other columns accordingly
            },
        ];
    }

    private function transformData(Collection $orders): Collection
    {
        return $orders->map(function ($order) {
            return [
                'ID' => $order->id,
                'User Name' => $order->user_name,
                'User Email' => $order->user_email,
                'Order Status ID' => $order->order_status,
                'Delivery Address' => $order->delivery_address,
                'Payment Status' => $order->payment_status,
                'Subtotal' => $order->subtotal,
                'Final Amount' => $order->final_amount,
                'Tax' => $order->tax,
                'Payment Method' => $order->payment_method,
                'Timeslot Name' => $order->timeslot_name,
            ];
        });
    }
}