<?php $__env->startSection('title'); ?>
    <?php echo e(__('Features')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-striped"
                                    id="table_list" data-toggle="table" data-url="<?php echo e(route('package-features.show',1)); ?>"
                                    data-click-to-select="true" data-side-pagination="server" data-pagination="true"
                                    data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true"
                                    data-search-align="right" data-toolbar="#toolbar" data-show-columns="true"
                                    data-show-refresh="true" data-trim-on-search="false" data-responsive="true"
                                    data-sort-name="id" data-sort-order="asc" data-pagination-successively-size="3"
                                    data-query-params="queryParams">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th scope="col" data-field="id" data-align="center" data-sortable="true"> <?php echo e(__('ID')); ?></th>
                                            <th scope="col" data-field="name" data-align="center" data-sortable="true"> <?php echo e(__('Name')); ?> </th>
                                            <?php if(has_permissions('update', 'package-feature')): ?>
                                                <th scope="col" data-field="status" data-sortable="true" data-align="center" data-width="5%" data-formatter="enableDisableSwitchFormatter"> <?php echo e(__('Enable/Disable')); ?></th>
                                            <?php else: ?>
                                                <th scope="col" data-field="status" data-sortable="true" data-align="center" data-width="5%" data-formatter="yesNoStatusFormatter"> <?php echo e(__('Is Active ?')); ?></th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        function queryParams(p) {
            return {
                sort: p.sort,
                order: p.order,
                offset: p.offset,
                limit: p.limit,
                search: p.search,

            };
        }

        function chk(checkbox) {
            if (checkbox.checked) {
                active(event.target.id);
            } else {
                disable(event.target.id);
            }
        }
    </script>

    <script>
        function disable(id) {
            $.ajax({
                url: "<?php echo e(route('package-features.status-update')); ?>",
                type: "POST",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>",
                    "id": id,
                    "status": 0,
                },
                cache: false,
                success: function(result) {
                    let text = '<?php echo e(trans("Status Updated Successfully")); ?>';
                    if (result.error == false) {
                        Toastify({
                            text: text,
                            duration: 6000,
                            close: !0,
                            backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)"
                        }).showToast();
                        $('#table_list').bootstrapTable('refresh');
                    } else {
                        Toastify({
                            text: result.message,
                            duration: 6000,
                            close: !0,
                            backgroundColor: '#dc3545' //"linear-gradient(to right, #dc3545, #96c93d)"

                        }).showToast();
                        $('#table_list').bootstrapTable('refresh');
                    }

                },
                error: function(error) {
                    Toastify({
                        text: result.message,
                        duration: 6000,
                        close: !0,
                        backgroundColor: '#dc3545' //"linear-gradient(to right, #dc3545, #96c93d)"
                    }).showToast();
                }
            });
        }

        function active(id) {
            $.ajax({
                url: "<?php echo e(route('package-features.status-update')); ?>",
                type: "POST",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>",
                    "id": id,
                    "status": 1,
                },
                cache: false,
                success: function(result) {
                    if (result.error == false) {
                        let text = '<?php echo e(trans("Status Updated Successfully")); ?>';
                        Toastify({
                            text: text,
                            duration: 6000,
                            close: !0,
                            backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)"
                        }).showToast();
                        $('#table_list').bootstrapTable('refresh');
                    } else {
                        Toastify({
                            text: result.message,
                            duration: 6000,
                            close: !0,
                            backgroundColor: '#dc3545' //"linear-gradient(to right, #dc3545, #96c93d)"
                        }).showToast();
                        $('#table_list').bootstrapTable('refresh');
                    }

                },
                error: function(error) {
                    Toastify({
                        text: result.message,
                        duration: 6000,
                        close: !0,
                        backgroundColor: '#dc3545' //"linear-gradient(to right, #dc3545, #96c93d)"
                    }).showToast();
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wrteam-dev/ebroker/resources/views/packages/features/index.blade.php ENDPATH**/ ?>