<?php

use App\Models\Advertisement;
use App\Models\Customer;
use App\Models\Favourite;
use App\Models\InterestedUser;
use App\Models\Language;
use App\Models\parameter;

use App\Models\Setting;
use App\Models\UserPurchasedPackage;
use App\Models\Usertokens;
use App\Models\user_reports;

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use kornrunner\Blurhash\Blurhash;
use Intervention\Image\ImageManagerStatic as Image;


if (!function_exists('system_setting')) {

    function system_setting($type)
    {

        $db = Setting::where('type', $type)->first();
        return (isset($db)) ? $db->data : '';
    }
}

function form_submit($data = '', $value = '', $extra = '')
{
    $defaults = array(
        'type' => 'submit',
        'name' => is_array($data) ? '' : $data,
        'value' => $value
    );

    return '<input ' . _parse_form_attributes($data, $defaults) . _attributes_to_string($extra) . " />\n";
}
function _parse_form_attributes($attributes, $default)
{
    if (is_array($attributes)) {
        foreach ($default as $key => $val) {
            if (isset($attributes[$key])) {
                $default[$key] = $attributes[$key];
                unset($attributes[$key]);
            }
        }

        if (count($attributes) > 0) {
            $default = array_merge($default, $attributes);
        }
    }

    $att = '';

    foreach ($default as $key => $val) {
        if ($key === 'value') {
            $val = ($val);
        } elseif ($key === 'name' && !strlen($default['name'])) {
            continue;
        }

        $att .= $key . '="' . $val . '" ';
    }

    return $att;
}


// ------------------------------------------------------------------------

if (!function_exists('_attributes_to_string')) {
    /**
     * Attributes To String
     *
     * Helper function used by some of the form helpers
     *
     * @param	mixed
     * @return	string
     */
    function _attributes_to_string($attributes)
    {
        if (empty($attributes)) {
            return '';
        }

        if (is_object($attributes)) {
            $attributes = (array) $attributes;
        }

        if (is_array($attributes)) {
            $atts = '';

            foreach ($attributes as $key => $val) {
                $atts .= ' ' . $key . '="' . $val . '"';
            }

            return $atts;
        }

        if (is_string($attributes)) {
            return ' ' . $attributes;
        }

        return FALSE;
    }
}

if (!function_exists('send_push_notification')) {
    //send Notification
    function send_push_notification($registrationIDs = array(), $fcmMsg = '', $send_payload = NULL)
    {
        $get_fcm_key = DB::table('settings')->select('data')->where('type', 'fcm_key')->first();
        $fcm_key = $get_fcm_key->data;

        $registrationIDs_chunks = array_chunk($registrationIDs, 1000);

        $unregisteredIDs = array(); // Array to store unregistered FCM IDs
        if (!count($registrationIDs_chunks)) {
            return false;
        }
        foreach ($registrationIDs_chunks as $registrationIDsChunk) {

            if ($send_payload == 1) {
                $fcmFields = array(
                    'registration_ids' => $registrationIDsChunk, // expects an array of ids
                    'priority' => 'high',

                    'data' => $fcmMsg
                );
            } else {
                $fcmFields = array(
                    'registration_ids' => $registrationIDsChunk, // expects an array of ids
                    'priority' => 'high',
                    'notification' => $fcmMsg,
                    'data' => $fcmMsg
                );
            }
            $headers = array(
                'Authorization: key=' . $fcm_key,
                'Content-Type: application/json'
            );

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fcmFields));
            $get_result = curl_exec($ch);

            curl_close($ch);
            $result = json_decode($get_result, true);

            // Check for unregistered FCM IDs in the response
            if (isset($result['results'])) {
                foreach ($result['results'] as $index => $response) {
                    // dd($response);
                    if (isset($response['error']) && $response['error'] == 'NotRegistered') {
                        // dd("in");
                        $unregisteredIDs[] = $registrationIDsChunk[$index];
                    }
                }
            }
        }

        if (count($unregisteredIDs)) {

            $users = Usertokens::whereIn('fcm_id', $unregisteredIDs)->delete();
        }

        return $result;
    }
}

if (!function_exists('get_countries_from_json')) {
    function get_countries_from_json()
    {
        $country =  json_decode(file_get_contents(public_path('json') . "/cities.json"), true);

        $tempRow = array();
        foreach ($country['countries'] as $row) {
            $tempRow[] = $row['country'];
        }
        return $tempRow;
    }
}

if (!function_exists('get_states_from_json')) {
    function get_states_from_json($country)
    {


        $state =  json_decode(file_get_contents(public_path('json') . "/cities.json"), true);

        $tempRow = array();
        foreach ($state['countries'] as $row) {
            // echo $row;
            if ($row['country'] == $country) {
                $tempRow = $row['states'];
            }
        }

        return $tempRow;
    }
}


if (!function_exists('parameterTypesByCategory')) {
    function parameterTypesByCategory($category_id)
    {


        $parameter_types = DB::table('categories')->select('parameter_types')->where('categories.id', $category_id)->first();

        $tempRow = array();

        $parameterTypes = explode(',', $parameter_types->parameter_types);

        foreach ($parameterTypes as $key => $row) {
            $par_name = parameter::find($row);
            $tempRow['parameters'][$key] = $par_name;

            // $tempRow['parameters'][$key]['type'] = $par_name->type_of_parameter;
        }
        return  $tempRow;
    }
}
function update_subscription($user_id)
{
    DB::enableQueryLog();
    $users_packages = UserPurchasedPackage::with('package')->with('customer')->where('modal_id', $user_id);
    $result
        = $users_packages->get();
    foreach ($result as $key => $row) {


        $endDate = Carbon::parse($row->end_date, 'UTC')->startOfDay(); // Parse the date with UTC time zone and set time to start of the day
        $currentDate = Carbon::now()->startOfDay(); // Set current date time to start of the day

        $diffInDays = $currentDate->diffInDays($endDate, false); // Use 'false' parameter to get absolute difference

        if ($diffInDays <= 0) {
            $package = UserPurchasedPackage::find($row->id);
            $package->prop_status = 0;
            $package->adv_status = 0;
            $package->save();
        }

        $package_count
            = $users_packages->where('prop_status', 1)->orWhere('adv_status', 1)->count();
        if ($package_count == 0) {
            $Customer = Customer::find($row->customer->id);

            $Customer->subscription = 0;
            if ($row->package->type == "premium_user") {
                $Customer->is_premium = 0;
            }

            $Customer->update();
        }
    }
    // if ($data) {
    // }
}
function get_hash($img)
{

    $image_make = Image::make($img);
    $width = $image_make->width();
    $height = $image_make->height();

    $pixels = [];
    for ($y = 0; $y < $height; ++$y) {
        $row = [];
        for ($x = 0; $x < $width; ++$x) {
            $colors = $image_make->pickColor($x, $y);

            $row[] = [$colors[0], $colors[1], $colors[2]];
        }
        $pixels[] = $row;
    }

    $components_x = 4;
    $components_y = 3;
    $hash =  Blurhash::encode($pixels, $components_x, $components_y);
    //  "ll";
    return $hash;
}
if (!function_exists('form_hidden')) {
    /**
     * Hidden Input Field
     *
     * Generates hidden fields. You can pass a simple key/value string or
     * an associative array with multiple values.
     *
     * @param	mixed	$name		Field name
     * @param	string	$value		Field value
     * @param	bool	$recursing
     * @return	string
     */
    function form_hidden($name, $value = '', $recursing = FALSE)
    {
        static $form;

        if ($recursing === FALSE) {
            $form = "\n";
        }

        if (is_array($name)) {
            foreach ($name as $key => $val) {
                form_hidden($key, $val, TRUE);
            }

            return $form;
        }

        if (!is_array($value)) {
            $form .= '<input type="hidden" name="' . $name . '" value="' . ($value) . "\" />\n";
        } else {
            foreach ($value as $k => $v) {
                $k = is_int($k) ? '' : $k;
                form_hidden($name . '[' . $k . ']', $v, TRUE);
            }
        }

        return $form;
    }
}
if (!function_exists('form_close')) {
    /**
     * Form Close Tag
     *
     * @param	string
     * @return	string
     */
    function form_close($extra = '')
    {
        return '</form>' . $extra;
    }
}
function get_property_details($result, $current_user = NULL)
{
    $rows = array();
    $tempRow = array();
    //return $result;
    $count = 1;
    $rows1 = array();
    $tempRow1 = array();
    //return $result;
    $count1 = 1;
    // if (!$result->isEmpty()) {
    // print_r($result->toArray());
    foreach ($result as $row) {
        // print_r($row->user->toArray());

        $customer = $row->customer;
        $user = $row->user->first();

        if ($customer && $row->added_by != 0) {
            $tempRow['customer_name'] = $customer->name;
            $tempRow['email'] = $customer->email;
            $tempRow['mobile'] = $customer->mobile;

            $tempRow['profile'] = $customer->profile;
            $tempRow['client_address'] = $customer->address;
        } else if ($row->added_by == 0) {


            $mobile = Setting::where('type', 'company_tel1')->pluck('data');
            $email = Setting::where('type', 'company_email')->pluck('data');



            $tempRow['customer_name'] = "Admin";
            $tempRow['email'] = $email[0];
            $tempRow['mobile'] = $mobile[0];

            $tempRow['client_address'] = $row->client_address;
        }

        $tempRow['id'] = $row->id;
        $tempRow['slug_id'] = $row->slug_id;
        $tempRow['title'] = $row->title;
        $tempRow['price'] = $row->price;
        $tempRow['category'] = $row->category;

        $tempRow['description'] = $row->description;
        $tempRow['address'] = $row->address;







        if ($row->propery_type == 0) {
            $tempRow['property_type'] = "sell";
        } elseif ($row->propery_type == 1) {
            $tempRow['property_type'] = "rent";
        } elseif ($row->propery_type == 2) {
            $tempRow['property_type'] = "sold";
        } elseif ($row->propery_type == 3) {
            $tempRow['property_type'] = "Rented";
        }



        $tempRow['title_image'] = $row->title_image;

        $tempRow['title_image_hash'] = $row->title_image_hash != '' ? $row->title_image_hash : '';
        $tempRow['threeD_image'] = $row->threeD_image;

        $tempRow['post_created'] = $row->created_at->diffForHumans();
        $tempRow['gallery'] = $row->gallery;
        $tempRow['total_view'] = $row->total_click;
        $tempRow['status'] = $row->status;
        $tempRow['state'] = $row->state;
        $tempRow['city'] = $row->city;
        $tempRow['country'] = $row->country;
        $tempRow['latitude'] = $row->latitude;
        $tempRow['longitude'] = $row->longitude;
        $tempRow['added_by'] = $row->added_by;
        $tempRow['video_link'] = $row->video_link;
        $tempRow['rentduration'] = ($row->rentduration != '') ? $row->rentduration : "Monthly";
        $tempRow['meta_title'] = $row->meta_title;
        $tempRow['meta_description'] = $row->meta_description;
        $tempRow['meta_keywords'] = $row->meta_keywords;
        $tempRow['meta_image'] = $row->meta_image;
        $tempRow['is_premium'] = $row->is_premium ? true : false;


        $tempRow['assign_facilities'] = [];
        foreach ($row->assignfacilities as $facility) {
            $tempRow['assign_facilities'][] = [
                'id' => $facility->id,
                'property_id' => $facility->property_id,
                'facility_id' => $facility->facility_id,
                'distance' => $facility->distance,
                'created_at' => $facility->created_at,
                'updated_at' => $facility->updated_at,
                'name' => $facility->outdoorfacilities->name,
                'image' => $facility->outdoorfacilities->image,
            ];
        }


        $promoted = Advertisement::where('property_id', $row->id)->first();

        if ($promoted) {
            $tempRow['promoted'] = true;
        } else {
            $tempRow['promoted'] = false;
        }
        $interested_users = array();
        $favourite_users = array();
        $s = '';
        foreach ($row->favourite as $favourite_user) {

            if ($favourite_user->property_id == $row->id) {

                array_push($favourite_users, $favourite_user->user_id);
                $s .= $favourite_user->user_id . ',';
            }
        }

        foreach ($row->interested_users as $interested_user) {

            if ($interested_user->property_id == $row->id) {

                array_push($interested_users, $interested_user->customer_id);
                $s .= $interested_user->user_id . ',';
            }
        }


        $favourite = Favourite::where('property_id', $row->id)->where('user_id', $current_user)->get();

        $interest = InterestedUser::where('property_id', $row->id)->where('customer_id', $current_user)->get();

        $report_count = user_reports::where('property_id', $row->id)->where('customer_id', $current_user)->get();


        if (count($report_count) != 0) {

            $tempRow['is_reported'] = true;
        } else {
            $tempRow['is_reported'] = false;
        }


        if (count($favourite) != 0) {
            $tempRow['is_favourite'] = 1;
        } else {
            $tempRow['is_favourite'] = 0;
        }

        if (count($interest) != 0) {
            $tempRow['is_interested'] = 1;
        } else {
            $tempRow['is_interested'] = 0;
        }
        $tempRow['favourite_users'] = $favourite_users;
        $tempRow['interested_users'] = $interested_users;

        $tempRow['total_interested_users'] = count($interested_users);
        $tempRow['total_favourite_users'] = count($favourite_users);


        $arr = [];
        $arr1 = [];

        if ($row->advertisement) {
            $tempRow['advertisement'] = $row->advertisement;
        }
        // print_r($row->parameters->toArray());
        $tempRow['parameters'] = [];

        foreach ($row->parameters as $res) {
            if (is_string($res->pivot->value) && is_array(json_decode($res->pivot->value, true))) {
                $value = json_decode($res->pivot->value, true);
            } else {
                if ($res->type_of_parameter == "file") {
                    if ($res->pivot->value == "null") {
                        $value = "";
                    } else {
                        $value = url('') . config('global.IMG_PATH') . config('global.PARAMETER_IMG_PATH') . '/' .  $res->pivot->value;
                    }
                } else {
                    if ($res->pivot->value == "null") {
                        $value = "";
                    } else {
                        $value = $res->pivot->value;
                    }
                }
            }

            $parameter = [
                'id' => $res->id,
                'name' => $res->name,
                'type_of_parameter' => $res->type_of_parameter,
                'type_values' => $res->type_values,
                'image' => $res->image,
                'value' => $value,
            ];
            array_push($tempRow['parameters'], $parameter);
        }


        $rows[] = $tempRow;
        $parameters[] = $arr;
        $count++;
    }
    return $rows;
}
function get_language()
{
    return Language::get();
}
function get_unregistered_fcm_ids($registeredIDs = array())
{

    // Convert the arrays to lowercase for case-insensitive comparison
    $registeredIDsLower = array_map('strtolower', $registeredIDs);



    // Retrieve the FCM IDs from the 'usertoken' table
    $fcmIDs = Usertokens::pluck('fcm_id')->toArray();

    // Now you have an array ($fcmIDs) containing all the FCM IDs from the 'usertoken' table

    $allIDsLower = array_map('strtolower', $fcmIDs);


    // Use array_diff to find the FCM IDs that are not registered
    $unregisteredIDsLower = array_diff($allIDsLower, $registeredIDsLower);
    // dd($unregisteredIDsLower);


    // Convert the IDs back to their original case
    $unregisteredIDs = array_map('strtoupper', $unregisteredIDsLower);
    Usertokens::WhereIn('fcm_id', $fcmIDs)->delete();
}
function handleFileUpload($request, $key, $destinationPath, $filename)
{
    if ($request->hasFile($key)) {
        $profile = $request->file($key);
        $profile->move($destinationPath, $filename);
        $value = $filename;

        // Delete the old file if it exists
        $oldFilePath = public_path($destinationPath . '/' . $value);
        if (file_exists($oldFilePath)) {
            unlink($oldFilePath);
        }

        return $value;
    }

    return null;
}
function get_url_contents($url)
{
    $crl = curl_init();

    curl_setopt($crl, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)');
    curl_setopt($crl, CURLOPT_URL, $url);
    curl_setopt($crl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($crl, CURLOPT_CONNECTTIMEOUT, 5);

    $ret = curl_exec($crl);
    curl_close($crl);
    return $ret;
}

if (!function_exists('generateUniqueSlug')) {
    function generateUniqueSlug($title, $model, $originalSlug = null)
    {
        // Convert title to slug format if $originalSlug is not provided
        if (!$originalSlug) {
            $originalSlug = Str::slug($title);
        } else {
            // Convert $originalSlug to slug format if it contains spaces
            $originalSlug = Str::slug($originalSlug);
        }

        // Check uniqueness in categories
        $existingCategorySlugs = \App\Models\Category::where('slug_id', $originalSlug)->pluck('slug_id');

        // Check uniqueness in articles
        $existingArticleSlugs = \App\Models\Article::where('slug_id', $originalSlug)->pluck('slug_id');

        // Check uniqueness in properties
        $existingPropertySlugs = \App\Models\Property::where('slug_id', $originalSlug)->pluck('slug_id');

        // Combine all existing slugs
        $existingSlugs = $existingCategorySlugs->merge($existingArticleSlugs)->merge($existingPropertySlugs);

        if ($existingSlugs->contains($originalSlug)) {
            $counter = 1;

            do {
                $slug = $originalSlug . '-' . $counter;
                $counter++;
            } while ($existingSlugs->contains($slug));
        } else {
            $slug = $originalSlug;
        }

        return $slug;
    }
}

function check_subscription($user, $type, $status)
{
    DB::enableQueryLog();
    $current_package = UserPurchasedPackage::where('modal_id', $user)
        // ->with(['package' => function ($q) use ($type) {
        //     $q->select('id', $type)->where($type, '>', 0)->orWhere($type, null);
        // }])

        ->whereHas('package', function ($q) use ($type) {
            $q->where($type, '>', 0)->orWhere($type, null);
        })->where($status, 1)
        ->first();
    // dd(DB::getQueryLog());

    return $current_package;
}
function store_image($file, $path)
{
    $destinationPath = public_path('images') . config('global.' . $path);
    if (!is_dir($destinationPath)) {
        mkdir($destinationPath, 0777, true);
    }

    // Check if the file is an instance of UploadedFile
    if ($file instanceof \Illuminate\Http\UploadedFile) {
        $originalName = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $extension = $file->getClientOriginalExtension();

        // Initialize the filename
        $filename = $originalName . '.' . $extension;

        // Check if the file already exists
        $counter = 1;
        while (file_exists($destinationPath . '/' . $filename)) {
            // Append a number to the filename
            $filename = $originalName . '_' . $counter . '.' . $extension;
            $counter++;
        }

        $file->move($destinationPath, $filename);
        return $filename;
    } else {
        // Handle the case when the file is not an instance of UploadedFile
        // You can log an error or throw an exception here
        // For now, we return null
        return null;
    }
}
function unlink_image($url)
{
    $relativePath = parse_url($url, PHP_URL_PATH);
    // dd(file_exists(public_path()  . $relativePath));
    if (file_exists(public_path()  . $relativePath)) {
        unlink(public_path()  . $relativePath);
    }
}
