<?php $__env->startSection('title'); ?>
    <?php echo e(__('Packages')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>

            </div>
            <div class="col-12 col-md-6 order-md-2 order-first">

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="row">
            <?php if(has_permissions('create', 'package')): ?>
                <div class="col-12">
                    <div class="card">

                        <div class="card">
                            <?php echo Form::open(['route' => 'package.store', 'data-parsley-validate', 'class' => 'create-form', 'data-success-function'=> "formSuccessFunction"]); ?>

                            <div class="card-body">
                                <div class="row ">
                                    
                                    <div class="col-md-6 col-lg-4 form-group mandatory">
                                        <?php echo e(Form::label('name', __('Package Name'), ['class' => 'form-label'])); ?>

                                        <?php echo e(Form::text('name', '', [
                                            'class' => 'form-control ',
                                            'placeholder' => trans('Package Name'),
                                            'data-parsley-required' => 'true',
                                            'id' => 'name',
                                        ])); ?>

                                    </div>

                                    
                                    <div class="col-md-6 col-lg-4 form-group">
                                        <?php echo e(Form::label('ios_product_id', __('IOS Product ID'), ['class' => 'form-label'])); ?>

                                        <?php echo e(Form::text('ios_product_id', '', [
                                            'class' => 'form-control ',
                                            'placeholder' => trans('IOS Product ID'),
                                            'id' => 'ios_product_id',
                                        ])); ?>

                                    </div>

                                    
                                    <div class="col-md-6 col-lg-4 form-group mandatory">
                                        <?php echo e(Form::label('duration', __('Duration'), ['class' => 'form-label'])); ?>

                                        <?php echo e(Form::number('duration', '', [
                                            'class' => 'form-control ',
                                            'placeholder' => trans('Duration (in hours)'),
                                            'data-parsley-required' => 'true',
                                            'id' => 'duration',
                                            'min' => '1',
                                        ])); ?>

                                    </div>

                                    
                                    <div class="col-md-6 col-lg-4 form-group mandatory">
                                        <?php echo e(Form::label('', __('Package Type'), ['class' => 'form-label col-12 '])); ?>


                                        
                                        <?php echo e(Form::radio('package_type', 'paid', null, [ 'class' => 'form-check-input package-type', 'data-parsley-required' => 'true', 'id' => 'package-type-paid', 'checked' => true ])); ?>

                                        <?php echo e(Form::label('package-type-paid', __('Paid'), ['class' => 'form-check-label'])); ?>


                                        
                                        <?php echo e(Form::radio('package_type', 'free', null, [ 'class' => 'form-check-input package-type', 'data-parsley-required' => 'true', 'id' => 'package-type-free' ])); ?>

                                        <?php echo e(Form::label('package-type-free', __('Free'), ['class' => 'form-check-label'])); ?>

                                    </div>


                                    
                                    <div class="col-md-6 col-lg-4 form-group mandatory price-div">
                                        <?php echo e(Form::label('price', __('Price') . '(' . $currency_symbol . ')', [ 'class' => 'form-label'])); ?>

                                        <?php echo e(Form::number('price', '', [
                                            'class' => 'form-control ',
                                            'placeholder' => trans('Price'),
                                            'id' => 'price',
                                            'data-parsley-required' => 'true',
                                            'min' => '0',
                                            'step' => '0.01'
                                        ])); ?>

                                    </div>
                                </div>

                                <hr>
                                
                                <div class="feature-sections">
                                    <div class="mt-4" data-repeater-list="feature_data">
                                        <div class="col-md-5 pl-0 mb-4">
                                            <button type="button" class="btn btn-success add-new-feature" data-repeater-create title="Add new row">
                                                <span><i class="fa fa-plus"></i> <?php echo e(__('Add New Feature')); ?></span>
                                            </button>
                                        </div>
                                        <div class="row feature-section" data-repeater-item>
                                            
                                            <div class="form-group mandatory col-md-6 col-lg-4">
                                                <label><?php echo e(__('Select Feature')); ?> <span class="text-danger">*</span></label>
                                                <select name="feature_id" class="form-control form-select" required>
                                                    <option value=""><?php echo e(trans('Select Option')); ?></option>
                                                    <?php $__currentLoopData = $featuresList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($feature->id); ?>"> <?php echo e($feature->name); ?> </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>

                                            
                                            <div class="form-group mandatory col-md-6 col-lg-3">
                                                <?php echo e(Form::label('', __('Type'), ['class' => 'form-label col-12 '])); ?>


                                                
                                                <?php echo e(Form::radio('type', 'unlimited', null, [ 'class' => 'form-check-input feature-type feature-type-unlimited', 'required' => true ])); ?>

                                                <?php echo e(Form::label('', __('Unlimited'), ['class' => 'form-check-label feature-type-unlimited-label'])); ?>


                                                
                                                <?php echo e(Form::radio('type', 'limited', null, [ 'class' => 'form-check-input feature-type feature-type-limited', 'required' => true ])); ?>

                                                <?php echo e(Form::label('', __('Limited'), ['class' => 'form-check-label feature-type-limited-label'])); ?>

                                            </div>

                                            
                                            <div class="col-md-5 col-lg-4 form-group mandatory limit-div" style="display: none">
                                                <?php echo e(Form::label('', __('Limited'), ['class' => 'form-label'])); ?>

                                                <?php echo Form::text('limit', '', ['min' => 1, 'class' => 'form-control limit', 'placeholder' => trans('Enter your limit')]); ?>

                                            </div>

                                            
                                            <div class="form-group col-md-1 pl-0 mt-4" style="display: none">
                                                <button data-repeater-delete type="button" class="btn btn-icon btn-danger remove-default-option" title="<?php echo e(__('Remove Option')); ?>" disabled>
                                                    <i class="fa fa-times"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr>

                                <div class="col-12 form-group mt-2">
                                    <?php echo e(Form::submit(trans('Add Package'), ['class' => 'center btn btn-primary'])); ?>

                                </div>

                            </div>
                            <?php echo Form::close(); ?>

                        </div>

                    </div>
                </div>
            <?php endif; ?>
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table table-striped"
                                    id="table_list" data-toggle="table" data-url="<?php echo e(route('package.show',1)); ?>"
                                    data-click-to-select="true" data-side-pagination="server" data-pagination="true"
                                    data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true"
                                    data-search-align="right" data-toolbar="#toolbar" data-show-columns="true"
                                    data-show-refresh="true" data-trim-on-search="false" data-responsive="true"
                                    data-sort-name="id" data-sort-order="desc" data-pagination-successively-size="3"
                                    data-query-params="queryParams">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th scope="col" data-field="id" data-align="center" data-sortable="true"> <?php echo e(__('ID')); ?></th>
                                            <th scope="col" data-field="ios_product_id" data-align="center" data-sortable="true"> <?php echo e(__('IOS Product ID')); ?> </th>
                                            <th scope="col" data-field="name" data-align="center" data-sortable="true"> <?php echo e(__('Name')); ?> </th>
                                            <th scope="col" data-field="duration" data-align="center" data-sortable="false"> <?php echo e(__('Duration')); ?></th>
                                            <th scope="col" data-field="package_type" data-align="center" data-sortable="false" data-formatter="packageTypeFormatter"> <?php echo e(__('Package Type')); ?> </th>
                                            <th scope="col" data-field="price" data-align="center" data-sortable="false"> <?php echo e(__('Price')); ?> </th>
                                            <th scope="col" data-field="package_features" data-sortable="false" data-formatter="packageFeaturesFormatter"> <?php echo e(__('Features')); ?> </th>
                                            <?php if(has_permissions('update', 'package')): ?>
                                                <th scope="col" data-field="status" data-sortable="false" data-align="center" data-width="5%" data-formatter="enableDisableSwitchFormatter"> <?php echo e(__('Enable/Disable')); ?></th>
                                                <th scope="col" data-field="operate" data-align="center" data-sortable="false" data-events="actionEvents"> <?php echo e(__('Action')); ?></th>
                                            <?php else: ?>
                                                <th scope="col" data-field="status" data-sortable="true" data-align="center" data-width="5%" data-formatter="yesNoStatusFormatter"> <?php echo e(__('Is Active ?')); ?></th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>

        <!-- EDIT MODEL MODEL -->
        <div id="editModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel1"><?php echo e(__('Edit Package')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(url('package-update')); ?>" class="form-horizontal edit-form" enctype="multipart/form-data" method="POST">
                        <div class="modal-body">
                            <?php echo e(csrf_field()); ?>

                            <input type="hidden" id="edit_id" name="edit_id">
                            <div class="row">
                                
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="edit_name" class="form-label col-12 "><?php echo e(__('Package Name')); ?></label>
                                        <input type="text" id="edit_name" class="form-control col-12" placeholder="<?php echo e(__('Package Name')); ?>" name="edit_name" required>
                                    </div>
                                </div>

                                
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="edit_ios_product_id" class="form-label col-12 "><?php echo e(__('IOS Product ID')); ?></label>
                                        <input type="text" id="edit_ios_product_id" class="form-control col-12" placeholder="<?php echo e(__('IOS Product ID')); ?>" name="edit_ios_product_id">
                                    </div>
                                </div>

                                
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="edit_duration" class="form-label col-12 "><?php echo e(__('Duration')); ?></label>
                                        <input type="text" id="edit_duration" class="form-control col-12" placeholder="<?php echo e(__('Duration')); ?>" name="edit_duration" min="1" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            <button type="submit" class="btn btn-primary waves-effect waves-light"><?php echo e(__('Save')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- EDIT MODEL -->
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function () {
            $('.package-type').on('click',function(e){
                if($(this).val() == 'paid'){
                    $('.price-div').show();
                    $("#price").attr('data-parsley-required',true);
                }else{
                    $("#price").removeAttr('data-parsley-required');
                    $('.price-div').hide();
                }
            })
        });
        $(document).on('change','.feature-type',function (e) {
            let value = $(this).val();
            if(value == 'limited'){
                $(this).parent().parent().find('.limit-div').show()
                $(this).parent().parent().find('.limit-div').find('.limit').attr('data-parsley-required',true)
            }else{
                $(this).parent().parent().find('.limit-div').find('.limit').removeAttr('data-parsley-required')
                $(this).parent().parent().find('.limit-div').hide()
            }

        })
        function queryParams(p) {

            return {
                sort: p.sort,
                order: p.order,
                offset: p.offset,
                limit: p.limit,
                search: p.search,

            };
        }

        function chk(checkbox) {
            if (checkbox.checked) {

                active(event.target.id);

            } else {

                disable(event.target.id);
            }
        }
        window.actionEvents = {
            'click .edit_btn': function(e, value, row, index) {
                $("#edit_id").val(row.id);
                $("#edit_ios_product_id").val(row.ios_product_id);
                $("#edit_name").val(row.name);
                $("#edit_duration").val(row.duration);
                $('#status').val(row.status);
            }
        }
    </script>

    <script>
        window.onload = function() {

            $('#limitation_for_property').hide();

            $('#limitation_for_advertisement').hide();
            $('.limitations').hide();

        }


        $('input[type="radio"][name="package_type"]').click(function() {
            if ($(this).is(':checked')) {
                if ($(this).val() == 'product_listing') {
                    $('.limitations').show();
                } else {
                    $('.limitations').hide();

                }
            }

        });

        $('input[type="radio"][name="typep"]').click(function() {


            if ($(this).is(':checked')) {
                if ($(this).val() == 'add_limited_property') {
                    $('#limitation_for_property').show();
                    $('#propertylimit').attr('required', 'true');
                } else {
                    $('#limitation_for_property').hide();
                    $('#propertylimit').removeAttr('required');
                }
            }
        });
        $('input[type="radio"][name="typel"]').click(function() {

            if ($(this).is(':checked')) {
                if ($(this).val() == 'add_limited_advertisement') {

                    $('#limitation_for_advertisement').show();
                    $('#advertisementlimit').attr("required", "true");
                } else {
                    $('#limitation_for_advertisement').hide();
                    $('#advertisementlimit').removeAttr("required");
                }
            }
        });


        function disable(id) {
            $.ajax({
                url: "<?php echo e(route('package.updatestatus')); ?>",
                type: "POST",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>",
                    "id": id,
                    "status": 0,
                },
                cache: false,
                success: function(result) {
                    let text = '<?php echo e(trans("Package OFF Successfully")); ?>';
                    if (result.error == false) {
                        Toastify({
                            text: text,
                            duration: 6000,
                            close: !0,
                            backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)"
                        }).showToast();
                        $('#table_list').bootstrapTable('refresh');
                    } else {
                        Toastify({
                            text: result.message,
                            duration: 6000,
                            close: !0,
                            backgroundColor: '#dc3545' //"linear-gradient(to right, #dc3545, #96c93d)"

                        }).showToast();
                        $('#table_list').bootstrapTable('refresh');
                    }

                },
                error: function(error) {

                }
            });
        }

        function active(id) {
            $.ajax({
                url: "<?php echo e(route('package.updatestatus')); ?>",
                type: "POST",
                data: {
                    '_token': "<?php echo e(csrf_token()); ?>",
                    "id": id,
                    "status": 1,
                },
                cache: false,
                success: function(result) {

                    if (result.error == false) {
                        let text = '<?php echo e(trans("Package On Successfully")); ?>';
                        Toastify({
                            text: text,
                            duration: 6000,
                            close: !0,
                            backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)"
                        }).showToast();
                        $('#table_list').bootstrapTable('refresh');
                    } else {
                        Toastify({
                            text: result.message,
                            duration: 6000,
                            close: !0,
                            backgroundColor: "linear-gradient(to right, #00b09b, #96c93d)"
                        }).showToast();
                        $('#table_list').bootstrapTable('refresh');
                    }

                },
                error: function(error) {

                }
            });
        }

        let formSuccessFunction = () => {
            setTimeout(() => {
                window.location.reload();
            }, 1000);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wrteam-dev/ebroker/resources/views/packages/index.blade.php ENDPATH**/ ?>