# Core v5.4.1
**Release Date:** August 4, 2025  
**Tags:** BUG FIXES, API IMPROVEMENTS, PROVIDER UPDATES

## Bug Fixes

### XT Provider Network Mapping
- **Fixed** incorrect network name mappings for XT exchange provider in spot deposits
- **Updated** `mapToXtNetwork` function to use XT's official network naming convention
- **Added** comprehensive network mappings based on XT API documentation:
  - BSC/BEP20 → `BNB Smart Chain`
  - TRC20/TRX → `Tron`
  - ERC20/ETH → `Ethereum`
  - POLYGON/MATIC → `Polygon`
  - ARBITRUM/ARB → `ARB`
  - OPTIMISM/OPT → `OPT`
  - AVAX/AVALANCHE → `AVAX C-Chain`
  - SOL/SOLANA → `SOL-SOL`
  - BTC/BITCOIN → `Bitcoin`
  - LTC/LITECOIN → `Litecoin`
  - And more...

### ECO Wallet Withdrawal Routing
- **Fixed** ECO wallet withdrawals incorrectly routing to spot API endpoint
- **Updated** withdrawal store to properly route ECO withdrawals to `/api/ecosystem/withdraw`
- **Separated** withdrawal logic for SPOT and ECO wallet types for proper API routing

## Technical Details

### Files Modified
- `backend/src/api/finance/deposit/spot/utils.ts` - Updated network mapping function
- `frontend/store/finance/withdraw-store.ts` - Fixed ECO withdrawal routing

### Impact
- Users can now successfully deposit to XT exchange with proper network selection
- ECO wallet withdrawals now process correctly through the appropriate API endpoint
- Improved compatibility with XT exchange's API requirements